/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.inspector.CallInspector;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.server.admin.inspector.info.CallInfo;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;

public class CallsView
extends DefaultView {
    private CallInspector m_selectedCall;

    public CallsView(AdminSession as) {
        super(as);
    }

    public CallInspector getSelectedCall() {
        return this.m_selectedCall;
    }

    @Override
    public boolean isVisible() {
        return ProcessInspector.getDefault().isEnabled() && this.getAdminSession().getTopView().getSessionsView().getSelectedSession() != null;
    }

    @Override
    public void produceTitle(HtmlComponent p) {
        SessionInspector session = this.getAdminSession().getTopView().getSessionsView().getSelectedSession();
        p.print("Calls of " + (session != null ? String.valueOf(session.getInfo().getUserId()) + "/" + session.getInfo().getSessionId() : "?"));
    }

    @Override
    public void produceBody(HtmlComponent p) {
        final SessionInspector session = this.getAdminSession().getTopView().getSessionsView().getSelectedSession();
        p.linkAction("Clear calls", new AbstractHtmlAction("clearCalls"){

            @Override
            public void run() {
                session.clearCallInspectors();
            }
        });
        p.p();
        p.startTable(0, 5, 5);
        p.startTableRow();
        p.startTableCell();
        this.renderCallTable(p, session);
        p.startTableCell();
        if (this.m_selectedCall != null) {
            this.renderCallDetail(p, this.m_selectedCall);
        }
        p.endTableCell();
        p.endTableRow();
        p.endTable();
    }

    private void renderCallTable(HtmlComponent p, SessionInspector session) {
        TreeMap<CompositeObject, CallInspector> timeToCalls = new TreeMap<CompositeObject, CallInspector>();
        CallInspector[] callInspectors = session.getCallInspectors();
        int i = 0;
        while (i < callInspectors.length) {
            long startTime = callInspectors[i].getInfo().getStartTime();
            timeToCalls.put(new CompositeObject(new Object[]{startTime, i}), callInspectors[i]);
            ++i;
        }
        CallInspector[] sorted = timeToCalls.values().toArray(new CallInspector[timeToCalls.size()]);
        p.bold("Calls");
        p.startTable(1, 0, 3);
        p.startTableRow();
        p.tableHeaderCell("#");
        p.tableHeaderCell("Operation");
        p.tableHeaderCell("Started");
        p.tableHeaderCell("Duration");
        p.tableHeaderCell("Status");
        p.endTableRow();
        CallInspector validSelection = null;
        int i2 = sorted.length - 1;
        while (i2 >= 0) {
            if (sorted[i2] == this.m_selectedCall) {
                validSelection = this.m_selectedCall;
            }
            this.renderCallRow(p, i2 + 1, sorted[i2]);
            --i2;
        }
        this.m_selectedCall = validSelection;
        p.endTable();
    }

    private void renderCallRow(HtmlComponent p, int index, final CallInspector call) {
        boolean selected = this.m_selectedCall != null && this.m_selectedCall == call;
        SimpleDateFormat startFmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String serviceShortName = call.getInfo().getService();
        int i = Math.max(serviceShortName.lastIndexOf(46), serviceShortName.lastIndexOf(36));
        if (i >= 0) {
            serviceShortName = serviceShortName.substring(i + 1);
        }
        CallInfo info = call.getInfo();
        p.startTableRow();
        p.tableCell("" + index);
        p.startTableCell();
        String callId = String.valueOf(serviceShortName) + "." + info.getOperation();
        String callKey = String.valueOf(serviceShortName) + "." + info.getOperation() + "." + info.getStartTime();
        if (selected) {
            p.focusAnchor();
        }
        p.startLinkAction(new AbstractHtmlAction("selectCall." + callKey){

            @Override
            public void run() {
                CallsView.this.m_selectedCall = call;
            }
        });
        if (selected) {
            p.bold(callId);
        } else {
            p.print(callId);
        }
        p.endLinkAction();
        p.endTableCell();
        p.startTableCell();
        p.printNoBreak(startFmt.format(new Date(info.getStartTime())));
        p.endTableCell();
        p.startTableCell();
        p.printNoBreak(info.getDuration() + " ms");
        p.endTableCell();
        p.startTableCell();
        if (info.isActive()) {
            p.printNoBreak("RUNNING");
        } else if (info.getReturnException() == null) {
            p.raw("<font color='008800'>");
            p.printNoBreak("COMPLETED OK");
            p.raw("</font>");
        } else {
            p.raw("<font color='880000'>");
            p.printNoBreak("COMPLETED WITH ERROR");
            p.raw("</font>");
        }
        p.endTableCell();
        p.endTableRow();
    }

    private void renderCallDetail(HtmlComponent p, CallInspector call) {
        SimpleDateFormat startFmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        CallInfo info = call.getInfo();
        p.startTable(0);
        p.startTableRow();
        p.tableCell("Service");
        p.tableCell(info.getService());
        p.endTableRow();
        p.spacingRow(2);
        p.startTableRow();
        p.tableCell("Operation");
        p.tableCell(info.getOperation());
        p.endTableRow();
        p.spacingRow(2);
        p.startTableRow();
        p.tableCell("Start");
        p.tableCell(startFmt.format(new Date(info.getStartTime())));
        p.endTableRow();
        p.spacingRow(2);
        p.startTableRow();
        p.tableCell("End");
        if (info.isActive()) {
            p.tableCell("PENDING");
        } else {
            p.tableCell(startFmt.format(new Date(info.getEndTime())));
        }
        p.endTableRow();
        p.spacingRow(2);
        p.startTableRow();
        p.tableCell("Duration");
        p.tableCell(String.valueOf(info.getDuration()) + " ms");
        p.endTableRow();
        p.spacingRow(2);
        p.startTableRow();
        p.tableCell("XA&nbsp;resources");
        p.startTableCell();
        ITransactionMember[] xaresources = info.getXaResources();
        this.renderValueTable(p, xaresources);
        p.endTableCell();
        p.endTableRow();
        if (!info.isActive()) {
            p.spacingRow(2);
            p.startTableRow();
            p.tableCell("Arguments");
            p.startTableCell();
            this.renderValueTable(p, info.getArguments());
            p.endTableCell();
            p.endTableRow();
            if (info.getReturnException() == null) {
                p.spacingRow(2);
                p.startTableRow();
                p.tableCell("Out&nbsp;variables");
                p.startTableCell();
                this.renderValueTable(p, info.getOutVariables());
                p.endTableCell();
                p.endTableRow();
                p.spacingRow(2);
                p.startTableRow();
                p.tableCell("Return&nbsp;data");
                p.startTableCell();
                this.renderValueTable(p, new Object[]{info.getReturnData()});
                p.endTableCell();
                p.endTableRow();
            } else {
                StringWriter sw = new StringWriter();
                info.getReturnException().printStackTrace(new PrintWriter((Writer)sw, true));
                p.spacingRow(2);
                p.startTableRow();
                p.tableCell("Return&nbsp;exception");
                p.tableCell(sw.toString());
                p.endTableRow();
            }
        }
        p.endTable();
    }

    protected void renderValueTable(HtmlComponent p, Object o) {
        boolean singleValue = o == null ? true : (o.getClass().isArray() ? false : (o instanceof Map ? false : !(o instanceof Collection)));
        if (o == null || singleValue) {
            p.print("" + o);
        } else {
            p.startTable(1);
            p.startTableRow();
            p.tableHeaderCell("Name");
            p.tableHeaderCell("Type");
            p.tableHeaderCell("Value");
            p.endTableRow();
            if (o.getClass().isArray()) {
                int len = Array.getLength(o);
                int i = 0;
                while (i < len) {
                    this.renderValueRow(p, "[" + i + "]", Array.get(o, i));
                    ++i;
                }
            } else if (o instanceof Map) {
                for (Map.Entry e : ((Map)o).entrySet()) {
                    this.renderValueRow(p, "{" + e.getKey() + "}", e.getValue());
                }
            } else if (o instanceof Collection) {
                int index = 0;
                for (Object value : (Collection)o) {
                    this.renderValueRow(p, "" + index, value);
                    ++index;
                }
            } else {
                this.renderValueRow(p, "", o);
            }
            p.endTable();
        }
    }

    protected void renderValueRow(HtmlComponent p, String name, Object value) {
        p.startTableRow();
        p.tableCell(name);
        p.tableCell(value != null ? value.getClass().getName() : "");
        p.startTableCell();
        this.renderValueTable(p, value);
        p.endTableCell();
        p.endTableRow();
    }
}

