/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.security.Permission;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlTable;
import org.eclipse.scout.rt.server.admin.html.widget.table.SortInfo;
import org.eclipse.scout.rt.server.admin.html.widget.table.VirtualRow;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.shared.security.UpdateServiceConfigurationPermission;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;

public class SessionsView
extends DefaultView {
    private SessionInspector m_selectedSession;
    private SortInfo m_table1SortInfo = new SortInfo();

    public SessionsView(AdminSession as) {
        super(as);
    }

    public SessionInspector getSelectedSession() {
        return this.m_selectedSession;
    }

    @Override
    public boolean isVisible() {
        return ACCESS.check((Permission)new UpdateServiceConfigurationPermission()) && ProcessInspector.getDefault().isEnabled();
    }

    @Override
    public void produceTitle(HtmlComponent p) {
        p.print("Sessions");
    }

    @Override
    public void produceBody(HtmlComponent p) {
        p.linkAction("Clear sessions", new AbstractHtmlAction("clearSessions"){

            @Override
            public void run() {
                ProcessInspector.getDefault().clearSessionInspectors();
            }
        });
        p.p();
        this.renderSessionTable(p);
    }

    private void renderSessionTable(HtmlComponent p) {
        SessionInspector[] sessionInspectors = ProcessInspector.getDefault().getSessionInspectors();
        TreeMap<CompositeObject, SessionInspector> userAndTimeToSessions = new TreeMap<CompositeObject, SessionInspector>();
        int i = 0;
        while (i < sessionInspectors.length) {
            String user = sessionInspectors[i].getInfo().getUserId();
            long lastAccess = sessionInspectors[i].getInfo().getLastAccessedTime();
            userAndTimeToSessions.put(new CompositeObject(new Object[]{lastAccess, user, i}), sessionInspectors[i]);
            ++i;
        }
        SessionInspector[] sorted = userAndTimeToSessions.values().toArray(new SessionInspector[userAndTimeToSessions.size()]);
        HtmlTable table1 = new HtmlTable(p, "table1", this.m_table1SortInfo);
        table1.startTable(1, 0, 3);
        table1.startTableRow();
        table1.tableHeaderCell("#");
        table1.tableHeaderCell("User");
        table1.tableHeaderCell("SessionID");
        table1.tableHeaderCell("Details");
        table1.tableHeaderCell("Created");
        table1.tableHeaderCell("Last&nbsp;accessed");
        table1.tableHeaderCell("JAAS");
        table1.endTableRow();
        SessionInspector validSelection = null;
        int i2 = sorted.length - 1;
        while (i2 >= 0) {
            if (sorted[i2] == this.m_selectedSession) {
                validSelection = this.m_selectedSession;
            }
            VirtualRow vrow = table1.addVirtualRow();
            this.renderSessionRow(vrow, i2 + 1, sorted[i2]);
            --i2;
        }
        table1.appendVirtualRows();
        this.m_selectedSession = validSelection;
        table1.endTable();
        p.append(table1);
    }

    private void renderSessionRow(HtmlComponent p, int index, final SessionInspector session) {
        boolean selected = this.m_selectedSession != null && this.m_selectedSession == session;
        SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        p.startTableRow();
        p.tableCell("" + index);
        p.tableCell(session.getInfo().getUserId());
        p.startTableCell();
        if (selected) {
            p.focusAnchor();
        }
        p.startLinkAction(new AbstractHtmlAction("selectSession" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
            }
        });
        p.print(session.getInfo().getSessionId());
        p.endLinkAction();
        p.endTableCell();
        p.startTableCell();
        p.startLinkAction(new AbstractHtmlAction("showServicesOf" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
                SessionsView.this.getAdminSession().getTopView().showServices();
            }
        });
        p.print("Services");
        p.endLinkAction();
        p.raw("&nbsp;");
        p.startLinkAction(new AbstractHtmlAction("showCallsOf" + session.getInfo().getSessionId()){

            @Override
            public void run() {
                SessionsView.this.m_selectedSession = session;
                SessionsView.this.getAdminSession().getTopView().showCalls();
            }
        });
        p.print("Calls");
        p.endLinkAction();
        p.endTableCell();
        p.startTableCell();
        p.printNoBreak(fmt.format(new Date(session.getInfo().getCreationTime())));
        p.endTableCell();
        p.startTableCell();
        p.printNoBreak(fmt.format(new Date(session.getInfo().getLastAccessedTime())));
        p.endTableCell();
        p.startTableCell();
        try {
            Subject subject = session.getInfo().getSubject();
            if (subject != null) {
                int i = 0;
                for (Principal principal : subject.getPrincipals()) {
                    if (principal == null) continue;
                    if (i > 0) {
                        p.br();
                    }
                    String s = "principal[" + i + "] name=" + principal.getName() + " toString=" + principal.toString() + " class=" + principal.getClass();
                    s = s.replaceAll("[\\n\\r]+", " ");
                    p.printNoBreak(s);
                    ++i;
                }
            } else {
                p.printNoBreak("no subject available");
            }
        }
        catch (Exception e) {
            p.br();
            p.print("Exception: " + e);
        }
        p.endTableCell();
        p.endTableRow();
    }
}

