/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.internal.ServerApplicationContext;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
extends Plugin {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.eclipse.scout.rt.server";
    private static Activator plugin;
    private ProcessInspector m_processInspector;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.m_processInspector = new ProcessInspector();
        if (Platform.getBundle((String)"org.eclipse.scout.sdk") == null) {
            context.addBundleListener((BundleListener)new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent event) {
                    if (event.getType() == 2 && event.getBundle().equals(Activator.this.getBundle())) {
                        new Job("Product launcher"){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (Platform.getBundle((String)"org.eclipse.equinox.http.servletbridge") != null) {
                                    Activator.this.runProduct();
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.m_processInspector = null;
        plugin = null;
        super.stop(context);
    }

    public ProcessInspector getProcessInspector() {
        return this.m_processInspector;
    }

    private void runProduct() {
        IProduct product = Platform.getProduct();
        try {
            Object app = this.findApplicationClass(product);
            if (app instanceof IApplication) {
                ((IApplication)app).start((IApplicationContext)new ServerApplicationContext());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Object findApplicationClass(IProduct product) throws CoreException {
        IExtension xProd;
        IExtensionPoint xpProd;
        IExtensionRegistry reg;
        if (product != null && (reg = (IExtensionRegistry)SERVICES.getService(IExtensionRegistry.class)) != null && (xpProd = reg.getExtensionPoint("org.eclipse.core.runtime.products")) != null && (xProd = xpProd.getExtension(product.getId())) != null) {
            IConfigurationElement[] iConfigurationElementArray = xProd.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cProd = iConfigurationElementArray[n2];
                if (cProd.getName().equals("product")) {
                    IExtension xApp;
                    String appId = cProd.getAttribute("application");
                    IExtensionPoint xpApp = reg.getExtensionPoint("org.eclipse.core.runtime.applications");
                    if (xpApp != null && (xApp = xpApp.getExtension(appId)) != null) {
                        IConfigurationElement[] iConfigurationElementArray2 = xApp.getConfigurationElements();
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement[] iConfigurationElementArray3;
                            IConfigurationElement cApp = iConfigurationElementArray2[n4];
                            if (cApp.getName().equals("application") && (iConfigurationElementArray3 = cApp.getChildren("run")).length != 0) {
                                IConfigurationElement cRun = iConfigurationElementArray3[0];
                                return cRun.createExecutableExtension("class");
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

