/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler.internal.node;

import org.eclipse.scout.rt.server.scheduler.internal.node.AbstractNode;
import org.eclipse.scout.rt.server.scheduler.internal.node.INode;
import org.eclipse.scout.rt.server.scheduler.internal.visitor.IEvalVisitor;
import org.eclipse.scout.rt.server.scheduler.internal.visitor.IFormatVisitor;

public class SignalRef
extends AbstractNode
implements INode {
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final int WEEK = 5;
    public static final int MONTH = 6;
    public static final int YEAR = 7;
    public static final int DAY_OF_WEEK = 8;
    public static final int DAY_OF_MONTH_REVERSE = 9;
    public static final int DAY_OF_YEAR = 10;
    public static final int SECOND_OF_DAY = 11;
    private int m_field;

    public SignalRef(int field) {
        this.m_field = field;
    }

    public int getField() {
        return this.m_field;
    }

    @Override
    public void format(IFormatVisitor v) {
        switch (this.m_field) {
            case 1: {
                v.print("second");
                break;
            }
            case 2: {
                v.print("minute");
                break;
            }
            case 3: {
                v.print("hour");
                break;
            }
            case 4: {
                v.print("day");
                break;
            }
            case 5: {
                v.print("week");
                break;
            }
            case 6: {
                v.print("month");
                break;
            }
            case 7: {
                v.print("year");
                break;
            }
            case 8: {
                v.print("dayOfWeek");
                break;
            }
            case 9: {
                v.print("dayOfMonthReverse");
                break;
            }
            case 10: {
                v.print("dayOfYear");
                break;
            }
            case 11: {
                v.print("secondOfDay");
            }
        }
    }

    @Override
    public Object eval(IEvalVisitor v) {
        switch (this.m_field) {
            case 1: {
                return v.getSignal().getSecond();
            }
            case 2: {
                return v.getSignal().getMinute();
            }
            case 3: {
                return v.getSignal().getHour();
            }
            case 4: {
                return v.getSignal().getDay();
            }
            case 5: {
                return v.getSignal().getWeek();
            }
            case 6: {
                return v.getSignal().getMonth();
            }
            case 7: {
                return v.getSignal().getYear();
            }
            case 8: {
                return v.getSignal().getDayOfWeek();
            }
            case 9: {
                return v.getSignal().getDayOfMonthReverse();
            }
            case 10: {
                return v.getSignal().getDayOfYear();
            }
            case 11: {
                return v.getSignal().getSecondOfDay();
            }
        }
        throw new IllegalArgumentException("unexpected field " + this.m_field);
    }
}

