/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.bookmark.AbstractBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;

public abstract class AbstractSqlBookmarkStorageService
extends AbstractBookmarkStorageService
implements IBookmarkStorageService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSqlBookmarkStorageService.class);
    private static final int KIND_MODEL = 99;

    @ConfigOperation
    @Order(value=10.0)
    protected Object[][] execSelectUserBookmarkFolder(Object userId) throws ProcessingException {
        return new Object[0][];
    }

    @ConfigOperation
    @Order(value=11.0)
    protected Object[][] execSelectGlobalBookmarkFolder() throws ProcessingException {
        return new Object[0][];
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execStoreUserBookmarkFolder(Object userId, long id, byte[] folderData) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=21.0)
    protected void execStoreGlobalBookmarkFolder(long id, byte[] folderData) throws ProcessingException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ConfigOperation
    @Order(value=30.0)
    protected BookmarkFolder execResolveBookmarkFolder(long id, Object binaryData) throws ProcessingException {
        BookmarkFolder bookmarkFolder;
        ObjectInputStream oin = null;
        try {
            byte[] bytesResolved = (byte[])binaryData;
            ByteArrayInputStream bin = new ByteArrayInputStream(bytesResolved);
            oin = new ObjectInputStream(bin);
            bookmarkFolder = (BookmarkFolder)oin.readObject();
            if (oin == null) return bookmarkFolder;
        }
        catch (Throwable t) {
            try {
                throw new ProcessingException("loading object" + id, t);
            }
            catch (Throwable throwable) {
                if (oin == null) throw throwable;
                try {
                    oin.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
        try {
            oin.close();
            return bookmarkFolder;
        }
        catch (Throwable throwable) {}
        return bookmarkFolder;
    }

    @Override
    protected BookmarkFolder readUserFolder(Object userId) throws ProcessingException {
        Object[][] data = this.execSelectUserBookmarkFolder(userId);
        int r = 0;
        while (r < data.length) {
            Object[] row = data[r];
            long id = ((Number)row[0]).longValue();
            try {
                BookmarkFolder folder = this.execResolveBookmarkFolder(id, row[1]);
                if (folder != null) {
                    folder.setId(id);
                    return folder;
                }
            }
            catch (ProcessingException p) {
                LOG.warn("invalid bookmark folder binary data for id=" + id + ": " + (Object)((Object)p));
            }
            ++r;
        }
        return null;
    }

    @Override
    protected BookmarkFolder readGlobalFolder() throws ProcessingException {
        Object[][] data = this.execSelectGlobalBookmarkFolder();
        int r = 0;
        while (r < data.length) {
            Object[] row = data[r];
            long id = ((Number)row[0]).longValue();
            try {
                BookmarkFolder folder = this.execResolveBookmarkFolder(id, row[1]);
                if (folder != null) {
                    folder.setId(id);
                    return folder;
                }
            }
            catch (ProcessingException p) {
                LOG.warn("invalid bookmark folder binary data for id=" + id + ": " + (Object)((Object)p));
            }
            ++r;
        }
        return null;
    }

    @Override
    protected void writeUserFolder(BookmarkFolder folder, Object userId) throws ProcessingException {
        ObjectOutputStream oout = null;
        try {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                oout = new ObjectOutputStream(bout);
                oout.writeObject(folder);
                oout.close();
                oout = null;
                this.execStoreUserBookmarkFolder(userId, folder.getId(), bout.toByteArray());
            }
            catch (IOException e) {
                throw new ProcessingException("storing user bookmarks", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected void writeGlobalFolder(BookmarkFolder folder) throws ProcessingException {
        ObjectOutputStream oout = null;
        try {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                oout = new ObjectOutputStream(bout);
                oout.writeObject(folder);
                oout.close();
                oout = null;
                this.execStoreGlobalBookmarkFolder(folder.getId(), bout.toByteArray());
            }
            catch (IOException e) {
                throw new ProcessingException("storing global bookmarks", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

