/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification.internal;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.ClientNotificationQueueEvent;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueListener;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;

public class ClientNotificationQueue {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationQueue.class);
    private EventListenerList m_listenerList = new EventListenerList();
    private LinkedList<QueueElement> m_queue;
    private Object m_queueLock = new Object();

    public ClientNotificationQueue() {
        this.m_queue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNotification(IClientNotification notification, IClientNotificationFilter filter) {
        if (notification == null) {
            throw new IllegalArgumentException("notification must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put " + notification + " for " + filter);
        }
        Object object = this.m_queueLock;
        synchronized (object) {
            Iterator it = this.m_queue.iterator();
            while (it.hasNext()) {
                QueueElement e = (QueueElement)it.next();
                if (!e.getFilter().isActive()) {
                    it.remove();
                    continue;
                }
                if (e.getClientNotification() == notification) {
                    it.remove();
                    continue;
                }
                if (e.getClientNotification().getClass() != notification.getClass() || !filter.equals(e.getFilter()) || !notification.coalesce(e.getClientNotification())) continue;
                it.remove();
            }
            this.m_queue.add(new QueueElement(notification, filter));
            this.m_queueLock.notifyAll();
        }
        this.fireEvent(notification, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IClientNotification[] getNextNotifications(long blockingTimeout) {
        long endTime = System.currentTimeMillis() + blockingTimeout;
        ArrayList<IClientNotification> list = new ArrayList<IClientNotification>();
        Object object = this.m_queueLock;
        synchronized (object) {
            while (true) {
                if (!this.m_queue.isEmpty()) {
                    Iterator it = this.m_queue.iterator();
                    while (it.hasNext()) {
                        QueueElement e = (QueueElement)it.next();
                        if (e.getFilter().isActive()) {
                            IServerSession serverSession = ThreadContext.get(IServerSession.class);
                            if (e.isConsumedBy(serverSession) || !e.getFilter().accept()) continue;
                            list.add(e.getClientNotification());
                            if (e.getFilter().isMulticast()) {
                                e.setConsumedBy(serverSession);
                                continue;
                            }
                            it.remove();
                            continue;
                        }
                        it.remove();
                    }
                }
                long dt = endTime - System.currentTimeMillis();
                if (list.size() > 0) return list.toArray(new IClientNotification[list.size()]);
                if (dt <= 0L) {
                    return list.toArray(new IClientNotification[list.size()]);
                }
                try {
                    this.m_queueLock.wait(dt);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void addClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_listenerList.add(IClientNotificationQueueListener.class, (EventListener)listener);
    }

    public void removeClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_listenerList.remove(IClientNotificationQueueListener.class, (EventListener)listener);
    }

    private void fireEvent(IClientNotification notification, IClientNotificationFilter filter) {
        IClientNotificationQueueListener[] listeners = (IClientNotificationQueueListener[])this.m_listenerList.getListeners(IClientNotificationQueueListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].queueChanged(new ClientNotificationQueueEvent(notification, filter, 10));
                ++i;
            }
        }
    }

    private class QueueElement {
        private IClientNotification m_notification;
        private IClientNotificationFilter m_filter;
        private Object m_consumedBySessionsLock;
        private WeakHashMap<IServerSession, Object> m_consumedBySessions;

        public QueueElement(IClientNotification notification, IClientNotificationFilter filter) {
            this.m_notification = notification;
            this.m_filter = filter;
            this.m_consumedBySessionsLock = new Object();
        }

        public IClientNotification getClientNotification() {
            return this.m_notification;
        }

        public IClientNotificationFilter getFilter() {
            return this.m_filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConsumedBy(IServerSession session) {
            if (session == null) {
                return false;
            }
            if (this.m_consumedBySessions == null) {
                return false;
            }
            Object object = this.m_consumedBySessionsLock;
            synchronized (object) {
                if (this.m_consumedBySessions != null) {
                    return this.m_consumedBySessions.containsKey(session);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConsumedBy(IServerSession session) {
            if (session != null) {
                Object object = this.m_consumedBySessionsLock;
                synchronized (object) {
                    if (this.m_consumedBySessions == null) {
                        this.m_consumedBySessions = new WeakHashMap();
                    }
                    this.m_consumedBySessions.put(session, null);
                }
            }
        }
    }
}

