/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEntityNodeData;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class DataModelEntityPartDefinition
implements DataModelConstants {
    private final Class<? extends IDataModelEntity> m_entityType;
    private final String m_whereClause;
    private final String m_selectClause;

    public DataModelEntityPartDefinition(Class<? extends IDataModelEntity> entityType, String whereClause) {
        this(entityType, whereClause, null);
    }

    public DataModelEntityPartDefinition(Class<? extends IDataModelEntity> entityType, String whereClause, String selectClause) {
        String tag;
        int n;
        int n2;
        String[] stringArray;
        this.m_entityType = entityType;
        this.m_whereClause = this.autoCompleteTags(whereClause);
        this.m_selectClause = this.autoCompleteTags(selectClause);
        if (this.m_whereClause != null) {
            stringArray = new String[]{"whereParts", "groupBy", "groupByParts", "havingParts"};
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                tag = stringArray[n];
                if (StringUtility.getTag((String)this.m_whereClause, (String)tag) == null) {
                    throw new IllegalArgumentException("whereClause must contain a " + tag + " tag");
                }
                ++n;
            }
        }
        if (this.m_selectClause != null) {
            stringArray = new String[]{"selectParts", "fromParts", "whereParts", "groupBy", "groupByParts", "havingParts"};
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                tag = stringArray[n];
                if (StringUtility.getTag((String)this.m_selectClause, (String)tag) == null) {
                    throw new IllegalArgumentException("selectClause must contain a " + tag + " tag");
                }
                ++n;
            }
        }
    }

    protected String autoCompleteTags(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtility.getTag((String)s, (String)"whereParts") == null) {
            s = String.valueOf(s) + " <whereParts/>";
        }
        if (StringUtility.getTag((String)s, (String)"groupBy") == null) {
            s = String.valueOf(s) + " <groupBy/>";
        }
        if (StringUtility.getTag((String)(s = s.replace("<groupBy/>", "<groupBy>GROUP BY <groupByParts/> HAVING 1=1 <havingParts/></groupBy>")), (String)"groupByParts") == null) {
            s = s.replaceAll("([^-a-zA-Z_$]HAVING[^-a-zA-Z_$])", " <groupByParts/>\n$1");
        }
        return s;
    }

    public String getSelectClause() {
        return this.m_selectClause;
    }

    public String getWhereClause() {
        return this.m_whereClause;
    }

    public Class<? extends IDataModelEntity> getEntityType() {
        return this.m_entityType;
    }

    public String createInstance(FormDataStatementBuilder builder, ComposerEntityNodeData entityNodeData, FormDataStatementBuilder.EntityStrategy strategy, String stm, Map<String, String> parentAliasMap) throws ProcessingException {
        return stm;
    }
}

