/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.ArrayList;
import java.util.List;

public class EntityContribution {
    private final List<String> m_selectParts = new ArrayList<String>(2);
    private final List<String> m_fromParts = new ArrayList<String>(2);
    private final List<String> m_whereParts = new ArrayList<String>(2);
    private final List<String> m_groupByParts = new ArrayList<String>(2);
    private final List<String> m_havingParts = new ArrayList<String>(2);

    public static EntityContribution create(String wherePart) {
        EntityContribution contrib = new EntityContribution();
        if (wherePart != null) {
            contrib.getWhereParts().add(wherePart);
        }
        return contrib;
    }

    public boolean isEmpty() {
        return this.m_selectParts.size() + this.m_fromParts.size() + this.m_whereParts.size() + this.m_groupByParts.size() + this.m_havingParts.size() == 0;
    }

    public void add(EntityContribution c) {
        if (c == null) {
            return;
        }
        this.getSelectParts().addAll(c.getSelectParts());
        this.getFromParts().addAll(c.getFromParts());
        this.getWhereParts().addAll(c.getWhereParts());
        this.getGroupByParts().addAll(c.getGroupByParts());
        this.getHavingParts().addAll(c.getHavingParts());
    }

    public List<String> getSelectParts() {
        return this.m_selectParts;
    }

    public List<String> getFromParts() {
        return this.m_fromParts;
    }

    public List<String> getWhereParts() {
        return this.m_whereParts;
    }

    public List<String> getGroupByParts() {
        return this.m_groupByParts;
    }

    public List<String> getHavingParts() {
        return this.m_havingParts;
    }
}

