/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.ListUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.NVPair;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.BindModel;
import org.eclipse.scout.commons.parsers.BindParser;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.AliasMapper;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.DataModelAttributePartDefinition;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.DataModelEntityPartDefinition;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.EntityContribution;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilderCheck;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.ValuePartDefinition;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerAttributeNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEitherOrNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEntityNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.DataModelUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class FormDataStatementBuilder
implements DataModelConstants {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FormDataStatementBuilder.class);
    private static final Pattern PLAIN_ATTRIBUTE_PATTERN = Pattern.compile("(<attribute>)([a-zA-Z_][a-zA-Z0-9_]*)(</attribute>)");
    private ISqlStyle m_sqlStyle;
    private IDataModel m_dataModel;
    private AliasMapper m_aliasMapper;
    private Map<Class<?>, DataModelAttributePartDefinition> m_dataModelAttMap;
    private Map<Class<?>, DataModelEntityPartDefinition> m_dataModelEntMap;
    private List<ValuePartDefinition> m_valueDefs;
    private Map<String, Object> m_bindMap;
    private AtomicInteger m_sequenceProvider;
    private StringBuffer m_where;

    public FormDataStatementBuilder(ISqlStyle sqlStyle) {
        this.m_sqlStyle = sqlStyle;
        this.m_aliasMapper = new AliasMapper();
        this.m_bindMap = new HashMap<String, Object>();
        this.m_dataModelAttMap = new HashMap();
        this.m_dataModelEntMap = new HashMap();
        this.m_valueDefs = new ArrayList<ValuePartDefinition>();
        this.setSequenceProvider(new AtomicInteger(0));
    }

    public IDataModel getDataModel() {
        return this.m_dataModel;
    }

    public void setDataModel(IDataModel dataModel) {
        this.m_dataModel = dataModel;
    }

    public AtomicInteger getSequenceProvider() {
        return this.m_sequenceProvider;
    }

    public void setSequenceProvider(AtomicInteger sequenceProvider) {
        this.m_sequenceProvider = sequenceProvider;
        this.m_aliasMapper.setSequenceProvider(this.m_sequenceProvider);
    }

    public void setValueDefinition(Class<?> fieldType, String sqlAttribute, int operator) {
        this.setValueDefinition(new ValuePartDefinition(fieldType, sqlAttribute, operator));
    }

    public void setValueDefinition(ClassIdentifier fieldTypeIdentifier, String sqlAttribute, int operator) {
        this.setValueDefinition(new ValuePartDefinition(fieldTypeIdentifier, sqlAttribute, operator));
    }

    public void setValueDefinition(Class<?> fieldType, String sqlAttribute, int operator, boolean plainBind) {
        this.setValueDefinition(new ValuePartDefinition(fieldType, sqlAttribute, operator, plainBind));
    }

    public void setValueDefinition(ClassIdentifier fieldTypeIdentifier, String sqlAttribute, int operator, boolean plainBind) {
        this.setValueDefinition(new ValuePartDefinition(fieldTypeIdentifier, sqlAttribute, operator, plainBind));
    }

    public void setValueDefinition(Class<?>[] fieldTypes, String sqlAttribute, int operator) {
        this.setValueDefinition(new ValuePartDefinition(fieldTypes, sqlAttribute, operator, false));
    }

    public void setValueDefinition(ClassIdentifier[] fieldTypeIdentifiers, String sqlAttribute, int operator) {
        this.setValueDefinition(new ValuePartDefinition(fieldTypeIdentifiers, sqlAttribute, operator, false));
    }

    public void setValueDefinition(ValuePartDefinition def) {
        this.m_valueDefs.add(def);
    }

    public void setDataModelAttributeDefinition(Class<? extends IDataModelAttribute> attributeType, String sqlAttribute) {
        this.setDataModelAttributeDefinition(attributeType, sqlAttribute, false);
    }

    public void setDataModelAttributeDefinition(Class<? extends IDataModelAttribute> attributeType, String sqlAttribute, boolean plainBind) {
        this.setDataModelAttributeDefinition(new DataModelAttributePartDefinition(attributeType, sqlAttribute, plainBind));
    }

    public void setDataModelAttributeDefinition(Class<? extends IDataModelAttribute> attributeType, String whereClause, String selectClause, boolean plainBind) {
        this.setDataModelAttributeDefinition(new DataModelAttributePartDefinition(attributeType, whereClause, selectClause, plainBind));
    }

    public void setDataModelAttributeDefinition(DataModelAttributePartDefinition def) {
        this.m_dataModelAttMap.put(def.getAttributeType(), def);
    }

    public void setDataModelEntityDefinition(Class<? extends IDataModelEntity> entityType, String whereClause) {
        this.setDataModelEntityDefinition(new DataModelEntityPartDefinition(entityType, whereClause));
    }

    public void setDataModelEntityDefinition(Class<? extends IDataModelEntity> entityType, String whereClause, String selectClause) {
        this.setDataModelEntityDefinition(new DataModelEntityPartDefinition(entityType, whereClause, selectClause));
    }

    public void setDataModelEntityDefinition(DataModelEntityPartDefinition def) {
        this.m_dataModelEntMap.put(def.getEntityType(), def);
    }

    public void setRootAlias(String entityName, String alias) {
        this.getAliasMapper().setRootAlias(entityName, alias);
    }

    protected FormDataStatementBuilderCheck createCheckInstance() {
        return new FormDataStatementBuilderCheck(this);
    }

    public void check(Object o) {
        FormDataStatementBuilderCheck c = this.createCheckInstance();
        c.checkRec(o);
        System.out.println(c.toString());
    }

    public String build(AbstractFormData formData) throws ProcessingException {
        this.m_where = new StringBuffer();
        Map fieldsBreathFirstMap = formData.getAllFieldsRec();
        Map propertiesBreathFirstMap = formData.getAllPropertiesRec();
        for (ValuePartDefinition def : this.m_valueDefs) {
            if (!def.accept(formData, fieldsBreathFirstMap, propertiesBreathFirstMap)) continue;
            ClassIdentifier[] valueTypes = def.getValueTypeClassIdentifiers();
            ArrayList<Object> valueDatas = new ArrayList<Object>(valueTypes.length);
            ArrayList<String> bindNames = new ArrayList<String>(valueTypes.length);
            ArrayList<Object> bindValues = new ArrayList<Object>(valueTypes.length);
            int i = 0;
            while (i < valueTypes.length) {
                if (AbstractFormFieldData.class.isAssignableFrom(valueTypes[i].getLastSegment())) {
                    AbstractFormFieldData field = formData.findFieldByClass(fieldsBreathFirstMap, valueTypes[i]);
                    valueDatas.add(field);
                    bindNames.add("" + (char)(97 + i));
                    if (field instanceof AbstractValueFieldData) {
                        bindValues.add(((AbstractValueFieldData)field).getValue());
                    } else {
                        bindValues.add(null);
                    }
                } else if (AbstractPropertyData.class.isAssignableFrom(valueTypes[i].getLastSegment())) {
                    AbstractPropertyData property = formData.findPropertyByClass(propertiesBreathFirstMap, valueTypes[i]);
                    valueDatas.add(property);
                    bindNames.add("" + (char)(97 + i));
                    bindValues.add(property.getValue());
                } else {
                    valueDatas.add(null);
                    bindNames.add("" + (char)(97 + i));
                    bindValues.add(null);
                }
                ++i;
            }
            Map<String, String> parentAliasMap = this.getAliasMapper().getRootAliases();
            String s = def.createInstance(this, valueDatas, bindNames, bindValues, parentAliasMap);
            if (s == null) continue;
            this.addWhere(" AND " + s, new NVPair[0]);
        }
        for (Map map : fieldsBreathFirstMap.values()) {
            for (AbstractFormFieldData f : map.values()) {
                EntityContribution contrib;
                if (!f.isValueSet() || !(f instanceof AbstractTreeFieldData) || (contrib = this.buildTreeNodes(((AbstractTreeFieldData)f).getRoots(), EntityStrategy.BuildConstraints, AttributeStrategy.BuildConstraintOfAttributeWithContext)).getWhereParts().size() == 0) continue;
                String wherePart = ListUtility.format(contrib.getWhereParts(), (String)" AND ");
                if (contrib.getFromParts().size() > 0) {
                    String fromPart = ListUtility.format(contrib.getFromParts(), (String)", ");
                    this.addWhere(" AND EXISTS (SELECT 1 FROM " + fromPart + " WHERE " + wherePart + ")", new NVPair[0]);
                    continue;
                }
                this.addWhere(" AND " + wherePart, new NVPair[0]);
            }
        }
        return this.getWhereConstraints();
    }

    protected boolean isZeroTraversingAttribute(int operation, Object[] values) {
        Number value1 = values != null && values.length > 0 && values[0] instanceof Number ? (Number)((Number)values[0]) : (Number)null;
        Number value2 = values != null && values.length > 1 && values[1] instanceof Number ? (Number)((Number)values[1]) : (Number)null;
        switch (operation) {
            case 20: {
                if (value1 == null) break;
                return value1.longValue() == 0L;
            }
            case 22: {
                if (value1 == null) break;
                return value1.doubleValue() <= 0.0;
            }
            case 23: {
                if (value1 == null) break;
                return value1.doubleValue() < 0.0;
            }
            case 25: {
                if (value1 == null) break;
                return value1.doubleValue() >= 0.0;
            }
            case 26: {
                if (value1 == null) break;
                return value1.doubleValue() > 0.0;
            }
            case 27: {
                if (value1 == null) break;
                return value1.longValue() != 0L;
            }
            case 45: {
                if (value1 != null && value2 != null) {
                    return value1.doubleValue() <= 0.0 && value2.doubleValue() >= 0.0;
                }
                if (value1 != null) {
                    return value1.doubleValue() <= 0.0;
                }
                if (value2 == null) break;
                return value2.doubleValue() >= 0.0;
            }
        }
        return false;
    }

    public AliasMapper getAliasMapper() {
        return this.m_aliasMapper;
    }

    public Map<String, Object> getBindMap() {
        return this.m_bindMap;
    }

    public ISqlStyle getSqlStyle() {
        return this.m_sqlStyle;
    }

    public void addBinds(String[] names, Object[] values) {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addBind(names[i], values[i]);
                ++i;
            }
        }
    }

    public void addBind(String name, Object value) {
        if (name != null && !name.startsWith("&")) {
            this.getBindMap().put(name, value);
        }
    }

    public void addWhere(String sql, NVPair ... customBinds) {
        if (sql != null) {
            this.m_where.append(" ");
            this.m_where.append(sql);
            NVPair[] nVPairArray = customBinds;
            int n = customBinds.length;
            int n2 = 0;
            while (n2 < n) {
                NVPair p = nVPairArray[n2];
                this.addBind(p.getName(), p.getValue());
                ++n2;
            }
        }
    }

    public List<ValuePartDefinition> getValuePartDefinitions() {
        return Collections.unmodifiableList(this.m_valueDefs);
    }

    public Map<Class<?>, DataModelAttributePartDefinition> getDataModelAttributePartDefinitions() {
        return Collections.unmodifiableMap(this.m_dataModelAttMap);
    }

    public Map<Class<?>, DataModelEntityPartDefinition> getDataModelEntityPartDefinitions() {
        return Collections.unmodifiableMap(this.m_dataModelEntMap);
    }

    public String getWhereConstraints() {
        return this.m_where.toString();
    }

    public String localizeBindName(String bindName, String prefix) {
        if (bindName != null) {
            String locName = String.valueOf(prefix) + bindName + this.getNextBindSeqNo();
            return locName;
        }
        return null;
    }

    public String localizeStatement(String stm, String oldBindName, String newBindName) {
        stm = stm.replaceAll("#" + oldBindName + "#", "#" + newBindName + "#");
        stm = stm.replaceAll("\\&" + oldBindName + "\\&", "&" + newBindName + "&");
        stm = stm.replaceAll(":" + oldBindName + "([^A-Za-z0-9_])", ":" + newBindName + "$1");
        stm = stm.replaceAll(":" + oldBindName + "$", ":" + newBindName);
        return stm;
    }

    protected long getNextBindSeqNo() {
        return this.m_sequenceProvider.incrementAndGet();
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends TreeNodeData> T getParentNodeOfType(TreeNodeData node, Class<T> type) {
        if (node != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            if ((node = node.getParentNode()) == null || !type.isAssignableFrom(node.getClass())) continue;
            return (T)node;
lbl5:
            // 2 sources

            ** while (node != null)
        }
lbl6:
        // 1 sources

        return null;
    }

    public AttributeKind getAttributeKind(TreeNodeData node) {
        if (!(node instanceof ComposerAttributeNodeData)) {
            return AttributeKind.Undefined;
        }
        ComposerAttributeNodeData attributeNode = (ComposerAttributeNodeData)node;
        Integer agg = attributeNode.getAggregationType();
        if (agg == null || agg == 0) {
            if (!this.isZeroTraversingAttribute(attributeNode.getOperator(), attributeNode.getValues())) {
                return AttributeKind.NonAggregationNonZeroTraversing;
            }
            return AttributeKind.NonAggregation;
        }
        if (!this.isZeroTraversingAttribute(attributeNode.getOperator(), attributeNode.getValues())) {
            return AttributeKind.AggregationNonZeroTraversing;
        }
        return AttributeKind.Aggregation;
    }

    public EntityContribution buildTreeNodes(List<TreeNodeData> nodes, EntityStrategy entityStrategy, AttributeStrategy attributeStrategy) throws ProcessingException {
        EntityContribution contrib = new EntityContribution();
        int i = 0;
        while (i < nodes.size()) {
            EntityContribution subContrib;
            if (nodes.get(i) instanceof ComposerEntityNodeData) {
                String s = this.buildComposerEntityNode((ComposerEntityNodeData)nodes.get(i), entityStrategy);
                if (s != null) {
                    contrib.getWhereParts().add(s);
                }
                ++i;
                continue;
            }
            if (nodes.get(i) instanceof ComposerAttributeNodeData) {
                subContrib = this.buildComposerAttributeNode((ComposerAttributeNodeData)nodes.get(i), attributeStrategy);
                if (!subContrib.isEmpty()) {
                    contrib.add(subContrib);
                }
                ++i;
                continue;
            }
            if (nodes.get(i) instanceof ComposerEitherOrNodeData) {
                ArrayList<ComposerEitherOrNodeData> orNodes = new ArrayList<ComposerEitherOrNodeData>();
                orNodes.add((ComposerEitherOrNodeData)nodes.get(i));
                int k = i;
                while (k + 1 < nodes.size() && nodes.get(k + 1) instanceof ComposerEitherOrNodeData && !((ComposerEitherOrNodeData)nodes.get(k + 1)).isBeginOfEitherOr()) {
                    orNodes.add((ComposerEitherOrNodeData)nodes.get(k + 1));
                    ++k;
                }
                EntityContribution subContrib2 = this.buildComposerOrNodes(orNodes, entityStrategy, attributeStrategy);
                if (!subContrib2.isEmpty()) {
                    contrib.add(subContrib2);
                }
                i = k + 1;
                continue;
            }
            subContrib = this.buildTreeNodes(nodes.get(i).getChildNodes(), entityStrategy, attributeStrategy);
            if (subContrib.isEmpty()) continue;
            contrib.add(subContrib);
        }
        return contrib;
    }

    protected EntityContribution buildComposerOrNodes(List<ComposerEitherOrNodeData> nodes, EntityStrategy entityStrategy, AttributeStrategy attributeStrategy) throws ProcessingException {
        EntityContribution contrib = new EntityContribution();
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (ComposerEitherOrNodeData node : nodes) {
            EntityContribution subContrib = this.buildTreeNodes(node.getChildNodes(), entityStrategy, attributeStrategy);
            contrib.getFromParts().addAll(subContrib.getFromParts());
            if (subContrib.getWhereParts().size() + subContrib.getHavingParts().size() <= 0) continue;
            if (count > 0) {
                buf.append(" OR ");
                if (node.isNegative()) {
                    buf.append(" NOT ");
                }
            }
            buf.append("(");
            buf.append(ListUtility.format((Collection)ListUtility.combine((Collection[])new Collection[]{subContrib.getWhereParts(), subContrib.getHavingParts()}), (String)" AND ").replaceAll("\\(\\+\\)", ""));
            buf.append(")");
            ++count;
        }
        if (count > 0) {
            if (count > 1) {
                buf.insert(0, "(");
                buf.append(")");
                contrib.getWhereParts().add(buf.toString());
            } else {
                String s = buf.toString();
                if (s.matches("\\(.*\\)")) {
                    s = s.substring(1, s.length() - 1).trim();
                }
                contrib.getWhereParts().add(s);
            }
        }
        return contrib;
    }

    public String buildComposerEntityNode(ComposerEntityNodeData node, EntityStrategy entityStrategy) throws ProcessingException {
        String baseStm;
        if (this.getDataModel() == null) {
            throw new ProcessingException("there is no data model set, call FormDataStatementBuilder.setDataModel to set one");
        }
        IDataModelEntity entity = DataModelUtility.externalIdToEntity((IDataModel)this.getDataModel(), (String)node.getEntityExternalId(), null);
        if (entity == null) {
            LOG.warn("no entity for external id: " + node.getEntityExternalId());
            return null;
        }
        DataModelEntityPartDefinition def = this.m_dataModelEntMap.get(entity.getClass());
        if (def == null) {
            LOG.warn("no PartDefinition for entity: " + entity);
            return null;
        }
        ComposerEntityNodeData parentEntityNode = FormDataStatementBuilder.getParentNodeOfType((TreeNodeData)node, ComposerEntityNodeData.class);
        Map<String, String> parentAliasMap = parentEntityNode != null ? this.m_aliasMapper.getNodeAliases(parentEntityNode) : this.m_aliasMapper.getRootAliases();
        switch (entityStrategy) {
            case BuildQuery: {
                baseStm = def.getSelectClause();
                break;
            }
            case BuildConstraints: {
                baseStm = def.getWhereClause();
                break;
            }
            default: {
                baseStm = null;
            }
        }
        String stm = null;
        if (baseStm != null) {
            stm = def.createInstance(this, node, entityStrategy, baseStm, parentAliasMap);
        }
        if (stm == null) {
            return null;
        }
        this.m_aliasMapper.addAllNodeEntitiesFrom(node, stm);
        stm = this.m_aliasMapper.replaceMarkersByAliases(stm, this.m_aliasMapper.getNodeAliases(node), parentAliasMap);
        String s = this.buildComposerEntityEitherOrSplit(entityStrategy, stm, node.isNegative(), node.getChildNodes());
        return s;
    }

    protected String buildComposerEntityEitherOrSplit(EntityStrategy entityStrategy, String baseStm, boolean negative, List<TreeNodeData> childParts) throws ProcessingException {
        ArrayList orBlocks = new ArrayList();
        ArrayList<TreeNodeData> otherParts = new ArrayList<TreeNodeData>();
        ArrayList<ComposerEitherOrNodeData> currentOrBlock = new ArrayList<ComposerEitherOrNodeData>();
        for (TreeNodeData ch : childParts) {
            if (ch instanceof ComposerEitherOrNodeData) {
                ComposerEitherOrNodeData composerEitherOrNodeData = (ComposerEitherOrNodeData)ch;
                if (composerEitherOrNodeData.isBeginOfEitherOr()) {
                    if (currentOrBlock.size() > 0) {
                        orBlocks.add(new ArrayList(currentOrBlock));
                    }
                    currentOrBlock.clear();
                }
                currentOrBlock.add(composerEitherOrNodeData);
                continue;
            }
            otherParts.add(ch);
        }
        if (currentOrBlock.size() > 0) {
            orBlocks.add(new ArrayList(currentOrBlock));
            currentOrBlock.clear();
        }
        if (orBlocks.size() > 0) {
            StringBuilder blockBuf = new StringBuilder();
            int blockCount = 0;
            for (List list : orBlocks) {
                int elemCount = 0;
                StringBuilder elemBuf = new StringBuilder();
                for (ComposerEitherOrNodeData orData : list) {
                    ArrayList<TreeNodeData> subList = new ArrayList<TreeNodeData>();
                    subList.addAll(otherParts);
                    subList.addAll(orData.getChildNodes());
                    String s = this.buildComposerEntityEitherOrSplit(entityStrategy, baseStm, negative ^ orData.isNegative(), subList);
                    if (s == null) continue;
                    if (elemCount > 0) {
                        elemBuf.append(" OR ");
                    }
                    elemBuf.append(" ( ");
                    elemBuf.append(s);
                    elemBuf.append(" ) ");
                    ++elemCount;
                }
                if (elemCount <= 0) continue;
                if (blockCount > 0) {
                    blockBuf.append(" AND ");
                }
                blockBuf.append(" ( ");
                blockBuf.append(elemBuf.toString());
                blockBuf.append(" ) ");
                ++blockCount;
            }
            if (blockCount > 0) {
                return blockBuf.toString();
            }
            return null;
        }
        return this.buildComposerEntityZeroTraversingSplit(entityStrategy, baseStm, negative, childParts);
    }

    protected String buildComposerEntityZeroTraversingSplit(EntityStrategy entityStrategy, String baseStm, boolean negative, List<TreeNodeData> childParts) throws ProcessingException {
        ArrayList<TreeNodeData> nonZeroChildren = new ArrayList<TreeNodeData>(2);
        for (TreeNodeData ch : childParts) {
            switch (this.getAttributeKind(ch)) {
                case Undefined: 
                case NonAggregationNonZeroTraversing: 
                case AggregationNonZeroTraversing: {
                    nonZeroChildren.add(ch);
                }
            }
        }
        String entityPart1 = this.buildComposerEntityUnit(entityStrategy, baseStm, negative, childParts);
        String entityPart2 = null;
        if (nonZeroChildren.size() < childParts.size()) {
            entityPart2 = this.buildComposerEntityUnit(entityStrategy, baseStm, !negative, nonZeroChildren);
        }
        if (entityPart2 != null) {
            return " ( " + entityPart1 + " OR " + entityPart2 + " ) ";
        }
        return entityPart1;
    }

    protected String buildComposerEntityUnit(EntityStrategy entityStrategy, String baseStm, boolean negative, List<TreeNodeData> childParts) throws ProcessingException {
        EntityContribution contrib = new EntityContribution();
        switch (entityStrategy) {
            case BuildConstraints: {
                ArrayList<TreeNodeData> nonAggregationParts = new ArrayList<TreeNodeData>(childParts.size());
                ArrayList<TreeNodeData> aggregationParts = new ArrayList<TreeNodeData>(2);
                for (TreeNodeData ch : childParts) {
                    switch (this.getAttributeKind(ch)) {
                        case Undefined: 
                        case NonAggregation: 
                        case NonAggregationNonZeroTraversing: {
                            nonAggregationParts.add(ch);
                            break;
                        }
                        case Aggregation: 
                        case AggregationNonZeroTraversing: {
                            aggregationParts.add(ch);
                        }
                    }
                }
                EntityContribution subContrib = this.buildTreeNodes(nonAggregationParts, entityStrategy, AttributeStrategy.BuildConstraintOfAttributeWithContext);
                contrib.add(subContrib);
                subContrib = this.buildTreeNodes(aggregationParts, entityStrategy, AttributeStrategy.BuildConstraintOfContext);
                contrib.add(subContrib);
                subContrib = this.buildTreeNodes(aggregationParts, entityStrategy, AttributeStrategy.BuildConstraintOfAttribute);
                contrib.add(subContrib);
                break;
            }
            case BuildQuery: {
                EntityContribution subContrib = this.buildTreeNodes(childParts, entityStrategy, AttributeStrategy.BuildQueryOfAttributeAndConstraintOfContext);
                contrib.add(subContrib);
            }
        }
        String entityPart = this.createEntityPart(baseStm, negative, contrib);
        return entityPart;
    }

    public EntityContribution buildComposerAttributeNode(ComposerAttributeNodeData node, AttributeStrategy attributeStrategy) throws ProcessingException {
        Integer agg;
        if (this.getDataModel() == null) {
            throw new ProcessingException("there is no data model set, call FormDataStatementBuilder.setDataModel to set one");
        }
        IDataModelAttribute attribute = DataModelUtility.externalIdToAttribute((IDataModel)this.getDataModel(), (String)node.getAttributeExternalId(), null);
        if (attribute == null) {
            LOG.warn("no attribute for external id: " + node.getAttributeExternalId());
            return new EntityContribution();
        }
        DataModelAttributePartDefinition def = this.m_dataModelAttMap.get(attribute.getClass());
        if (def == null && (agg = node.getAggregationType()) != null && agg == 1) {
            def = new DataModelAttributePartDefinition(null, "1", false);
        }
        if (def == null) {
            LOG.warn("no PartDefinition for attribute: " + attribute);
            return new EntityContribution();
        }
        ArrayList<Object> bindValues = new ArrayList<Object>();
        if (node.getValues() != null) {
            bindValues.addAll(Arrays.asList(node.getValues()));
        }
        ArrayList<String> bindNames = new ArrayList<String>(bindValues.size());
        int i = 0;
        while (i < bindValues.size()) {
            bindNames.add("" + (char)(97 + i));
            ++i;
        }
        AliasMapper aliasMap = this.getAliasMapper();
        ComposerEntityNodeData parentEntityNode = FormDataStatementBuilder.getParentNodeOfType((TreeNodeData)node, ComposerEntityNodeData.class);
        Map<String, String> parentAliasMap = parentEntityNode != null ? aliasMap.getNodeAliases(parentEntityNode) : aliasMap.getRootAliases();
        String stm = null;
        switch (attributeStrategy) {
            case BuildConstraintOfAttribute: 
            case BuildConstraintOfContext: 
            case BuildConstraintOfAttributeWithContext: {
                stm = def.getWhereClause();
                break;
            }
            case BuildQueryOfAttributeAndConstraintOfContext: {
                stm = def.getSelectClause();
            }
        }
        EntityContribution contrib = null;
        if (stm != null) {
            contrib = def.createInstance(this, node, attributeStrategy, stm, bindNames, bindValues, parentAliasMap);
        }
        if (contrib == null) {
            contrib = new EntityContribution();
        }
        switch (attributeStrategy) {
            case BuildQueryOfAttributeAndConstraintOfContext: {
                if (!contrib.getSelectParts().isEmpty()) break;
                contrib.getSelectParts().add("NULL");
            }
        }
        return contrib;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createEntityPart(String stm, boolean negative, EntityContribution contrib) throws ProcessingException {
        String s;
        String entityPart = stm;
        if (contrib.getSelectParts().size() > 0) {
            final String s2 = ListUtility.format(contrib.getSelectParts(), (String)", ");
            if (StringUtility.getTag((String)entityPart, (String)"selectParts") == null) throw new IllegalArgumentException("missing <selectParts/> tag");
            entityPart = StringUtility.replaceTags((String)entityPart, (String)"selectParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                public String processTag(String tagName, String tagContent) {
                    if (tagContent.length() > 0) {
                        return String.valueOf(tagContent) + ", " + s2;
                    }
                    return s2;
                }
            });
        }
        entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"selectParts");
        TreeSet<String> fromParts = new TreeSet<String>(contrib.getFromParts());
        if (fromParts.size() > 0) {
            s = ListUtility.format(fromParts, (String)", ");
            if (StringUtility.getTag((String)entityPart, (String)"fromParts") == null) throw new IllegalArgumentException("missing <fromParts/> tag");
            entityPart = StringUtility.replaceTags((String)entityPart, (String)"fromParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                public String processTag(String tagName, String tagContent) {
                    return String.valueOf(tagContent) + ", " + s;
                }
            });
        }
        entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"fromParts");
        if (contrib.getWhereParts().size() > 0) {
            s = ListUtility.format(contrib.getWhereParts(), (String)" AND ");
            entityPart = StringUtility.getTag((String)entityPart, (String)"whereParts") != null ? StringUtility.replaceTags((String)entityPart, (String)"whereParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                public String processTag(String tagName, String tagContent) {
                    return " AND " + s;
                }
            }) : String.valueOf(entityPart) + " AND " + s;
        }
        entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"whereParts");
        int selectGroupByDelta = contrib.getSelectParts().size() - contrib.getGroupByParts().size();
        if (selectGroupByDelta > 0 && contrib.getGroupByParts().size() > 0 || contrib.getHavingParts().size() > 0) {
            String s3;
            entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"groupBy");
            if (contrib.getGroupByParts().size() > 0) {
                s3 = ListUtility.format(contrib.getGroupByParts(), (String)", ");
                if (StringUtility.getTag((String)entityPart, (String)"groupByParts") == null) throw new IllegalArgumentException("missing <groupByParts/> tag");
                entityPart = StringUtility.replaceTags((String)entityPart, (String)"groupByParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                    public String processTag(String tagName, String tagContent) {
                        if (tagContent.length() > 0) {
                            return String.valueOf(tagContent) + ", " + s3;
                        }
                        return s3;
                    }
                });
            }
            entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"groupByParts");
            if (contrib.getHavingParts().size() > 0) {
                s3 = ListUtility.format(contrib.getHavingParts(), (String)" AND ");
                if (StringUtility.getTag((String)entityPart, (String)"havingParts") == null) throw new IllegalArgumentException("missing <havingParts/> tag");
                entityPart = StringUtility.replaceTags((String)entityPart, (String)"havingParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                    public String processTag(String tagName, String tagContent) {
                        return String.valueOf(tagContent) + " AND " + s3;
                    }
                });
            } else {
                entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"havingParts");
            }
        } else {
            entityPart = StringUtility.removeTag((String)entityPart, (String)"groupBy");
        }
        if (!negative) return entityPart;
        return " NOT (" + entityPart + ") ";
    }

    public EntityContribution createAttributePart(AttributeStrategy attributeStrategy, Integer aggregationType, String stm, int operation, List<String> bindNames, List<Object> bindValues, boolean plainBind, Map<String, String> parentAliasMap) throws ProcessingException {
        String tmp;
        boolean negation;
        int positiveOperation;
        Matcher m;
        if (stm == null) {
            return new EntityContribution();
        }
        if (stm.indexOf("<attribute>") < 0) {
            stm = "<attribute>" + stm + "</attribute>";
        }
        if ((m = PLAIN_ATTRIBUTE_PATTERN.matcher(stm)).find() && parentAliasMap.size() != 0) {
            if (parentAliasMap.size() == 1) {
                stm = m.replaceAll("$1@parent." + parentAliasMap.keySet().iterator().next() + "@.$2$3");
            } else {
                throw new ProcessingException("composer attribute " + stm + " uses no @...@ alias prefix, but parent has more than 1 alias: " + parentAliasMap);
            }
        }
        boolean isAg = aggregationType != null && aggregationType != 0;
        EntityContribution contrib = new EntityContribution();
        switch (operation) {
            case 12: {
                positiveOperation = 13;
                negation = true;
                break;
            }
            case 59: {
                positiveOperation = 49;
                negation = true;
                break;
            }
            case 18: {
                positiveOperation = 19;
                negation = true;
                break;
            }
            case 60: {
                positiveOperation = 50;
                negation = true;
                break;
            }
            case 27: {
                positiveOperation = 20;
                negation = true;
                break;
            }
            case 28: {
                positiveOperation = 1;
                negation = true;
                break;
            }
            case 29: {
                positiveOperation = 21;
                negation = true;
                break;
            }
            case 30: {
                positiveOperation = 24;
                negation = true;
                break;
            }
            case 31: {
                positiveOperation = 33;
                negation = true;
                break;
            }
            case 32: {
                positiveOperation = 36;
                negation = true;
                break;
            }
            case 34: {
                positiveOperation = 35;
                negation = true;
                break;
            }
            case 43: {
                positiveOperation = 44;
                negation = true;
                break;
            }
            default: {
                positiveOperation = operation;
                negation = false;
            }
        }
        String fromPart = StringUtility.getTag((String)stm, (String)"fromPart");
        stm = StringUtility.removeTag((String)stm, (String)"fromPart").trim();
        String wherePart = StringUtility.getTag((String)stm, (String)"wherePart");
        if (wherePart == null && (tmp = StringUtility.removeTag((String)stm, (String)"attribute").trim()).length() > 0) {
            wherePart = stm;
            stm = "";
        }
        stm = StringUtility.removeTag((String)stm, (String)"wherePart").trim();
        String attPart = StringUtility.getTag((String)stm, (String)"attribute");
        if ((stm = StringUtility.removeTag((String)stm, (String)"attribute").trim()).length() > 0) {
            LOG.warn("attribute part is not well-formed; contains wherePart tag and also other sql text: " + stm);
        }
        if (fromPart != null) {
            this.m_aliasMapper.addMissingNodeEntitiesFrom(contrib, fromPart);
            Map<String, String> aliasMap = this.m_aliasMapper.getNodeAliases(contrib);
            parentAliasMap.putAll(aliasMap);
            fromPart = this.m_aliasMapper.replaceMarkersByAliases(fromPart, parentAliasMap, parentAliasMap);
            contrib.getFromParts().add(fromPart);
        }
        switch (attributeStrategy) {
            case BuildQueryOfAttributeAndConstraintOfContext: {
                String sql;
                if (attPart != null && (sql = this.createSqlPart(aggregationType, attPart, 0, bindNames, bindValues, plainBind, parentAliasMap)) != null) {
                    contrib.getSelectParts().add(sql);
                    if (!isAg) {
                        contrib.getGroupByParts().add(sql);
                    }
                }
                if (wherePart == null || (sql = this.createSqlPart(wherePart = StringUtility.replaceTags((String)wherePart, (String)"attribute", (String)"1=1").trim(), bindNames, bindValues, plainBind, parentAliasMap)) == null) break;
                contrib.getWhereParts().add(sql);
                break;
            }
            case BuildConstraintOfAttribute: {
                String sql;
                if (attPart == null || (sql = this.createSqlPart(aggregationType, attPart, positiveOperation, bindNames, bindValues, plainBind, parentAliasMap)) == null) break;
                if (negation) {
                    sql = "NOT(" + sql + ")";
                }
                if (isAg) {
                    contrib.getHavingParts().add(sql);
                    break;
                }
                contrib.getWhereParts().add(sql);
                break;
            }
            case BuildConstraintOfContext: {
                String sql;
                if (wherePart == null || (sql = this.createSqlPart(wherePart = StringUtility.replaceTags((String)wherePart, (String)"attribute", (String)"1=1").trim(), bindNames, bindValues, plainBind, parentAliasMap)) == null) break;
                contrib.getWhereParts().add(sql);
                break;
            }
            case BuildConstraintOfAttributeWithContext: {
                String sql;
                String whereAndAttPart = String.valueOf(wherePart != null ? wherePart : "") + (wherePart != null && attPart != null ? " AND " : "") + (attPart != null ? "<attribute>" + attPart + "</attribute>" : "");
                if (whereAndAttPart.length() <= 0 || (sql = this.createSqlPart(aggregationType, whereAndAttPart, positiveOperation, bindNames, bindValues, plainBind, parentAliasMap)) == null) break;
                if (negation) {
                    sql = "NOT(" + sql + ")";
                }
                contrib.getWhereParts().add(sql);
            }
        }
        return contrib;
    }

    public String createAttributePartSimple(AttributeStrategy attributeStrategy, Integer aggregationType, String stm, int operation, List<String> bindNames, List<Object> bindValues, boolean plainBind, Map<String, String> parentAliasMap) throws ProcessingException {
        EntityContribution contrib = this.createAttributePart(attributeStrategy, aggregationType, stm, operation, bindNames, bindValues, plainBind, parentAliasMap);
        if (contrib.isEmpty()) {
            return null;
        }
        return ListUtility.format(contrib.getWhereParts(), (String)" AND ");
    }

    public String createSqlPart(String sql, List<String> bindNames, List<Object> bindValues, boolean plainBind, Map<String, String> parentAliasMap) throws ProcessingException {
        return this.createSqlPart(0, sql, 0, bindNames, bindValues, plainBind, parentAliasMap);
    }

    public String createSqlPart(final Integer aggregationType, String sql, final int operation, List<String> bindNames, List<Object> bindValues, final boolean plainBind, Map<String, String> parentAliasMap) throws ProcessingException {
        Matcher m;
        if (sql == null) {
            sql = "";
        }
        if (bindNames == null) {
            bindNames = new ArrayList<String>(0);
        }
        if (bindValues == null) {
            bindValues = new ArrayList<Object>(0);
        }
        if (sql.indexOf("<attribute>") < 0) {
            sql = "<attribute>" + sql + "</attribute>";
        }
        if ((m = PLAIN_ATTRIBUTE_PATTERN.matcher(sql)).find() && parentAliasMap.size() != 0) {
            if (parentAliasMap.size() == 1) {
                sql = m.replaceAll("$1@parent." + parentAliasMap.keySet().iterator().next() + "@.$2$3");
            } else {
                throw new ProcessingException("root attribute with " + sql + " uses no @...@ alias prefix, but parent has more than 1 alias: " + parentAliasMap);
            }
        }
        sql = this.m_aliasMapper.replaceMarkersByAliases(sql, parentAliasMap, parentAliasMap);
        final ArrayList<String> newBindNames = new ArrayList<String>(2);
        int i = 0;
        while (i < bindNames.size()) {
            String o = bindNames.get(i);
            String n = this.localizeBindName(o, "__");
            newBindNames.add(n);
            sql = this.localizeStatement(sql, o, n);
            ++i;
        }
        final List<Object> valuesFinal = bindValues;
        StringUtility.ITagProcessor processor = new StringUtility.ITagProcessor(){

            public String processTag(String tagName, String a) {
                return FormDataStatementBuilder.this.createSqlOpValuePart(aggregationType, a, operation, newBindNames, valuesFinal, plainBind);
            }
        };
        return StringUtility.replaceTags((String)sql, (String)"attribute", (StringUtility.ITagProcessor)processor);
    }

    public String createSqlOpValuePart(Integer aggregationType, String sql, int operation, List<String> bindNames, List<Object> bindValues, boolean plainBind) {
        Object[] values;
        String[] names = bindNames != null ? bindNames.toArray(new String[bindNames.size()]) : new String[]{};
        Object[] objectArray = values = bindValues != null ? bindValues.toArray(new Object[bindValues.size()]) : new Object[]{};
        if (plainBind && operation != 0) {
            int i = 0;
            while (i < names.length) {
                names[i] = "&" + this.m_sqlStyle.toPlainText(values[i]);
                ++i;
            }
        }
        if (aggregationType != null && aggregationType != 0) {
            switch (aggregationType) {
                case 1: {
                    sql = this.m_sqlStyle.toAggregationCount(sql);
                    break;
                }
                case 3: {
                    sql = this.m_sqlStyle.toAggregationMin(sql);
                    break;
                }
                case 4: {
                    sql = this.m_sqlStyle.toAggregationMax(sql);
                    break;
                }
                case 2: {
                    sql = this.m_sqlStyle.toAggregationSum(sql);
                    break;
                }
                case 5: {
                    sql = this.m_sqlStyle.toAggregationAvg(sql);
                    break;
                }
                case 6: {
                    sql = this.m_sqlStyle.toAggregationMedian(sql);
                }
            }
        } else if (this.isZeroTraversingAttribute(operation, values)) {
            sql = String.valueOf(this.m_sqlStyle.getNvlToken()) + "(" + sql + ",0)";
        }
        switch (operation) {
            case 0: {
                if (plainBind) {
                    if (names != null) {
                        HashMap<String, String> tokenValue = new HashMap<String, String>();
                        int i = 0;
                        while (i < names.length) {
                            tokenValue.put(names[i], this.m_sqlStyle.toPlainText(values[i]));
                            ++i;
                        }
                        BindModel m = new BindParser(sql).parse();
                        IToken[] tokens = m.getIOTokens();
                        if (tokens != null) {
                            IToken[] iTokenArray = tokens;
                            int n = tokens.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IToken iToken = iTokenArray[n2];
                                if (iToken instanceof ValueInputToken) {
                                    ValueInputToken t = (ValueInputToken)iToken;
                                    t.setPlainValue(true);
                                    t.setReplaceToken((String)tokenValue.get(t.getName()));
                                }
                                ++n2;
                            }
                        }
                        sql = m.getFilteredStatement();
                    }
                } else {
                    this.addBinds(names, values);
                }
                return sql;
            }
            case 45: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                if (values[0] == null) {
                    return this.m_sqlStyle.createLE(sql, names[1]);
                }
                if (values[1] == null) {
                    return this.m_sqlStyle.createGE(sql, names[0]);
                }
                return this.m_sqlStyle.createBetween(sql, names[0], names[1]);
            }
            case 47: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                if (values[0] == null) {
                    return this.m_sqlStyle.createDateLE(sql, names[1]);
                }
                if (values[1] == null) {
                    return this.m_sqlStyle.createDateGE(sql, names[0]);
                }
                return this.m_sqlStyle.createDateBetween(sql, names[0], names[1]);
            }
            case 48: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                if (values[0] == null) {
                    return this.m_sqlStyle.createDateTimeLE(sql, names[1]);
                }
                if (values[1] == null) {
                    return this.m_sqlStyle.createDateTimeGE(sql, names[0]);
                }
                return this.m_sqlStyle.createDateTimeBetween(sql, names[0], names[1]);
            }
            case 20: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createEQ(sql, names[0]);
            }
            case 49: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateEQ(sql, names[0]);
            }
            case 50: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeEQ(sql, names[0]);
            }
            case 22: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createGE(sql, names[0]);
            }
            case 51: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateGE(sql, names[0]);
            }
            case 52: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeGE(sql, names[0]);
            }
            case 23: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createGT(sql, names[0]);
            }
            case 53: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateGT(sql, names[0]);
            }
            case 54: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeGT(sql, names[0]);
            }
            case 25: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createLE(sql, names[0]);
            }
            case 55: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateLE(sql, names[0]);
            }
            case 56: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeLE(sql, names[0]);
            }
            case 26: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createLT(sql, names[0]);
            }
            case 57: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateLT(sql, names[0]);
            }
            case 58: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeLT(sql, names[0]);
            }
            case 27: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createNEQ(sql, names[0]);
            }
            case 59: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateNEQ(sql, names[0]);
            }
            case 60: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeNEQ(sql, names[0]);
            }
            case 2: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInDays(sql, names[0]);
            }
            case 3: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInGEDays(sql, names[0]);
            }
            case 4: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInGEMonths(sql, names[0]);
            }
            case 5: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInLEDays(sql, names[0]);
            }
            case 6: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInLEMonths(sql, names[0]);
            }
            case 7: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInLastDays(sql, names[0]);
            }
            case 8: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInLastMonths(sql, names[0]);
            }
            case 9: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInMonths(sql, names[0]);
            }
            case 10: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInNextDays(sql, names[0]);
            }
            case 11: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateIsInNextMonths(sql, names[0]);
            }
            case 12: {
                return this.m_sqlStyle.createDateIsNotToday(sql);
            }
            case 13: {
                return this.m_sqlStyle.createDateIsToday(sql);
            }
            case 14: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeIsInGEHours(sql, names[0]);
            }
            case 15: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeIsInGEMinutes(sql, names[0]);
            }
            case 16: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeIsInLEHours(sql, names[0]);
            }
            case 17: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createDateTimeIsInLEMinutes(sql, names[0]);
            }
            case 18: {
                return this.m_sqlStyle.createDateTimeIsNotNow(sql);
            }
            case 19: {
                return this.m_sqlStyle.createDateTimeIsNow(sql);
            }
            case 21: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createEndsWith(sql, names[0]);
            }
            case 29: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createNotEndsWith(sql, names[0]);
            }
            case 24: {
                if (!plainBind) {
                    this.addBinds(names, values);
                    return this.m_sqlStyle.createIn(sql, names[0]);
                }
                return this.m_sqlStyle.createInList(sql, values[0]);
            }
            case 1: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createContains(sql, names[0]);
            }
            case 46: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createLike(sql, names[0]);
            }
            case 30: {
                if (!plainBind) {
                    this.addBinds(names, values);
                    return this.m_sqlStyle.createNotIn(sql, names[0]);
                }
                return this.m_sqlStyle.createNotInList(sql, values[0]);
            }
            case 28: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createNotContains(sql, names[0]);
            }
            case 31: {
                return this.m_sqlStyle.createNotNull(sql);
            }
            case 34: {
                return this.m_sqlStyle.createNumberNotNull(sql);
            }
            case 33: {
                return this.m_sqlStyle.createNull(sql);
            }
            case 35: {
                return this.m_sqlStyle.createNumberNull(sql);
            }
            case 36: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createStartsWith(sql, names[0]);
            }
            case 32: {
                if (!plainBind) {
                    this.addBind(names[0], this.m_sqlStyle.toLikePattern(values[0]));
                }
                return this.m_sqlStyle.createNotStartsWith(sql, names[0]);
            }
            case 37: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInGEHours(sql, names[0]);
            }
            case 38: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInGEMinutes(sql, names[0]);
            }
            case 39: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInHours(sql, names[0]);
            }
            case 40: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInLEHours(sql, names[0]);
            }
            case 41: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInLEMinutes(sql, names[0]);
            }
            case 42: {
                if (!plainBind) {
                    this.addBinds(names, values);
                }
                return this.m_sqlStyle.createTimeIsInMinutes(sql, names[0]);
            }
            case 44: {
                return this.m_sqlStyle.createTimeIsNow(sql);
            }
            case 43: {
                return this.m_sqlStyle.createTimeIsNotNow(sql);
            }
        }
        throw new IllegalArgumentException("invalid operator: " + operation);
    }

    public static enum AttributeKind {
        Undefined,
        NonAggregation,
        Aggregation,
        NonAggregationNonZeroTraversing,
        AggregationNonZeroTraversing;

    }

    public static enum AttributeStrategy {
        BuildConstraintOfAttribute,
        BuildConstraintOfContext,
        BuildConstraintOfAttributeWithContext,
        BuildQueryOfAttributeAndConstraintOfContext;

    }

    public static enum EntityStrategy {
        BuildConstraints,
        BuildQuery;

    }
}

