/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.DataModelAttributePartDefinition;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.DataModelEntityPartDefinition;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.ValuePartDefinition;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class FormDataStatementBuilderCheck {
    protected final FormDataStatementBuilder builder;
    private TreeSet<String> m_imports;
    private ArrayList<String> m_body;
    private HashSet<Class<?>> m_visited;

    public FormDataStatementBuilderCheck(FormDataStatementBuilder builder) {
        this.builder = builder;
        this.m_imports = new TreeSet();
        this.m_body = new ArrayList();
        this.m_visited = new HashSet();
    }

    public TreeSet<String> getImports() {
        return this.m_imports;
    }

    public ArrayList<String> getBody() {
        return this.m_body;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.m_imports.size() > 0) {
            for (String s : this.m_imports) {
                buf.append(s);
                buf.append("\n");
            }
            buf.append("\n");
        }
        if (this.m_body.size() > 0) {
            for (String s : this.m_body) {
                buf.append(s);
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public boolean check(Object o) {
        this.m_imports.clear();
        this.m_body.clear();
        this.m_visited.clear();
        this.checkRec(o);
        return this.m_body.size() == 0;
    }

    protected void checkRec(Object o) {
        if (this.m_visited.contains(o.getClass())) {
            return;
        }
        this.m_visited.add(o.getClass());
        if (o instanceof AbstractFormData) {
            AbstractFormFieldData[] abstractFormFieldDataArray = ((AbstractFormData)o).getFields();
            int n = abstractFormFieldDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractFormFieldData f = abstractFormFieldDataArray[n2];
                this.checkRec(f);
                ++n2;
            }
        } else if (o instanceof AbstractFormFieldData) {
            if (o instanceof AbstractValueFieldData) {
                this.checkValueField((AbstractValueFieldData)o);
            }
            AbstractFormFieldData[] abstractFormFieldDataArray = ((AbstractFormFieldData)o).getFields();
            int n = abstractFormFieldDataArray.length;
            int n3 = 0;
            while (n3 < n) {
                AbstractFormFieldData f = abstractFormFieldDataArray[n3];
                this.checkRec(f);
                ++n3;
            }
        } else if (o instanceof AbstractDataModel) {
            IDataModelAttribute[] iDataModelAttributeArray = ((AbstractDataModel)o).getAttributes();
            int n = iDataModelAttributeArray.length;
            int n4 = 0;
            while (n4 < n) {
                IDataModelAttribute a = iDataModelAttributeArray[n4];
                this.checkRec(a);
                ++n4;
            }
            iDataModelAttributeArray = ((AbstractDataModel)o).getEntities();
            n = iDataModelAttributeArray.length;
            n4 = 0;
            while (n4 < n) {
                IDataModelAttribute e = iDataModelAttributeArray[n4];
                this.checkRec(e);
                ++n4;
            }
        } else if (o instanceof IDataModelEntity) {
            this.checkDataModelEntity((IDataModelEntity)o);
            IDataModelAttribute[] iDataModelAttributeArray = ((IDataModelEntity)o).getAttributes();
            int n = iDataModelAttributeArray.length;
            int n5 = 0;
            while (n5 < n) {
                IDataModelAttribute a = iDataModelAttributeArray[n5];
                this.checkRec(a);
                ++n5;
            }
            iDataModelAttributeArray = ((IDataModelEntity)o).getEntities();
            n = iDataModelAttributeArray.length;
            n5 = 0;
            while (n5 < n) {
                IDataModelAttribute e = iDataModelAttributeArray[n5];
                this.checkRec(e);
                ++n5;
            }
        } else if (o instanceof IDataModelAttribute) {
            this.checkDataModelAttribute((IDataModelAttribute)o);
        }
    }

    protected void checkValueField(AbstractValueFieldData<?> v) {
        ValuePartDefinition part = null;
        block0: for (ValuePartDefinition f : this.builder.getValuePartDefinitions()) {
            if (part != null) break;
            ClassIdentifier[] classIdentifierArray = f.getValueTypeClassIdentifiers();
            int n = classIdentifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassIdentifier t = classIdentifierArray[n2];
                if (part != null) continue block0;
                if (t.getLastSegment() == v.getClass()) {
                    part = f;
                }
                ++n2;
            }
        }
        if (part == null) {
            String name = this.fieldToName(v);
            String sqlColumnName = this.toSqlColumn(name);
            String sqlTemplate = "\"${sqlName}\"";
            String sql = sqlTemplate.replace("${sqlColumnName}", sqlColumnName);
            Class dataType = v.getHolderType();
            String op = String.class.isAssignableFrom(dataType) ? "ComposerConstants.OPERATOR_CONTAINS" : "ComposerConstants.OPERATOR_EQ";
            this.addBodyLine("setFieldDefinition(" + this.resolveImport(v.getClass()) + ".class," + sql + "," + op + ");");
        }
    }

    protected void checkDataModelEntity(IDataModelEntity e) {
        DataModelEntityPartDefinition part = this.builder.getDataModelEntityPartDefinitions().get(e.getClass());
        if (part == null) {
            String name = this.entityToName(e);
            String sqlTableName = this.toSqlTable(name);
            String sqlPKName = this.toSqlPrimaryKey(name);
            String parentName = name;
            String parentSqlPKName = sqlPKName;
            IDataModelEntity parentE = e.getParentEntity();
            if (parentE != null) {
                parentName = this.entityToName(parentE);
                parentSqlPKName = this.toSqlPrimaryKey(parentName);
            }
            String sqlTemplate = "\"EXISTS ( SELECT 1 \"+\n\"FROM ${sqlTableName} @${name}@ \"+\n\"WHERE @${name}@.${parentSqlPKName}=@parent.${parentName}@.${parentSqlPKName} \"+\n\"<whereParts/> \"+\n\"<groupBy> \"+\n\"  GROUP BY @${name}@.${parentSqlPKName} \"+\n\"  HAVING 1=1 \"+\n\"  <havingParts/> \"+\n\"</groupBy> \"+\n\")\"";
            String sql = sqlTemplate.replace("${name}", name).replace("${parentName}", parentName).replace("${sqlTableName}", sqlTableName).replace("${parentSqlPKName}", parentSqlPKName);
            this.addBodyLine("//entity " + e.getClass().getSimpleName());
            this.addBodyLine("setComposerEntityDefinition(" + this.resolveImport(e.getClass()) + ".class," + sql + ");");
        }
    }

    protected void checkDataModelAttribute(IDataModelAttribute a) {
        DataModelAttributePartDefinition part = this.builder.getDataModelAttributePartDefinitions().get(a.getClass());
        if (part == null) {
            if (a.getClass().getSimpleName().endsWith("CountAttribute")) {
                return;
            }
            String parentName = null;
            IDataModelEntity parentE = a.getParentEntity();
            if (parentE != null) {
                parentName = this.entityToName(parentE);
            }
            String name = this.attributeToName(parentE, a);
            String sqlColumnName = this.toSqlColumn(name);
            String sqlTemplate = parentE != null ? "\"@${parentName}@.${sqlColumnName}\"" : "\"${sqlColumnName}\"";
            String sql = sqlTemplate.replace("${sqlColumnName}", sqlColumnName).replace("${parentName}", parentName);
            this.addBodyLine("setComposerAttributeDefinition(" + this.resolveImport(a.getClass()) + ".class," + sql + ");");
        }
    }

    protected String fieldToName(Object f) {
        String name = f.getClass().getSimpleName();
        name = name.replaceAll("^Abstract(.*)$", "$1");
        name = name.replaceAll("^(.*)Data$", "$1");
        name = name.replaceAll("^(.*)Box", "$1");
        return name;
    }

    protected String entityToName(Object e) {
        String name = e.getClass().getSimpleName();
        name = name.replaceAll("^Abstract(.*)$", "$1");
        name = name.replaceAll("^(.*)Entity$", "$1");
        String[] array = name.replaceAll("([a-z])([A-Z])", "$1 $2").split(" ");
        return array[array.length - 1];
    }

    protected String attributeToName(Object entity, Object attribute) {
        String ename = this.entityToName(entity);
        String name = attribute.getClass().getSimpleName();
        name = name.replaceAll("^Abstract(.*)$", "$1");
        name = name.replaceAll("^(.*)Attribute", "$1");
        if (ename != null) {
            String[] array = ename.replaceAll("([a-z])([A-Z])", "$1 $2").split(" ");
            int i = array.length - 1;
            while (i >= 0) {
                if (name.startsWith(array[i])) {
                    name = name.substring(array[i].length());
                }
                --i;
            }
        }
        return name;
    }

    protected String toSqlTable(String s) {
        s = s.replaceAll("([a-z])([A-Z])", "$1_$2");
        return s.toUpperCase();
    }

    protected String toSqlPrimaryKey(String s) {
        s = String.valueOf(s.replaceAll("([a-z])([A-Z])", "$1_$2")) + "_NR";
        return s.toUpperCase();
    }

    protected String toSqlColumn(String s) {
        s = s.replaceAll("([a-z])([A-Z])", "$1_$2");
        return s.toUpperCase();
    }

    protected String resolveImport(Class<?> c) {
        String pck = c.getPackage().getName();
        String s = c.getName().substring(pck.length() + 1);
        int i = s.indexOf(36);
        if (i >= 0) {
            s = s.substring(0, i);
        }
        this.addImportLine("import " + pck + "." + s + ";");
        return c.getName().substring(pck.length() + 1).replace('$', '.');
    }

    protected void addImportLine(String s) {
        this.m_imports.add(s);
    }

    protected void addBodyLine(String s) {
        this.m_body.add(s);
    }
}

