/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;

public class ValuePartDefinition
implements DataModelConstants {
    private final ClassIdentifier[] m_valueTypeClassIdentifiers;
    private final String m_sqlAttribute;
    private final int m_operation;
    private final boolean m_plainBind;

    public ValuePartDefinition(Class<?> valueType, String sqlAttribute, int operator) {
        this(new Class[]{valueType}, sqlAttribute, operator, false);
    }

    public ValuePartDefinition(ClassIdentifier fieldTypeClassIdentifier, String sqlAttribute, int operator) {
        this(new ClassIdentifier[]{fieldTypeClassIdentifier}, sqlAttribute, operator, false);
    }

    public ValuePartDefinition(Class<?> valueType, String sqlAttribute) {
        this(new Class[]{valueType}, sqlAttribute, 0, false);
    }

    public ValuePartDefinition(Class<?>[] valueTypes, String sqlAttribute) {
        this(valueTypes, sqlAttribute, 0, false);
    }

    public ValuePartDefinition(Class<?> valueType, String sqlAttribute, int operator, boolean plainBind) {
        this(new Class[]{valueType}, sqlAttribute, operator, plainBind);
    }

    public ValuePartDefinition(ClassIdentifier valueTypeIdentifier, String sqlAttribute, int operator, boolean plainBind) {
        this(new ClassIdentifier[]{valueTypeIdentifier}, sqlAttribute, operator, plainBind);
    }

    public ValuePartDefinition(Class<?>[] valueTypes, String sqlAttribute, int operator) {
        this(valueTypes, sqlAttribute, operator, false);
    }

    public ValuePartDefinition(Class<?>[] valueTypes, String sqlAttribute, int operator, boolean plainBind) {
        this(ClassIdentifier.convertClassArrayToClassIdentifierArray((Class[])valueTypes), sqlAttribute, operator, plainBind);
    }

    public ValuePartDefinition(ClassIdentifier[] valueTypeClassIdentifiers, String sqlAttribute, int operator, boolean plainBind) {
        this.m_valueTypeClassIdentifiers = valueTypeClassIdentifiers != null ? valueTypeClassIdentifiers : new ClassIdentifier[]{};
        this.m_sqlAttribute = sqlAttribute;
        this.m_operation = operator;
        this.m_plainBind = plainBind;
        ClassIdentifier[] classIdentifierArray = this.m_valueTypeClassIdentifiers;
        int n = this.m_valueTypeClassIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ClassIdentifier classIdentifier = classIdentifierArray[n2];
            Class c = classIdentifier.getLastSegment();
            if (!AbstractPropertyData.class.isAssignableFrom(c) && !AbstractValueFieldData.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException(c + " is not of type AbstractPropertyData or AbstractValueFieldData");
            }
            int i = 0;
            while (i < classIdentifier.getClasses().length - 1) {
                Class containerClass = classIdentifier.getClasses()[i];
                if (!AbstractFormFieldData.class.isAssignableFrom(containerClass)) {
                    throw new IllegalArgumentException(containerClass + " is not of type AbstractFormFieldData (segment " + i + " in " + classIdentifier + ")");
                }
                ++i;
            }
            ++n2;
        }
    }

    public String getSqlAttribute() {
        return this.m_sqlAttribute;
    }

    public int getOperation() {
        return this.m_operation;
    }

    public boolean isPlainBind() {
        return this.m_plainBind;
    }

    public ClassIdentifier[] getValueTypeClassIdentifiers() {
        return this.m_valueTypeClassIdentifiers;
    }

    public boolean accept(AbstractFormData formData, Map<Integer, Map<String, AbstractFormFieldData>> fieldsBreathFirstMap, Map<Integer, Map<String, AbstractPropertyData<?>>> propertiesBreathFirstMap) throws ProcessingException {
        if (this.getValueTypeClassIdentifiers().length > 0) {
            ClassIdentifier[] classIdentifierArray = this.getValueTypeClassIdentifiers();
            int n = classIdentifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPropertyData p;
                AbstractValueFieldData v;
                ClassIdentifier valueType = classIdentifierArray[n2];
                AbstractFormFieldData dataObject = formData.findFieldByClass(fieldsBreathFirstMap, valueType);
                if (dataObject instanceof AbstractValueFieldData && (v = (AbstractValueFieldData)dataObject).isValueSet() && v.getValue() != null) {
                    return true;
                }
                dataObject = formData.findPropertyByClass(propertiesBreathFirstMap, valueType);
                if (dataObject instanceof AbstractPropertyData && (p = (AbstractPropertyData)dataObject).isValueSet() && p.getValue() != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String createInstance(FormDataStatementBuilder builder, List<Object> valueDatas, List<String> bindNames, List<Object> bindValues, Map<String, String> parentAliasMap) throws ProcessingException {
        return this.createNewInstance(builder, valueDatas, bindNames, bindValues, parentAliasMap);
    }

    @Deprecated
    public String createNewInstance(FormDataStatementBuilder builder, List<Object> valueDatas, List<String> bindNames, List<Object> bindValues, Map<String, String> parentAliasMap) throws ProcessingException {
        return builder.createSqlPart(0, this.getSqlAttribute(), this.getOperation(), bindNames, bindValues, this.isPlainBind(), parentAliasMap);
    }
}

