/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.io.Serializable;

public class ColumnDesc
implements Serializable {
    private static final long serialVersionUID = 596863413691696972L;
    private String m_name;
    private String m_typeName;
    private long m_size;
    private long m_precision;
    private long m_decimalDigits;
    private boolean m_nullable;
    private String m_defaultValue;

    private ColumnDesc() {
    }

    public ColumnDesc(String name, String typeName, long size, long precision, long decimalDigits, boolean isNullable) {
        this(name, typeName, size, precision, decimalDigits, isNullable, null);
    }

    public ColumnDesc(String name, String typeName, long size, long precision, long decimalDigits, boolean isNullable, String defaultValue) {
        this.m_name = name;
        this.m_typeName = typeName;
        this.m_size = size;
        this.m_precision = precision;
        this.m_decimalDigits = decimalDigits;
        this.m_nullable = isNullable;
        if (defaultValue != null) {
            this.m_defaultValue = defaultValue.trim();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getPrecision() {
        return this.m_precision;
    }

    public long getDecimalDigits() {
        return this.m_decimalDigits;
    }

    public boolean isNullable() {
        return this.m_nullable;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("<column");
        buf.append(" name=\"" + this.m_name + "\"");
        buf.append(" type=\"" + this.m_typeName + "\"");
        buf.append(" nullable=\"" + (this.m_nullable ? "yes" : "no") + "\"");
        if (this.m_size != 0L) {
            buf.append(" size=\"" + this.m_size + "\"");
        }
        if (this.m_precision != 0L) {
            buf.append(" precision=\"" + this.m_precision + "\"");
        }
        if (this.m_decimalDigits != 0L) {
            buf.append(" decimaldigits=\"" + this.m_decimalDigits + "\"");
        }
        if (this.m_defaultValue != null) {
            buf.append(" defaultValue=\"" + this.m_defaultValue + "\"");
        }
        buf.append("/>\n");
        return buf.toString();
    }
}

