/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import org.eclipse.scout.rt.server.services.common.jdbc.dict.ColumnDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.CongruencyFilter;

public class OracleCongruencyFilter
extends CongruencyFilter {
    protected int m_minVersion;
    protected int m_majVersion;
    protected boolean m_light;

    public OracleCongruencyFilter(int majVersion, int minVersion, boolean light) {
        this.m_majVersion = majVersion;
        this.m_minVersion = minVersion;
        this.m_light = light;
    }

    @Override
    public boolean allowDropTableColumn() {
        return this.m_majVersion >= 8;
    }

    @Override
    public String getCanonicalColumnType(ColumnDesc cd) {
        String type = cd.getTypeName().toUpperCase();
        if (type.equals("DOUBLE")) {
            type = "DOUBLE PRECISION";
        }
        if (type.equals("DATE") || type.equals("TIME") || type.equals("TIMESTAMP")) {
            type = "DATE";
        } else if (type.equals("INT") || type.equals("INTEGER")) {
            type = "INT";
        }
        if (type.equals("BIT") || type.equals("BLOB") || type.equals("CLOB") || type.equals("DATE") || type.equals("DOUBLE PRECISION") || type.equals("LONG") || type.equals("LONG RAW") || type.equals("REAL") || type.equals("ROWID") || type.equals("INT") || type.equals("BIGINT") || type.equals("SMALLINT") || type.equals("TINYINT")) {
            return type;
        }
        if (type.equals("NUMBER") || type.equals("DECIMAL")) {
            long prec;
            long l = prec = cd.getPrecision() > 0L ? cd.getPrecision() : 38L;
            if (cd.getDecimalDigits() > 0L) {
                return String.valueOf(type) + "(" + prec + "," + cd.getDecimalDigits() + ")";
            }
            return String.valueOf(type) + "(" + prec + ")";
        }
        if (cd.getPrecision() > 0L) {
            if (cd.getDecimalDigits() > 0L) {
                return String.valueOf(type) + "(" + cd.getPrecision() + "," + cd.getDecimalDigits() + ")";
            }
            return String.valueOf(type) + "(" + cd.getPrecision() + ")";
        }
        if (cd.getSize() > 0L) {
            return String.valueOf(type) + "(" + cd.getSize() + ")";
        }
        return type;
    }
}

