/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class MapOutput
implements IBindOutput {
    private Map<Object, Object> m_map;
    private Object m_mapKey;
    private ValueOutputToken m_source;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;
    private Object m_accumulator;

    public MapOutput(Map<Object, Object> map, Object mapKey, ValueOutputToken source) {
        this.m_map = map;
        this.m_mapKey = mapKey;
        this.m_source = source;
    }

    @Override
    public IToken getToken() {
        return this.m_source;
    }

    @Override
    public boolean isJdbcBind() {
        return !this.m_source.isSelectInto();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public boolean isBatch() {
        return this.m_source.isBatch();
    }

    @Override
    public boolean isSelectInto() {
        return this.m_source.isSelectInto();
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public Class getBindType() {
        Object o = this.m_map.get(this.m_mapKey);
        return o != null ? o.getClass() : Object.class;
    }

    @Override
    public void finishBatch() {
        this.m_map.put(this.m_mapKey, this.m_accumulator);
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_source.setReplaceToken("?");
    }

    @Override
    public void consumeValue(Object value) throws ProcessingException {
        if (this.m_batchIndex != 0) {
            throw new ProcessingException("expected a single value for map key \"" + this.m_source.getParsedToken() + "\" but got multiple values");
        }
        this.m_accumulator = value;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[bindType=" + this.getBindType() + ", key=" + this.m_mapKey + ", token=" + this.m_source + "]";
    }
}

