/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.HolderUtility;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class SingleHolderOutput
implements IBindOutput {
    private IHolder<?> m_holder;
    private ValueOutputToken m_source;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;
    private Object m_accumulator;

    public SingleHolderOutput(IHolder<?> holder, ValueOutputToken source) {
        this.m_holder = holder;
        this.m_source = source;
    }

    @Override
    public IToken getToken() {
        return this.m_source;
    }

    @Override
    public boolean isJdbcBind() {
        return !this.m_source.isSelectInto();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public boolean isBatch() {
        return this.m_source.isBatch();
    }

    @Override
    public boolean isSelectInto() {
        return this.m_source.isSelectInto();
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public Class getBindType() {
        return this.m_holder.getHolderType();
    }

    @Override
    public void finishBatch() {
        HolderUtility.setAndCastValue(this.m_holder, (Object)this.m_accumulator);
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_source.setReplaceToken("?");
    }

    @Override
    public void consumeValue(Object value) throws ProcessingException {
        if (this.m_batchIndex != 0) {
            throw new ProcessingException("expected a single value for \"" + this.m_source.getParsedToken() + "\" but got multiple values");
        }
        this.m_accumulator = value;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[bindType=" + this.getBindType() + ", source=" + this.m_source + "]";
    }
}

