/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.BeanArrayHolderFilter;
import org.eclipse.scout.commons.holders.IBeanArrayHolder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.holders.ITableHolder;
import org.eclipse.scout.commons.holders.NVPair;
import org.eclipse.scout.commons.holders.TableHolderFilter;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.BindModel;
import org.eclipse.scout.commons.parsers.BindParser;
import org.eclipse.scout.commons.parsers.IntoModel;
import org.eclipse.scout.commons.parsers.IntoParser;
import org.eclipse.scout.commons.parsers.sql.SqlFormatter;
import org.eclipse.scout.commons.parsers.token.DatabaseSpecificToken;
import org.eclipse.scout.commons.parsers.token.FunctionInputToken;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.jdbc.ISelectStreamHandler;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementCache;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementProcessor;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementProcessorMonitor;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.AbstractBeanPropertyOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.ArrayHolderOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.ArrayInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.BeanArrayHolderInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.BeanArrayHolderOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.BeanPropertyInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.FunctionInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.MapOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.SingleHolderOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.SingleInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.TableHolderInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.TableHolderOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.TriStateInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

public class StatementProcessor
implements IStatementProcessor {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(StatementProcessor.class);
    private static final Object NULL = new Object();
    private ISqlService m_callerService;
    private String m_originalStm;
    private Object[] m_bindBases;
    private int m_maxRowCount;
    private BindModel m_bindModel;
    private IToken[] m_ioTokens;
    private List<IBindInput> m_inputList;
    private List<IBindOutput> m_outputList;
    private int m_currentInputBatchIndex = -1;
    private int m_currentOutputBatchIndex = -1;
    private String m_currentInputStm;
    private TreeMap<Integer, SqlBind> m_currentInputBindMap;

    static {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SQL Log 'DEBUG': statements are logged with bind details and also as plaintext (suitable for direct use in executable form)");
        } else if (LOG.isInfoEnabled()) {
            LOG.info("SQL Log 'INFO': statements are logged with bind details, but not as plaintext. Use level 'FINE' to also log SQL as plain text (suitable for direct use in executable form)");
        }
    }

    public StatementProcessor(ISqlService callerService, String stm, Object[] bindBases) throws ProcessingException {
        this(callerService, stm, bindBases, 0);
    }

    public StatementProcessor(ISqlService callerService, String stm, Object[] bindBases, int maxRowCount) throws ProcessingException {
        if (stm == null) {
            throw new ProcessingException("statement is null");
        }
        try {
            IToken t;
            IServerSession session;
            this.m_callerService = callerService;
            this.m_originalStm = stm;
            this.m_maxRowCount = maxRowCount;
            ArrayList<Object> bases = new ArrayList<Object>();
            if (bindBases != null) {
                int i = 0;
                int n = bindBases.length;
                while (i < n) {
                    bases.add(bindBases[i]);
                    ++i;
                }
            }
            if ((session = ServerJob.getCurrentSession()) != null) {
                bases.add(session);
                Map<String, Object> shMap = session.getSharedVariableMap();
                bases.add(shMap);
            }
            this.m_bindBases = bases.toArray();
            this.m_inputList = new ArrayList<IBindInput>();
            this.m_outputList = new ArrayList<IBindOutput>();
            IntoModel intoModel = new IntoParser(this.m_originalStm).parse();
            String stmWithoutSelectInto = intoModel.getFilteredStatement();
            this.m_bindModel = new BindParser(stmWithoutSelectInto).parse();
            this.m_ioTokens = this.m_bindModel.getIOTokens();
            int jdbcBindIndex = 1;
            IToken[] iTokenArray = this.m_ioTokens;
            int n = this.m_ioTokens.length;
            int n2 = 0;
            while (n2 < n) {
                t = iTokenArray[n2];
                IBindInput in = null;
                IBindOutput out = null;
                if (t.isInput()) {
                    in = this.createInput(t, this.m_bindBases);
                    if (in.isJdbcBind()) {
                        in.setJdbcBindIndex(jdbcBindIndex);
                    }
                    this.m_inputList.add(in);
                }
                if (t.isOutput()) {
                    out = this.createOutput(t, this.m_bindBases);
                    if (out.isJdbcBind()) {
                        out.setJdbcBindIndex(jdbcBindIndex);
                    }
                    this.m_outputList.add(out);
                }
                if (in != null && in.isJdbcBind() || out != null && out.isJdbcBind()) {
                    ++jdbcBindIndex;
                }
                ++n2;
            }
            iTokenArray = this.m_bindModel.getAllTokens();
            n = iTokenArray.length;
            n2 = 0;
            while (n2 < n) {
                t = iTokenArray[n2];
                if (t instanceof DatabaseSpecificToken) {
                    this.processDatabaseSpecificToken((DatabaseSpecificToken)t, callerService.getSqlStyle());
                }
                ++n2;
            }
            iTokenArray = intoModel.getOutputTokens();
            n = iTokenArray.length;
            n2 = 0;
            while (n2 < n) {
                t = iTokenArray[n2];
                IBindOutput out = this.createOutput(t, this.m_bindBases);
                if (!out.isSelectInto()) {
                    throw new ProcessingException("out parameter is not a 'select into': " + out);
                }
                if (out.isJdbcBind()) {
                    throw new ProcessingException("out parameter is a jdbc bind: " + out);
                }
                out.setJdbcBindIndex(-1);
                this.m_outputList.add(out);
                ++n2;
            }
        }
        catch (ProcessingException e) {
            e.addContextMessage(this.createSqlDump(true, false));
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException(this.createSqlDump(true, false), e);
        }
    }

    protected TreeMap<Integer, SqlBind> getCurrentInputBindMap() {
        return this.m_currentInputBindMap;
    }

    protected ISqlService getCallerService() {
        return this.m_callerService;
    }

    protected Object[] processResultRow(ResultSet rs) throws SQLException {
        ISqlStyle sqlStyle = this.m_callerService.getSqlStyle();
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        Object[] row = new Object[colCount];
        int i = 0;
        while (i < colCount) {
            int type = meta.getColumnType(i + 1);
            row[i] = sqlStyle.readBind(rs, meta, type, i + 1);
            ++i;
        }
        return row;
    }

    protected List<Object[]> processResultRows(ResultSet rs, int maxRowCount) throws SQLException, ProcessingException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] row = this.processResultRow(rs);
            rows.add(row);
            if (maxRowCount > 0 && rows.size() >= maxRowCount) break;
        }
        return rows;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[][] processSelect(Connection conn, IStatementCache cache, IStatementProcessorMonitor monitor) throws ProcessingException {
        Object[][] objectArray;
        PreparedStatement ps;
        block18: {
            ps = null;
            ResultSet rs = null;
            try {
                ArrayList<Object[]> rows = new ArrayList<Object[]>();
                block13: while (true) {
                    if (!this.hasNextInputBatch()) {
                        this.finishOutputBatch();
                        if (monitor != null) {
                            monitor.postFetchData(conn, ps, rs, rows);
                        }
                        objectArray = (Object[][])rows.toArray((T[])new Object[rows.size()][]);
                        if (rs == null) break block18;
                        break;
                    }
                    this.nextInputBatch();
                    this.prepareInputStatementAndBinds();
                    this.dump();
                    ps = cache.getPreparedStatement(conn, this.m_currentInputStm);
                    this.bindBatch(ps);
                    rs = ps.executeQuery();
                    Iterator<Object[]> iterator = this.processResultRows(rs, this.m_maxRowCount).iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block13;
                        Object[] row = iterator.next();
                        rows.add(row);
                        this.nextOutputBatch();
                        this.consumeSelectIntoRow(row);
                    }
                    break;
                }
            }
            catch (ProcessingException e) {
                try {
                    e.addContextMessage(this.createSqlDump(true, false));
                    throw e;
                    catch (Throwable e2) {
                        throw new ProcessingException(this.createSqlDump(true, false), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {}
                    }
                    try {
                        cache.releasePreparedStatement(ps);
                        throw throwable;
                    }
                    catch (SQLException e3) {
                        throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e3);
                    }
                }
            }
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            cache.releasePreparedStatement(ps);
            return objectArray;
        }
        catch (SQLException e) {
            throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
        }
    }

    @Override
    public void processSelectInto(Connection conn, IStatementCache cache, IStatementProcessorMonitor monitor) throws ProcessingException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                int rowCount = 0;
                while (this.hasNextInputBatch()) {
                    this.nextInputBatch();
                    this.prepareInputStatementAndBinds();
                    this.dump();
                    ps = cache.getPreparedStatement(conn, this.m_currentInputStm);
                    this.bindBatch(ps);
                    rs = ps.executeQuery();
                    for (Object[] row : this.processResultRows(rs, this.m_maxRowCount)) {
                        this.nextOutputBatch();
                        this.consumeSelectIntoRow(row);
                        ++rowCount;
                    }
                }
                this.finishOutputBatch();
                if (monitor != null) {
                    monitor.postFetchData(conn, ps, rs, null);
                }
            }
            catch (ProcessingException e) {
                e.addContextMessage(this.createSqlDump(true, false));
                throw e;
            }
            catch (Throwable e) {
                throw new ProcessingException(this.createSqlDump(true, false), e);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable2) {}
            }
            try {
                cache.releasePreparedStatement(ps);
            }
            catch (SQLException e) {
                throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            cache.releasePreparedStatement(ps);
        }
        catch (SQLException e) {
            throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
        }
    }

    @Override
    public void processSelectStreaming(Connection conn, IStatementCache cache, ISelectStreamHandler handler) throws ProcessingException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ISqlStyle sqlStyle = this.m_callerService.getSqlStyle();
        try {
            try {
                int rowCount = 0;
                block13: while (this.hasNextInputBatch()) {
                    this.nextInputBatch();
                    this.prepareInputStatementAndBinds();
                    this.dump();
                    ps = cache.getPreparedStatement(conn, this.m_currentInputStm);
                    this.bindBatch(ps);
                    rs = ps.executeQuery();
                    ResultSetMetaData meta = rs.getMetaData();
                    int colCount = meta.getColumnCount();
                    while (rs.next()) {
                        ArrayList<SqlBind> row = new ArrayList<SqlBind>(colCount);
                        int i = 0;
                        while (i < colCount) {
                            int type = meta.getColumnType(i + 1);
                            Object value = sqlStyle.readBind(rs, meta, type, i + 1);
                            row.add(new SqlBind(type, value));
                            ++i;
                        }
                        handler.handleRow(conn, ps, rs, rowCount, row);
                        if (this.m_maxRowCount > 0 && ++rowCount >= this.m_maxRowCount) continue block13;
                    }
                }
                this.finishOutputBatch();
                handler.finished(conn, ps, rs, rowCount);
            }
            catch (ProcessingException e) {
                e.addContextMessage(this.createSqlDump(true, false));
                throw e;
            }
            catch (Throwable e) {
                throw new ProcessingException(this.createSqlDump(true, false), e);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable2) {}
            }
            try {
                cache.releasePreparedStatement(ps);
            }
            catch (SQLException e) {
                throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            cache.releasePreparedStatement(ps);
        }
        catch (SQLException e) {
            throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
        }
    }

    @Override
    public int processModification(Connection conn, IStatementCache cache, IStatementProcessorMonitor monitor) throws ProcessingException {
        PreparedStatement ps = null;
        int rowCount = 0;
        try {
            while (this.hasNextInputBatch()) {
                this.nextInputBatch();
                this.prepareInputStatementAndBinds();
                this.dump();
                ps = cache.getPreparedStatement(conn, this.m_currentInputStm);
                this.bindBatch(ps);
                rowCount += ps.executeUpdate();
            }
            int n = rowCount;
            return n;
        }
        catch (ProcessingException e) {
            e.addContextMessage(this.createSqlDump(true, false));
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException(this.createSqlDump(true, false), e);
        }
        finally {
            try {
                cache.releasePreparedStatement(ps);
            }
            catch (SQLException e) {
                throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
            }
        }
    }

    @Override
    public boolean processStoredProcedure(Connection conn, IStatementCache cache, IStatementProcessorMonitor monitor) throws ProcessingException {
        CallableStatement cs = null;
        boolean status = true;
        try {
            int batchCount = 0;
            while (this.hasNextInputBatch()) {
                this.nextInputBatch();
                this.prepareInputStatementAndBinds();
                this.dump();
                cs = cache.getCallableStatement(conn, this.m_currentInputStm);
                this.bindBatch(cs);
                status = status && cs.execute();
                this.nextOutputBatch();
                this.consumeOutputRow(cs);
                ++batchCount;
            }
            this.finishOutputBatch();
            boolean bl = status;
            return bl;
        }
        catch (ProcessingException e) {
            e.addContextMessage(this.createSqlDump(true, false));
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException(this.createSqlDump(true, false), e);
        }
        finally {
            try {
                cache.releaseCallableStatement(cs);
            }
            catch (SQLException e) {
                throw new ProcessingException(this.createSqlDump(true, false), (Throwable)e);
            }
        }
    }

    @Override
    public String createPlainText() throws ProcessingException {
        IToken[] iTokenArray = this.m_ioTokens;
        int n = this.m_ioTokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken t = iTokenArray[n2];
            if (t instanceof ValueInputToken) {
                ValueInputToken vt = (ValueInputToken)t;
                if (!vt.isPlainSql() && !vt.isPlainValue()) {
                    vt.setPlainValue(true);
                }
            } else if (t instanceof FunctionInputToken) {
                FunctionInputToken ft = (FunctionInputToken)t;
                ft.setPlainValue(true);
            }
            ++n2;
        }
        if (this.hasNextInputBatch()) {
            this.nextInputBatch();
            this.prepareInputStatementAndBinds();
            this.resetInputBatch();
        }
        return this.m_currentInputStm;
    }

    @Override
    public void simulate() throws ProcessingException {
        while (this.hasNextInputBatch()) {
            this.nextInputBatch();
            this.prepareInputStatementAndBinds();
            this.dump();
        }
    }

    private boolean hasNextInputBatch() {
        int nextIndex = this.m_currentInputBatchIndex + 1;
        int batchInputCount = 0;
        int batchAcceptCount = 0;
        for (IBindInput input : this.m_inputList) {
            if (!input.isBatch()) continue;
            ++batchInputCount;
            if (!input.hasBatch(nextIndex)) continue;
            ++batchAcceptCount;
        }
        if (batchInputCount > 0) {
            return batchInputCount == batchAcceptCount;
        }
        return nextIndex == 0;
    }

    private void resetInputBatch() {
        this.m_currentInputBatchIndex = -1;
        for (IBindInput in : this.m_inputList) {
            in.setNextBatchIndex(this.m_currentInputBatchIndex);
        }
    }

    private void nextInputBatch() {
        ++this.m_currentInputBatchIndex;
        for (IBindInput in : this.m_inputList) {
            in.setNextBatchIndex(this.m_currentInputBatchIndex);
        }
    }

    private void nextOutputBatch() {
        ++this.m_currentOutputBatchIndex;
        for (IBindOutput out : this.m_outputList) {
            out.setNextBatchIndex(this.m_currentOutputBatchIndex);
        }
    }

    private void consumeSelectIntoRow(Object[] row) throws ProcessingException {
        int index = 0;
        for (IBindOutput out : this.m_outputList) {
            if (!out.isSelectInto()) continue;
            out.consumeValue(row[index]);
            ++index;
        }
    }

    private void consumeOutputRow(CallableStatement cs) throws ProcessingException, SQLException {
        for (IBindOutput out : this.m_outputList) {
            if (!out.isJdbcBind()) continue;
            out.consumeValue(cs.getObject(out.getJdbcBindIndex()));
        }
    }

    private void finishOutputBatch() throws ProcessingException {
        for (IBindOutput out : this.m_outputList) {
            out.finishBatch();
        }
    }

    private void prepareInputStatementAndBinds() throws ProcessingException {
        this.m_currentInputBindMap = new TreeMap();
        for (IBindInput in : this.m_inputList) {
            SqlBind bind = in.produceSqlBindAndSetReplaceToken(this.m_callerService.getSqlStyle());
            assert (bind != null == in.isJdbcBind());
            if (bind == null) continue;
            this.m_currentInputBindMap.put(in.getJdbcBindIndex(), bind);
        }
        for (IBindOutput out : this.m_outputList) {
            out.setReplaceToken(this.m_callerService.getSqlStyle());
        }
        this.m_currentInputStm = this.m_bindModel.getFilteredStatement();
    }

    protected String createSqlDump(boolean statementWithBinds, boolean statementPlainText) {
        StringBuffer debugBindBuf = new StringBuffer();
        if (this.m_currentInputBindMap == null) {
            try {
                this.prepareInputStatementAndBinds();
            }
            catch (ProcessingException e) {
                return e.getMessage();
            }
        }
        for (IBindInput in : this.m_inputList) {
            SqlBind bind = this.m_currentInputBindMap.get(in.getJdbcBindIndex());
            if (bind == null) continue;
            debugBindBuf.append("IN  ");
            debugBindBuf.append(in.getToken().getParsedToken());
            debugBindBuf.append(" => ");
            debugBindBuf.append(in.getToken().getReplaceToken());
            debugBindBuf.append(" [");
            debugBindBuf.append(SqlBind.decodeJdbcType(bind.getSqlType()));
            switch (bind.getSqlType()) {
                case 2004: 
                case 2005: {
                    break;
                }
                default: {
                    debugBindBuf.append(" ");
                    debugBindBuf.append(bind.getValue());
                }
            }
            debugBindBuf.append("]");
            debugBindBuf.append("\n");
        }
        for (IBindOutput out : this.m_outputList) {
            debugBindBuf.append("OUT ");
            debugBindBuf.append(out.getToken().getParsedToken());
            debugBindBuf.append(" => ");
            debugBindBuf.append(out.getToken().getReplaceToken());
            debugBindBuf.append(" [");
            debugBindBuf.append(out.getBindType().getSimpleName());
            debugBindBuf.append("]");
            debugBindBuf.append("\n");
        }
        StringBuffer buf = new StringBuffer();
        if (statementWithBinds) {
            buf.append("SQL with binds:\n");
            buf.append(SqlFormatter.wellform((String)this.m_originalStm).trim());
            if (debugBindBuf != null && debugBindBuf.length() > 0) {
                buf.append("\n");
                buf.append(debugBindBuf.toString().trim());
            }
        }
        if (statementPlainText) {
            String p = this.m_currentInputStm;
            ArrayList<SqlBind> bindList = new ArrayList<SqlBind>(this.m_currentInputBindMap.values());
            int bindIndex = 0;
            int pos = p.indexOf(63);
            while (pos >= 0 && bindIndex < bindList.size()) {
                String replacement;
                SqlBind bind = bindList.get(bindIndex);
                switch (bind.getSqlType()) {
                    case 2004: {
                        replacement = "__BLOB__";
                        break;
                    }
                    case 2005: {
                        replacement = "__CLOB__";
                        break;
                    }
                    default: {
                        replacement = this.m_callerService.getSqlStyle().toPlainText(bind.getValue());
                    }
                }
                if (replacement == null) {
                    replacement = "NULL";
                }
                replacement = replacement.replace('?', ' ');
                p = String.valueOf(p.substring(0, pos)) + replacement + p.substring(pos + 1);
                ++bindIndex;
                pos = p.indexOf(63);
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append("SQL PLAIN Log:\n");
            buf.append(SqlFormatter.wellform((String)p).trim());
        }
        return buf.toString();
    }

    protected void dump() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n" + this.createSqlDump(true, true));
        } else if (LOG.isInfoEnabled()) {
            LOG.info("\n" + this.createSqlDump(true, false));
        }
    }

    private void bindBatch(PreparedStatement ps) throws ProcessingException {
        try {
            if (ps instanceof PreparedStatement) {
                this.writeBinds(ps);
            }
            if (ps instanceof CallableStatement) {
                this.registerOutputs((CallableStatement)ps);
            }
        }
        catch (Throwable e) {
            throw new ProcessingException("unexpected exception", e);
        }
    }

    protected void writeBinds(PreparedStatement ps) throws SQLException {
        ISqlStyle sqlStyle = this.m_callerService.getSqlStyle();
        for (Map.Entry<Integer, SqlBind> e : this.m_currentInputBindMap.entrySet()) {
            sqlStyle.writeBind(ps, e.getKey(), e.getValue());
        }
    }

    protected void registerOutputs(CallableStatement cs) throws SQLException {
        ISqlStyle sqlStyle = this.m_callerService.getSqlStyle();
        for (IBindOutput out : this.m_outputList) {
            if (!out.isJdbcBind()) continue;
            sqlStyle.registerOutput(cs, out.getJdbcBindIndex(), out.getBindType());
        }
    }

    private IBindInput createInput(IToken bindToken, Object[] bindBases) throws ProcessingException {
        IBindInput o = null;
        if (bindToken instanceof ValueInputToken) {
            ValueInputToken valueInputToken = (ValueInputToken)bindToken;
            String[] path = valueInputToken.getName().split("[.]");
            int i = 0;
            while (i < bindBases.length) {
                Object bindBase = bindBases[i];
                Class nullType = null;
                if (bindBase instanceof NVPair) {
                    nullType = ((NVPair)bindBase).getNullType();
                }
                if ((o = this.createInputRec(valueInputToken, path, bindBases[i], nullType)) != null) break;
                ++i;
            }
            if (o == null) {
                throw new ProcessingException("Cannot find input for '" + valueInputToken + "' in bind bases.");
            }
        } else if (bindToken instanceof FunctionInputToken) {
            o = new FunctionInput(this.m_callerService, this.m_bindBases, (FunctionInputToken)bindToken);
        }
        return o;
    }

    private IBindInput createInputRec(ValueInputToken bindToken, String[] path, Object bindBase, Class nullType) throws ProcessingException {
        TableHolderFilter filter;
        boolean terminal = path.length == 1;
        Object o = null;
        boolean found = false;
        if (bindBase instanceof Map) {
            o = ((Map)bindBase).get(path[0]);
            if (o != null) {
                found = true;
            } else if (((Map)bindBase).containsKey(path[0])) {
                found = true;
            }
            if (found) {
                if (o instanceof ITableHolder) {
                    return new TableHolderInput((ITableHolder)o, null, path[1], bindToken);
                }
                if (o instanceof TableHolderFilter) {
                    return new TableHolderInput(((TableHolderFilter)o).getTableHolder(), ((TableHolderFilter)o).getFilteredRows(), path[1], bindToken);
                }
                if (o instanceof IBeanArrayHolder) {
                    return new BeanArrayHolderInput((IBeanArrayHolder)o, null, path[1], bindToken);
                }
                if (o instanceof BeanArrayHolderFilter) {
                    return new BeanArrayHolderInput(((BeanArrayHolderFilter)o).getBeanArrayHolder(), ((BeanArrayHolderFilter)o).getFilteredBeans(), path[1], bindToken);
                }
                if (terminal) {
                    return this.createInputTerminal(o, nullType, bindToken);
                }
                if (o == null) {
                    throw new ProcessingException("input bind " + bindToken + " resolves to null on path element: " + path[0]);
                }
            }
        } else if (bindBase instanceof NVPair) {
            if (((NVPair)bindBase).getName().equals(path[0])) {
                o = ((NVPair)bindBase).getValue();
                found = true;
                if (o instanceof ITableHolder) {
                    return new TableHolderInput((ITableHolder)o, null, path[1], bindToken);
                }
                if (o instanceof TableHolderFilter) {
                    return new TableHolderInput(((TableHolderFilter)o).getTableHolder(), ((TableHolderFilter)o).getFilteredRows(), path[1], bindToken);
                }
                if (o instanceof IBeanArrayHolder) {
                    return new BeanArrayHolderInput((IBeanArrayHolder)o, null, path[1], bindToken);
                }
                if (o instanceof BeanArrayHolderFilter) {
                    return new BeanArrayHolderInput(((BeanArrayHolderFilter)o).getBeanArrayHolder(), ((BeanArrayHolderFilter)o).getFilteredBeans(), path[1], bindToken);
                }
                if (terminal) {
                    return this.createInputTerminal(o, nullType, bindToken);
                }
                if (o == null) {
                    throw new ProcessingException("input bind " + bindToken + " resolves to null on path element: " + path[0]);
                }
            }
        } else if (bindBase instanceof ITableHolder) {
            ITableHolder table = (ITableHolder)bindBase;
            try {
                Method m = table.getClass().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), Integer.TYPE);
                if (m != null) {
                    found = true;
                    return new TableHolderInput(table, null, path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                found = false;
            }
        } else if (bindBase instanceof TableHolderFilter) {
            filter = (TableHolderFilter)bindBase;
            ITableHolder table = filter.getTableHolder();
            try {
                Method m = table.getClass().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), Integer.TYPE);
                if (m != null) {
                    found = true;
                    return new TableHolderInput(table, filter.getFilteredRows(), path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                found = false;
            }
        } else if (bindBase instanceof IBeanArrayHolder) {
            IBeanArrayHolder holder = (IBeanArrayHolder)bindBase;
            try {
                Method m = holder.getHolderType().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                if (m != null) {
                    found = true;
                    return new BeanArrayHolderInput(holder, null, path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                try {
                    Method m = holder.getHolderType().getMethod("is" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                    if (m != null) {
                        found = true;
                        return new BeanArrayHolderInput(holder, null, path[0], bindToken);
                    }
                }
                catch (Throwable throwable2) {
                    found = false;
                }
            }
        } else if (bindBase instanceof BeanArrayHolderFilter) {
            filter = (BeanArrayHolderFilter)bindBase;
            IBeanArrayHolder holder = filter.getBeanArrayHolder();
            try {
                Method m = holder.getHolderType().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                if (m != null) {
                    found = true;
                    return new BeanArrayHolderInput(holder, filter.getFilteredBeans(), path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                try {
                    Method m = holder.getHolderType().getMethod("is" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                    if (m != null) {
                        found = true;
                        return new BeanArrayHolderInput(holder, null, path[0], bindToken);
                    }
                }
                catch (Throwable throwable3) {
                    found = false;
                }
            }
        } else if (bindBase != null) {
            if (bindBase.getClass().isArray() && terminal) {
                return new BeanPropertyInput(path[0], (Object[])bindBase, bindToken);
            }
            if (bindBase instanceof Collection && terminal) {
                return new BeanPropertyInput(path[0], ((Collection)bindBase).toArray(), bindToken);
            }
            try {
                Method getter;
                Object propertyBean = bindBase;
                FastPropertyDescriptor pd = BeanUtility.getFastBeanInfo(propertyBean.getClass(), null).getPropertyDescriptor(path[0]);
                Method method = getter = pd != null ? pd.getReadMethod() : null;
                if (getter != null) {
                    o = getter.invoke(propertyBean, new Object[0]);
                    found = true;
                    if (terminal) {
                        return this.createInputTerminal(o, getter.getReturnType(), bindToken);
                    }
                    if (o == null) {
                        throw new ProcessingException("input bind " + bindToken + " resolves to null on path element: " + path[0]);
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (found) {
            if (terminal) {
                throw new ProcessingException("input bind '" + bindToken.getName() + "' was not recognized as a terminal");
            }
            String[] newPath = new String[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            return this.createInputRec(bindToken, newPath, o, nullType);
        }
        return null;
    }

    private IBindOutput createOutput(IToken bindToken, Object[] bindBases) throws ProcessingException {
        IBindOutput o = null;
        if (bindToken instanceof ValueOutputToken) {
            ValueOutputToken valueOutputToken = (ValueOutputToken)bindToken;
            String[] path = valueOutputToken.getName().split("[.]");
            int i = 0;
            while (i < bindBases.length) {
                o = this.createOutputRec(valueOutputToken, path, bindBases[i]);
                if (o != null) break;
                ++i;
            }
            if (o == null) {
                throw new ProcessingException("Cannot find output for '" + valueOutputToken + "' in bind base. When selecting into shared context variables make sure these variables are initialized using CONTEXT.set<i>PropertyName</i>(null)");
            }
        } else {
            throw new ProcessingException("Cannot find output for '" + bindToken.getClass());
        }
        return o;
    }

    private IBindOutput createOutputRec(ValueOutputToken bindToken, String[] path, final Object bindBase) throws ProcessingException {
        boolean terminal = path.length == 1;
        Object o = null;
        boolean found = false;
        if (bindBase instanceof Map) {
            o = ((Map)bindBase).get(path[0]);
            if (o != null) {
                found = true;
            } else if (((Map)bindBase).containsKey(path[0])) {
                found = true;
            }
            if (found) {
                if (o instanceof ITableHolder) {
                    ITableHolder table = (ITableHolder)o;
                    return new TableHolderOutput(table, path[1], bindToken);
                }
                if (o instanceof IBeanArrayHolder) {
                    IBeanArrayHolder holder = (IBeanArrayHolder)o;
                    return new BeanArrayHolderOutput(holder, path[1], bindToken);
                }
                if (o instanceof IHolder) {
                    if (terminal) {
                        return this.createOutputTerminal((IHolder)o, bindToken);
                    }
                    o = ((IHolder)o).getValue();
                } else {
                    if (o == null) {
                        if (terminal) {
                            return new MapOutput((Map)bindBase, path[0], bindToken);
                        }
                        throw new ProcessingException("output bind " + bindToken + " resolves to null on path element: " + path[0]);
                    }
                    if (terminal) {
                        return new MapOutput((Map)bindBase, path[0], bindToken);
                    }
                }
            }
        } else if (bindBase instanceof NVPair) {
            if (((NVPair)bindBase).getName().equals(path[0])) {
                o = ((NVPair)bindBase).getValue();
                found = true;
                if (o instanceof ITableHolder) {
                    ITableHolder table = (ITableHolder)o;
                    return new TableHolderOutput(table, path[1], bindToken);
                }
                if (o instanceof IBeanArrayHolder) {
                    IBeanArrayHolder holder = (IBeanArrayHolder)o;
                    return new BeanArrayHolderOutput(holder, path[1], bindToken);
                }
                if (o instanceof IHolder) {
                    if (terminal) {
                        return this.createOutputTerminal((IHolder)o, bindToken);
                    }
                    o = ((IHolder)o).getValue();
                } else {
                    if (o == null) {
                        throw new ProcessingException("output bind " + bindToken + " resolves to null on path element: " + path[0]);
                    }
                    if (terminal) {
                        throw new ProcessingException("output bind " + bindToken + " is not a valid output container");
                    }
                }
            }
        } else if (bindBase instanceof ITableHolder) {
            ITableHolder table = (ITableHolder)bindBase;
            try {
                Method m = table.getClass().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), Integer.TYPE);
                if (m != null) {
                    found = true;
                    return new TableHolderOutput(table, path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                found = false;
            }
        } else if (bindBase instanceof IBeanArrayHolder) {
            IBeanArrayHolder holder = (IBeanArrayHolder)bindBase;
            try {
                Method m = holder.getHolderType().getMethod("get" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                if (m != null) {
                    found = true;
                    return new BeanArrayHolderOutput(holder, path[0], bindToken);
                }
            }
            catch (Throwable throwable) {
                try {
                    Method m = holder.getHolderType().getMethod("is" + Character.toUpperCase(path[0].charAt(0)) + path[0].substring(1), new Class[0]);
                    if (m != null) {
                        found = true;
                        return new BeanArrayHolderOutput(holder, path[0], bindToken);
                    }
                }
                catch (Throwable throwable2) {
                    found = false;
                }
            }
        } else {
            try {
                FastPropertyDescriptor pd = BeanUtility.getFastBeanInfo(bindBase.getClass(), null).getPropertyDescriptor(path[0]);
                if (terminal) {
                    Method getter;
                    Method setter;
                    Method method = setter = pd != null ? pd.getWriteMethod() : null;
                    if (setter != null) {
                        found = true;
                        return new AbstractBeanPropertyOutput(bindBase.getClass(), path[0], bindToken){

                            @Override
                            protected Object[] getFinalBeanArray() {
                                return new Object[]{bindBase};
                            }
                        };
                    }
                    Method method2 = getter = pd != null ? pd.getReadMethod() : null;
                    if (getter != null) {
                        o = getter.invoke(bindBase, null);
                        if (o instanceof ITableHolder) {
                            throw new ProcessingException("output bind '" + bindToken.getName() + "' is a table and should not be a terminal");
                        }
                        if (o instanceof IBeanArrayHolder) {
                            throw new ProcessingException("output bind '" + bindToken.getName() + "' is a bean array and should not be a terminal");
                        }
                        if (o instanceof IHolder) {
                            return this.createOutputTerminal((IHolder)o, bindToken);
                        }
                        throw new ProcessingException("output bind '" + bindToken.getName() + "' is not a holder");
                    }
                } else {
                    Method getter;
                    Method method = getter = pd != null ? pd.getReadMethod() : null;
                    if (getter != null) {
                        Object readValue;
                        o = readValue = getter.invoke(bindBase, null);
                        found = true;
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (found) {
            if (terminal) {
                throw new ProcessingException("output bind '" + bindToken.getName() + "' was not recognized as a terminal");
            }
            String[] newPath = new String[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            return this.createOutputRec(bindToken, newPath, o);
        }
        return null;
    }

    private IBindOutput createOutputTerminal(IHolder h, ValueOutputToken bindToken) {
        Class cls = h.getHolderType();
        if (cls.isArray()) {
            if (cls == byte[].class || cls == char[].class) {
                return new SingleHolderOutput(h, bindToken);
            }
            return new ArrayHolderOutput(h, bindToken);
        }
        return new SingleHolderOutput(h, bindToken);
    }

    private IBindInput createInputTerminal(Object o, Class nullType, ValueInputToken bindToken) throws ProcessingException {
        if (o == null) {
            return new SingleInput(null, nullType, bindToken);
        }
        if (o instanceof IHolder) {
            Class cls = ((IHolder)o).getHolderType();
            if (nullType == null) {
                nullType = cls;
            }
            if (cls.isArray()) {
                if (cls == byte[].class || cls == char[].class) {
                    return new SingleInput(((IHolder)o).getValue(), nullType, bindToken);
                }
                return new ArrayInput(((IHolder)o).getValue(), bindToken);
            }
            if (cls == TriState.class) {
                return new TriStateInput((TriState)((IHolder)o).getValue(), bindToken);
            }
            return new SingleInput(((IHolder)o).getValue(), nullType, bindToken);
        }
        if (o instanceof Collection) {
            return new ArrayInput(((Collection)o).toArray(), bindToken);
        }
        if (o.getClass().isArray()) {
            Class<?> cls = o.getClass();
            if (cls == byte[].class || cls == char[].class) {
                return new SingleInput(o, nullType, bindToken);
            }
            return new ArrayInput(o, bindToken);
        }
        if (o.getClass() == TriState.class) {
            return new TriStateInput((TriState)o, bindToken);
        }
        return new SingleInput(o, nullType, bindToken);
    }

    protected void processDatabaseSpecificToken(DatabaseSpecificToken t, ISqlStyle sqlStyle) {
        String name = t.getName().toLowerCase();
        if (name.equals("sysdate")) {
            t.setReplaceToken(sqlStyle.getSysdateToken());
        } else if (name.equals("upper")) {
            t.setReplaceToken(sqlStyle.getUpperToken());
        } else if (name.equals("lower")) {
            t.setReplaceToken(sqlStyle.getLowerToken());
        } else if (name.equals("trim")) {
            t.setReplaceToken(sqlStyle.getTrimToken());
        } else if (name.equals("nvl")) {
            t.setReplaceToken(sqlStyle.getNvlToken());
        } else {
            LOG.warn("used unknown database specific token " + t.getParsedToken());
            t.setReplaceToken(name);
        }
    }
}

