/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.pool;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.SqlConnectionPool;

class ConnectionCloseThread
extends Thread {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SqlConnectionPool.class);
    private Connection m_conn;

    public ConnectionCloseThread(String name, Connection conn) {
        super(name);
        this.m_conn = conn;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        if (LOG.isInfoEnabled()) {
            LOG.info("close connection " + this.m_conn);
        }
        try {
            this.m_conn.close();
        }
        catch (SQLException e) {
            LOG.error("connection: " + this.m_conn, (Throwable)e);
        }
    }
}

