/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.style;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;

public class OracleSqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;

    @Override
    public String getConcatOp() {
        return "||";
    }

    @Override
    public String getLikeWildcard() {
        return "%";
    }

    @Override
    protected int getMaxListSize() {
        return 1000;
    }

    @Override
    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    @Override
    public boolean isBlobEnabled() {
        return true;
    }

    @Override
    public boolean isClobEnabled() {
        return true;
    }

    @Override
    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 FROM DUAL");
        }
        catch (Throwable throwable) {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (testStatement != null) {
            try {
                testStatement.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void writeBind(PreparedStatement ps, int jdbcBindIndex, SqlBind bind) throws SQLException {
        switch (bind.getSqlType()) {
            case 2005: {
                Clob clob;
                if (bind.getValue() instanceof Clob) {
                    super.writeBind(ps, jdbcBindIndex, bind);
                    break;
                }
                String s = (String)bind.getValue();
                try {
                    Class<?> clobClass = Class.forName("oracle.sql.CLOB", true, ps.getClass().getClassLoader());
                    clob = (Clob)clobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE).invoke(null, ps.getConnection(), false, clobClass.getField("DURATION_SESSION").get(null));
                }
                catch (Throwable t) {
                    SQLException ex = new SQLException("bind clob on jdbcIndex " + jdbcBindIndex);
                    ex.initCause(t);
                    throw ex;
                }
                try {
                    clob.getClass().getMethod("putString", Long.TYPE, String.class).invoke((Object)clob, 1, s);
                }
                catch (Throwable throwable) {
                    clob.setString(1L, s);
                }
                ps.setClob(jdbcBindIndex, clob);
                break;
            }
            case 2004: {
                Blob blob;
                if (bind.getValue() instanceof Blob) {
                    super.writeBind(ps, jdbcBindIndex, bind);
                    break;
                }
                byte[] data = (byte[])bind.getValue();
                try {
                    Class<?> blobClass = Class.forName("oracle.sql.BLOB", true, ps.getClass().getClassLoader());
                    blob = (Blob)blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE).invoke(null, ps.getConnection(), false, blobClass.getField("DURATION_SESSION").get(null));
                }
                catch (Throwable t) {
                    SQLException ex = new SQLException("bind blob on jdbcIndex " + jdbcBindIndex);
                    ex.initCause(t);
                    throw ex;
                }
                try {
                    blob.getClass().getMethod("putBytes", Long.TYPE, byte[].class).invoke((Object)blob, 1, data);
                }
                catch (Throwable throwable) {
                    blob.setBytes(1L, data);
                }
                ps.setBlob(jdbcBindIndex, blob);
                break;
            }
            default: {
                super.writeBind(ps, jdbcBindIndex, bind);
            }
        }
    }
}

