/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jms.internal;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jms.JmsJndiConfig;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;

public class JmsTransactionMember
implements ITransactionMember {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JmsTransactionMember.class);
    public static final String TRANSACTION_MEMBER_ID = "JmsTransactionMember";
    private ConnectionFactory m_cf;
    private Destination m_destination;
    private JmsJndiConfig m_config;
    private Connection m_conn;
    private Session m_session;
    private MessageConsumer m_mc;
    private MessageProducer m_mp;
    private boolean m_typeQueue;
    private boolean m_useSecurityCredential;

    public JmsTransactionMember(JmsJndiConfig config) {
        this.m_config = config;
    }

    public void ensureCache() throws ProcessingException {
        if (this.m_cf == null || this.m_destination == null) {
            InitialContext ctx = null;
            ctx = this.m_config.createInitialContext();
            try {
                this.m_cf = (ConnectionFactory)ctx.lookup(this.m_config.getConnectionFactoryJndiName());
                this.m_destination = (Destination)ctx.lookup(this.m_config.getJndiName());
            }
            catch (NamingException e) {
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public String getMemberId() {
        return new Long(this.m_config.getCrc()).toString();
    }

    public boolean isQueue() {
        return this.m_typeQueue;
    }

    public boolean isTopic() {
        return !this.m_typeQueue;
    }

    public void connectToJmsImmediately() throws ProcessingException {
        this.ensureConnectionToJms();
    }

    private void ensureConnectionToJms() throws ProcessingException {
        this.ensureCache();
        if (this.m_conn == null || this.m_session == null) {
            try {
                try {
                    this.m_conn = this.m_useSecurityCredential ? this.m_cf.createConnection(this.m_config.getUserName(), this.m_config.getPassword()) : this.m_cf.createConnection();
                }
                catch (Throwable throwable) {
                    if (this.isQueue()) {
                        this.m_conn = this.m_useSecurityCredential ? ((QueueConnectionFactory)this.m_cf).createQueueConnection(this.m_config.getUserName(), this.m_config.getPassword()) : ((QueueConnectionFactory)this.m_cf).createQueueConnection();
                    }
                    this.m_conn = this.m_useSecurityCredential ? ((TopicConnectionFactory)this.m_cf).createTopicConnection(this.m_config.getUserName(), this.m_config.getPassword()) : ((TopicConnectionFactory)this.m_cf).createTopicConnection();
                }
                try {
                    this.m_session = this.m_conn.createSession(true, 2);
                }
                catch (Throwable throwable) {
                    this.m_session = this.isQueue() ? ((QueueConnection)this.m_conn).createQueueSession(true, 2) : ((TopicConnection)this.m_conn).createTopicSession(true, 2);
                }
                this.m_conn.start();
            }
            catch (JMSException e) {
                this.release();
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
    }

    public Connection getConnection() throws ProcessingException {
        this.ensureConnectionToJms();
        return this.m_conn;
    }

    public Session getSession() throws ProcessingException {
        this.ensureConnectionToJms();
        return this.m_session;
    }

    public MessageConsumer getMessageConsumer() throws ProcessingException {
        block5: {
            this.ensureConnectionToJms();
            try {
                if (this.m_mc != null) break block5;
                try {
                    this.m_mc = this.m_session.createConsumer(this.m_destination);
                }
                catch (Throwable throwable) {
                    if (this.isQueue()) {
                        this.m_mc = ((QueueSession)this.m_session).createReceiver((Queue)this.m_destination);
                        break block5;
                    }
                    this.m_mc = ((TopicSession)this.m_session).createSubscriber((Topic)this.m_destination);
                }
            }
            catch (JMSException e) {
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
        return this.m_mc;
    }

    public MessageProducer getMessageProducer() throws ProcessingException {
        block5: {
            this.ensureConnectionToJms();
            try {
                if (this.m_mp != null) break block5;
                try {
                    this.m_mp = this.m_session.createProducer(this.m_destination);
                }
                catch (Throwable throwable) {
                    if (this.isQueue()) {
                        this.m_mp = ((QueueSession)this.m_session).createSender((Queue)this.m_destination);
                        break block5;
                    }
                    this.m_mp = ((TopicSession)this.m_session).createPublisher((Topic)this.m_destination);
                }
            }
            catch (JMSException e) {
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
        return this.m_mp;
    }

    public void putObject(Object obj, boolean autoCommit) throws ProcessingException {
        BytesMessage msg0;
        Session session;
        block16: {
            this.ensureCache();
            if (LOG.isInfoEnabled()) {
                LOG.info("obj=" + obj);
            }
            session = this.getSession();
            msg0 = null;
            try {
                BytesMessage msg;
                if (obj instanceof byte[]) {
                    msg = session.createBytesMessage();
                    msg.writeBytes((byte[])obj);
                    msg0 = msg;
                    break block16;
                }
                if (obj instanceof String) {
                    msg0 = msg = session.createTextMessage((String)obj);
                    break block16;
                }
                if (obj instanceof Serializable) {
                    msg0 = msg = session.createObjectMessage((Serializable)obj);
                    break block16;
                }
                throw new IllegalArgumentException("Cannot put object of type " + (obj != null ? obj.getClass() : null));
            }
            catch (JMSException e) {
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
        if (msg0 != null) {
            MessageProducer mp = this.getMessageProducer();
            try {
                mp.send((Message)msg0);
            }
            catch (Throwable throwable) {
                try {
                    if (this.isQueue()) {
                        ((QueueSender)mp).send((Message)msg0);
                    } else {
                        ((TopicPublisher)mp).publish((Message)msg0);
                    }
                }
                catch (JMSException e) {
                    throw new ProcessingException(e.getMessage(), e.getCause());
                }
            }
            if (autoCommit) {
                try {
                    session.commit();
                }
                catch (JMSException e) {
                    throw new ProcessingException(e.getMessage(), e.getCause());
                }
            }
        }
        this.release();
    }

    public Object getObject(long timeoutMillis, boolean autoCommit) throws ProcessingException {
        this.ensureCache();
        Session session = this.getSession();
        MessageConsumer mc = this.getMessageConsumer();
        Message msg = null;
        if (timeoutMillis > 0L) {
            try {
                msg = mc.receive(timeoutMillis);
            }
            catch (Throwable throwable) {
                try {
                    if (this.isQueue()) {
                        msg = ((QueueReceiver)mc).receive(timeoutMillis);
                    }
                    msg = ((TopicSubscriber)mc).receive(timeoutMillis);
                }
                catch (JMSException e) {
                    throw new ProcessingException(e.getMessage(), e.getCause());
                }
            }
        } else if (timeoutMillis == 0L) {
            try {
                msg = mc.receiveNoWait();
            }
            catch (Throwable throwable) {
                try {
                    if (this.isQueue()) {
                        msg = ((QueueReceiver)mc).receiveNoWait();
                    }
                    msg = ((TopicSubscriber)mc).receiveNoWait();
                }
                catch (JMSException e) {
                    throw new ProcessingException(e.getMessage(), e.getCause());
                }
            }
        } else {
            try {
                msg = mc.receive();
            }
            catch (Throwable throwable) {
                try {
                    msg = this.isQueue() ? ((QueueReceiver)mc).receive() : ((TopicSubscriber)mc).receive();
                }
                catch (JMSException e) {
                    throw new ProcessingException(e.getMessage(), e.getCause());
                }
            }
        }
        if (msg == null) {
            this.release();
            return null;
        }
        Object valueForS = null;
        try {
            if (msg instanceof TextMessage) {
                valueForS = ((TextMessage)msg).getText();
            } else if (msg instanceof BytesMessage) {
                byte[] ba = new byte[(int)((BytesMessage)msg).getBodyLength()];
                ((BytesMessage)msg).readBytes(ba);
                valueForS = ba;
            } else if (msg instanceof ObjectMessage) {
                valueForS = ((ObjectMessage)msg).getObject();
            } else {
                throw new IllegalArgumentException("Unexpected message of type " + msg.getClass());
            }
            msg.acknowledge();
            if (autoCommit) {
                session.commit();
            }
        }
        catch (JMSException e) {
            throw new ProcessingException(e.getMessage(), e.getCause());
        }
        this.release();
        return valueForS;
    }

    @Override
    public boolean needsCommit() {
        return true;
    }

    @Override
    public boolean commitPhase1() {
        return true;
    }

    @Override
    public void commitPhase2() {
        if (this.m_session != null) {
            try {
                this.m_session.commit();
            }
            catch (JMSException ex) {
                LOG.error("commit: " + this.m_session, (Throwable)ex);
            }
        }
    }

    @Override
    public void rollback() {
        if (this.m_session != null) {
            try {
                this.m_session.rollback();
            }
            catch (JMSException ex) {
                LOG.error("rollback: " + this.m_session, (Throwable)ex);
            }
        }
    }

    @Override
    public void release() {
        if (this.m_mc != null) {
            try {
                this.m_mc.close();
            }
            catch (JMSException fatal) {
                LOG.error(null, (Throwable)fatal);
            }
            this.m_mc = null;
        }
        if (this.m_mp != null) {
            try {
                this.m_mp.close();
            }
            catch (JMSException fatal) {
                LOG.error(null, (Throwable)fatal);
            }
            this.m_mp = null;
        }
        if (this.m_conn != null) {
            try {
                this.m_conn.stop();
            }
            catch (JMSException fatal) {
                LOG.error(null, (Throwable)fatal);
            }
            try {
                this.m_conn.close();
            }
            catch (JMSException fatal) {
                LOG.error(null, (Throwable)fatal);
            }
            this.m_conn = null;
        }
        if (this.m_session != null) {
            try {
                this.m_session.close();
            }
            catch (JMSException fatal) {
                LOG.error(null, (Throwable)fatal);
            }
            this.m_session = null;
        }
    }
}

