/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import java.lang.reflect.Method;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.security.internal.AccessControlStore;
import org.eclipse.scout.rt.shared.security.BasicHierarchyPermission;
import org.eclipse.scout.rt.shared.security.RemoteServiceAccessPermission;
import org.eclipse.scout.rt.shared.services.common.ping.IPingService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelAccessDenied;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class AbstractAccessControlService
extends AbstractService
implements IAccessControlService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractAccessControlService.class);
    private AccessControlStore m_accessControlStore;
    private boolean m_remoteAccessPolicyEnabled = false;

    public AbstractAccessControlService() {
        String s = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.service.security");
        if (s != null) {
            this.m_remoteAccessPolicyEnabled = "true".equals(s);
        }
    }

    public void initializeService() {
        this.m_accessControlStore = new AccessControlStore();
        super.initializeService();
    }

    public boolean checkPermission(Permission p) {
        if (p == null) {
            return true;
        }
        Permissions c = this.getPermissions();
        if (c == null) {
            return true;
        }
        return c.implies(p);
    }

    public int getPermissionLevel(Permission p) {
        if (p == null) {
            return 0;
        }
        if (!(p instanceof BasicHierarchyPermission)) {
            if (this.checkPermission(p)) {
                return 100;
            }
            return 0;
        }
        BasicHierarchyPermission hp = (BasicHierarchyPermission)p;
        Permissions c = this.getPermissions();
        if (c == null) {
            List levels = hp.getValidLevels();
            return (Integer)levels.get(levels.size() - 1);
        }
        int maxLevel = -1;
        Enumeration<Permission> en = c.elements();
        while (en.hasMoreElements()) {
            BasicHierarchyPermission hgrantedPermission;
            Permission grantedPermission = en.nextElement();
            if (grantedPermission instanceof AllPermission) {
                return 100;
            }
            if (grantedPermission instanceof BasicHierarchyPermission && (hgrantedPermission = (BasicHierarchyPermission)grantedPermission).getClass().isAssignableFrom(hp.getClass()) && (maxLevel = Math.max(maxLevel, hgrantedPermission.getLevel())) >= 100) break;
        }
        return maxLevel;
    }

    public Permissions getPermissions() {
        Permissions permSet = this.m_accessControlStore.getPermissionsOfCurrentSubject();
        if (permSet != null) {
            return permSet;
        }
        this.setPermissions(this.execLoadPermissions());
        permSet = this.m_accessControlStore.getPermissionsOfCurrentSubject();
        return permSet;
    }

    protected Permissions execLoadPermissions() {
        return null;
    }

    private void setPermissions(Permissions p) {
        if (p != null && !p.implies((Permission)new RemoteServiceAccessPermission(IPingService.class.getName(), "ping"))) {
            boolean existsAny = false;
            Enumeration<Permission> en = p.elements();
            while (en.hasMoreElements()) {
                Permission perm = en.nextElement();
                if (!(perm instanceof RemoteServiceAccessPermission)) continue;
                existsAny = true;
                break;
            }
            if (!existsAny) {
                LOG.warn("Legacy security hint: missing any RemoteServiceAccessPermissions in AccessController. Please verify the " + ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getClass() + " to include such permissions for accessing services using client proxies. Adding default rule to allow services of pattern '*'; Check to use at least the rule '*.shared.*'");
                p.add((Permission)new RemoteServiceAccessPermission("*", "*"));
            }
        }
        this.m_accessControlStore.setPermissionsOfCurrentSubject(p);
    }

    public boolean isProxyService() {
        return false;
    }

    public void clearCache() {
        this.m_accessControlStore.clearCache();
    }

    public void clearCacheOfPrincipals(String ... principalNames) {
        if (principalNames == null) {
            return;
        }
        String[] principals = this.m_accessControlStore.getPrincipalNames();
        ArrayList<String> toDelete = new ArrayList<String>();
        String[] stringArray = principalNames;
        int n = principalNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null) {
                name = name.toLowerCase();
                String[] stringArray2 = principals;
                int n3 = principals.length;
                int n4 = 0;
                while (n4 < n3) {
                    String p = stringArray2[n4];
                    if (p.equals(name) || p.endsWith("\\" + name)) {
                        toDelete.add(p);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.m_accessControlStore.clearCacheOfPrincipals(toDelete.toArray(new String[toDelete.size()]));
    }

    public boolean checkServiceTunnelAccess(Class serviceInterfaceClass, Method method, Object[] args) {
        try {
            if (!serviceInterfaceClass.isInterface()) {
                throw new SecurityException("access to " + serviceInterfaceClass + " denied.");
            }
            if (!IService.class.isAssignableFrom(serviceInterfaceClass)) {
                throw new SecurityException("remote acess to non-IService type: " + serviceInterfaceClass);
            }
            Method verifyMethod = serviceInterfaceClass.getMethod(method.getName(), method.getParameterTypes());
            if (verifyMethod.getAnnotation(ServiceTunnelAccessDenied.class) != null) {
                throw new SecurityException("ServiceTunnelAccessDenied by annotation ServiceTunnelAccessDenied");
            }
            if (method.getAnnotation(ServiceTunnelAccessDenied.class) != null) {
                throw new SecurityException("ServiceTunnelAccessDenied by annotation ServiceTunnelAccessDenied");
            }
        }
        catch (Throwable t) {
            LOG.warn("illegal service tunnel access to " + serviceInterfaceClass + "#" + method.getName() + " with arguments " + VerboseUtility.dumpObject((Object)args), t);
        }
        if (!this.m_remoteAccessPolicyEnabled) {
            return true;
        }
        throw new SecurityException("ServiceTunnelAccessDenied by annotation ServiceTunnelAccessDenied");
    }
}

