/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security.internal;

import java.security.AccessController;
import java.security.Permissions;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.PrincipalNameFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.SingleUserFilter;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.security.AccessControlChangedNotification;
import org.eclipse.scout.rt.shared.services.common.security.ResetAccessControlChangedNotification;
import org.eclipse.scout.service.SERVICES;

public class AccessControlStore {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AccessControlStore.class);
    private TTLCache<String, Permissions> m_store;
    private Object m_storeLock = new Object();

    public AccessControlStore() {
        this.m_store = new TTLCache(3600000L);
    }

    public Permissions getPermissionsOfCurrentSubject() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                Permissions permissions;
                if (principal == null) continue;
                String principalName = principal.getName();
                if (principalName != null) {
                    principalName = principalName.toLowerCase();
                }
                if ((permissions = this.getPermissions(principalName)) == null) continue;
                return permissions;
            }
        }
        return null;
    }

    public void setPermissionsOfCurrentSubject(Permissions p) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            throw new SecurityException("subject is null");
        }
        for (Principal principal : subject.getPrincipals()) {
            if (principal == null) continue;
            String principalName = principal.getName();
            if (principalName != null) {
                principalName = principalName.toLowerCase();
            }
            this.setPermissions(principalName, p);
            return;
        }
        throw new SecurityException("subject contains no principals");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions getPermissions(String principalName) {
        if (principalName == null) {
            return null;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            return (Permissions)this.m_store.get((Object)principalName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String principalName, Permissions p) {
        if (principalName != null) {
            Object object = this.m_storeLock;
            synchronized (object) {
                if (p == null) {
                    p = new Permissions();
                    p.setReadOnly();
                }
                this.m_store.put((Object)principalName.toLowerCase(), (Object)p);
            }
            ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(p), new PrincipalNameFilter(principalName, 120000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        String[] principalNames;
        Object object = this.m_storeLock;
        synchronized (object) {
            principalNames = this.m_store.keySet().toArray(new String[this.m_store.size()]);
        }
        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new ResetAccessControlChangedNotification(), new SingleUserFilter(null, 0L));
        this.clearCacheOfPrincipals(principalNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheOfPrincipals(String ... principalNames) {
        int n;
        Object object = this.m_storeLock;
        synchronized (object) {
            String[] stringArray = principalNames;
            int n2 = principalNames.length;
            n = 0;
            while (n < n2) {
                String principalName = stringArray[n];
                if (principalName != null) {
                    this.m_store.remove((Object)principalName.toLowerCase());
                }
                ++n;
            }
        }
        String[] stringArray = principalNames;
        n = principalNames.length;
        int n3 = 0;
        while (n3 < n) {
            String principalName = stringArray[n3];
            if (principalName != null) {
                ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new AccessControlChangedNotification(null), new PrincipalNameFilter(principalName, 120000L));
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPrincipalNames() {
        Object object = this.m_storeLock;
        synchronized (object) {
            return this.m_store.keySet().toArray(new String[this.m_store.keySet().size()]);
        }
    }
}

