/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.session;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

public class ServerSessionRegistryService
extends AbstractService
implements IServerSessionRegistryService {
    public static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerSessionRegistryService.class);

    @Override
    public <T extends IServerSession> T newServerSession(Class<T> clazz, Subject subject) throws ProcessingException {
        IServerSession serverSession;
        try {
            serverSession = (IServerSession)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new ProcessingException("create instance of " + clazz, t);
        }
        ServerJob initJob = new ServerJob("new " + clazz.getSimpleName(), serverSession, subject){

            @Override
            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                IServerSession serverSessionInside = ThreadContext.get(IServerSession.class);
                String symbolicName = serverSessionInside.getClass().getPackage().getName();
                Bundle bundle = Platform.getBundle((String)symbolicName);
                serverSessionInside.loadSession(bundle);
                return Status.OK_STATUS;
            }
        };
        initJob.runNow((IProgressMonitor)new NullProgressMonitor());
        initJob.throwOnError();
        return (T)serverSession;
    }
}

