/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.workflow.AbstractWorkflowStep;
import org.eclipse.scout.rt.server.services.common.workflow.IWorkflowService;
import org.eclipse.scout.rt.server.services.common.workflow.IWorkflowStep;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.workflow.AbstractWorkflowData;
import org.eclipse.scout.rt.shared.services.common.workflow.AbstractWorkflowStepData;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractWorkflowService<T extends AbstractWorkflowData>
extends AbstractService
implements IWorkflowService<T> {
    private ArrayList<IWorkflowStep> m_stepList = new ArrayList();
    private HashMap<Class<? extends IWorkflowStep>, IWorkflowStep> m_stepMap = new HashMap();

    public AbstractWorkflowService() {
        this.initConfig();
    }

    @Override
    public AbstractWorkflowData[] getAvailableWorkflowTypes(SearchFilter filter) throws ProcessingException {
        AbstractWorkflowData[] a = this.execCollectAvailableWorkflowTypes(filter);
        if (a == null) {
            a = new AbstractWorkflowData[]{};
        }
        return a;
    }

    @Override
    public AbstractWorkflowData[] getFilteredWorkflows(SearchFilter filter) throws ProcessingException {
        AbstractWorkflowData[] a = this.execCollectFilteredWorkflows(filter);
        if (a == null) {
            a = new AbstractWorkflowData[]{};
        }
        return a;
    }

    @Override
    public T create(T spec) throws ProcessingException {
        T data = this.execNew(spec);
        if (data != null) {
            data = this.resume(data);
        }
        return data;
    }

    @Override
    public T resume(T spec) throws ProcessingException {
        T data = this.execLoad(spec);
        if (data != null) {
            data = this.makeStateTransition(data);
        }
        return data;
    }

    @Override
    public T store(T data) throws ProcessingException {
        if (data != null) {
            this.execStore(data);
        }
        return data;
    }

    @Override
    public T finish(T data) throws ProcessingException {
        if (data != null) {
            try {
                this.execFinish(data);
            }
            finally {
                this.execStore(data);
            }
        }
        return data;
    }

    @Override
    public T discard(T data) throws ProcessingException {
        if (data != null) {
            try {
                this.execDiscard(data);
            }
            finally {
                this.execStore(data);
            }
        }
        return data;
    }

    @Override
    public T makeStateTransition(T data) throws ProcessingException {
        this.execValidateState(data);
        AbstractWorkflowStepData curStepData = data.getCurrentStepData();
        AbstractWorkflowStepData nextStepData = data.getNextStepData();
        IWorkflowStep curStep = null;
        if (curStepData != null) {
            curStep = this.execGetStepForData(curStepData);
        }
        IWorkflowStep nextStep = null;
        if (nextStepData != null) {
            nextStep = this.execGetStepForData(nextStepData);
        }
        if (curStep != null) {
            if (curStepData != null && curStepData.isCompleted()) {
                try {
                    curStep.completeStep((AbstractWorkflowData)data, curStepData, nextStep != null);
                    this.execStore(data);
                }
                catch (ProcessingException e) {
                    curStepData.setCompletionDate(null);
                    curStep.prepareStep((AbstractWorkflowData)data, curStepData, nextStep != null);
                    throw e;
                }
                if (curStepData.isCompleted()) {
                    data.advanceStepDataIndex();
                    this.execStore(data);
                    curStepData = data.getCurrentStepData();
                    nextStepData = data.getNextStepData();
                    curStep = null;
                    if (curStepData != null) {
                        curStep = this.execGetStepForData(curStepData);
                    }
                    nextStep = null;
                    if (nextStepData != null) {
                        nextStep = this.execGetStepForData(nextStepData);
                    }
                    if (curStep != null) {
                        curStep.prepareStep((AbstractWorkflowData)data, curStepData, nextStep != null);
                        this.execStore(data);
                    } else {
                        data = this.finish(data);
                    }
                }
            } else {
                curStep.prepareStep((AbstractWorkflowData)data, curStepData, nextStep != null);
                this.execStore(data);
            }
        } else {
            data = this.finish(data);
        }
        return data;
    }

    @Override
    public <S extends IWorkflowStep> S getStepByClass(Class<S> stepClass) {
        if (stepClass == null) {
            return null;
        }
        return (S)this.m_stepMap.get(stepClass);
    }

    protected IWorkflowStep execGetStepForData(AbstractWorkflowStepData data) {
        if (data != null) {
            for (IWorkflowStep step : this.m_stepList) {
                Class processingDataType = TypeCastUtility.getGenericsParameterClass(step.getClass(), AbstractWorkflowStep.class);
                if (processingDataType == null || !processingDataType.isInstance(data)) continue;
                return step;
            }
        }
        return null;
    }

    @Override
    public IWorkflowStep[] getSteps() {
        return this.m_stepList.toArray(new IWorkflowStep[this.m_stepList.size()]);
    }

    @Override
    public <S extends IWorkflowStep> S resolveStep(S step) {
        if (step == null) {
            return null;
        }
        return (S)this.m_stepMap.get(step.getClass());
    }

    public void assignDefinitions(AbstractWorkflowData data) {
        if (data != null) {
            data.setDefinitionText(this.getConfiguredDefinitionText());
            data.setDefinitionActive(this.getConfiguredDefinitionActive());
            data.setDefinitionServiceClass(this.getClass().getName());
            AbstractWorkflowStepData[] abstractWorkflowStepDataArray = data.getStepDataList();
            int n = abstractWorkflowStepDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractWorkflowStepData stepData = abstractWorkflowStepDataArray[n2];
                IWorkflowStep step = this.execGetStepForData(stepData);
                if (step != null) {
                    step.assignDefinitions(stepData);
                }
                ++n2;
            }
        }
    }

    private Class<? extends IWorkflowStep>[] getConfiguredSteps() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IWorkflowStep.class);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDefinitionText() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredDefinitionActive() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected AbstractWorkflowData[] execCollectAvailableWorkflowTypes(SearchFilter filter) throws ProcessingException {
        return new AbstractWorkflowData[0];
    }

    @ConfigOperation
    @Order(value=15.0)
    protected AbstractWorkflowData[] execCollectFilteredWorkflows(SearchFilter filter) throws ProcessingException {
        return new AbstractWorkflowData[0];
    }

    @ConfigOperation
    @Order(value=20.0)
    protected T execNew(T spec) throws ProcessingException {
        return spec;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected T execLoad(T spec) throws ProcessingException {
        return spec;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execStore(T data) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execValidateState(T data) throws ProcessingException {
        this.assignDefinitions((AbstractWorkflowData)data);
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execFinish(T data) throws ProcessingException {
        data.setFinishDate(new Date());
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execDiscard(T data) throws ProcessingException {
    }

    protected void initConfig() {
        Class<IWorkflowStep>[] classArray = this.getConfiguredSteps();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<IWorkflowStep> c = classArray[n2];
            try {
                IWorkflowStep step = (IWorkflowStep)ConfigurationUtility.newInnerInstance((Object)this, c);
                this.m_stepList.add(step);
                this.m_stepMap.put(c, step);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("create instance of " + c, (Throwable)e));
            }
            ++n2;
        }
    }
}

