/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.servlet.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.http.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.servlet.filter.AbstractChainableSecurityFilter;
import org.eclipse.scout.rt.server.servlet.filter.PrincipalHolder;
import org.eclipse.scout.rt.shared.services.common.security.SimplePrincipal;

public class LDAPSecurityFilter
extends AbstractChainableSecurityFilter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LDAPSecurityFilter.class);
    public static final String PROP_BASIC_ATTEMPT = "LDAPSecurityFilter.basicAttempt";
    private String m_serverUrl;
    private String m_baseDn;
    private String m_groupDn;
    private String m_groupAttr;

    @Override
    public void init(FilterConfig config0) throws ServletException {
        super.init(config0);
        FilterConfigInjection.FilterConfig config = new FilterConfigInjection(config0, this.getClass()).getAnyConfig();
        this.m_serverUrl = this.getParam((FilterConfig)config, "ldapServer", false);
        this.m_baseDn = this.getParam((FilterConfig)config, "ldapBaseDN", true);
        this.m_groupDn = this.getParam((FilterConfig)config, "lDAPgroupDN", true);
        this.m_groupAttr = this.getParam((FilterConfig)config, "lDAPgroupAttributeId", true);
    }

    protected String getParam(FilterConfig filterConfig, String paramName, boolean nullAllowed) throws ServletException {
        String paramValue = filterConfig.getInitParameter(paramName);
        boolean exists = false;
        if (paramValue == null && nullAllowed) {
            Enumeration initParameterNames = filterConfig.getInitParameterNames();
            while (initParameterNames.hasMoreElements() && !exists) {
                String object = (String)initParameterNames.nextElement();
                exists = object.equals(paramName);
            }
        }
        if (paramValue == null && !exists) {
            throw new ServletException("Missing init-param with name '" + paramName + "'.");
        }
        return paramValue;
    }

    @Override
    protected int negotiate(HttpServletRequest req, HttpServletResponse resp, PrincipalHolder holder) throws IOException, ServletException {
        int attempts;
        String h = req.getHeader("Authorization");
        if (h != null && h.matches("Basic .*")) {
            String[] a = new String(Base64Utility.decode((String)h.substring(6)), "ISO-8859-1").split(":", 2);
            String user = a[0].toLowerCase();
            String pass = a[1];
            if (user != null && pass != null && this.ldapLogin(this.m_serverUrl, this.m_baseDn, this.m_groupDn, this.m_groupAttr, user, pass, false)) {
                holder.setPrincipal((Principal)new SimplePrincipal(user));
                return 3;
            }
        }
        if ((attempts = this.getBasicAttempt(req)) > 2) {
            return 1;
        }
        this.setBasicAttept(req, attempts + 1);
        resp.setHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
        return 1;
    }

    private int getBasicAttempt(HttpServletRequest req) {
        int basicAtttempt = 0;
        Object attribute = req.getSession().getAttribute(PROP_BASIC_ATTEMPT);
        if (attribute instanceof Integer) {
            basicAtttempt = (Integer)attribute;
        }
        return basicAtttempt;
    }

    private void setBasicAttept(HttpServletRequest req, int attempts) {
        req.getSession().setAttribute(PROP_BASIC_ATTEMPT, (Object)attempts);
    }

    protected String getUserDN(String username, String server, String baseDN, String groupDN, String attributeId) throws ServletException {
        String userDN = "";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", String.valueOf(server) + "/" + baseDN);
        env.put("java.naming.security.principal", "=,," + baseDN);
        env.put("java.naming.security.credentials", "");
        env.put("java.naming.language", "de");
        try {
            InitialDirContext ldap = new InitialDirContext(env);
            Attributes attrs = ldap.getAttributes(groupDN, new String[]{attributeId});
            NamingEnumeration<? extends Attribute> equivalentToMe = attrs.getAll();
            Attribute attr = null;
            NamingEnumeration<?> allValues = null;
            String dn = null;
            String un = "";
            block2: while (equivalentToMe.hasMore()) {
                attr = equivalentToMe.next();
                allValues = attr.getAll();
                while (allValues.hasMore()) {
                    String[] parts;
                    dn = (String)allValues.next();
                    if (dn.length() <= 4 || (parts = (un = dn.substring(3)).split(",")).length <= 1 || !username.equals(un = parts[0].toLowerCase())) continue;
                    userDN = dn;
                    continue block2;
                }
            }
        }
        catch (NamingException ne) {
            LOG.error("Exception in getting user DN from LDAP: " + ne);
            throw new SecurityException(ne.getMessage(), ne);
        }
        return userDN;
    }

    private boolean ldapLogin(String server, String baseDN, String groupDN, String groupAttr, String username, String password, boolean showexceptions) throws ServletException {
        String userDN = this.getUserDN(username, server, baseDN, groupDN, groupAttr);
        if (userDN.equals("")) {
            return false;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", String.valueOf(server) + "/" + baseDN);
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.language", "de");
        try {
            new InitialDirContext(env);
            return true;
        }
        catch (NamingException ne) {
            if (showexceptions) {
                ne.printStackTrace();
            }
            return false;
        }
    }
}

