/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;

public class BasicTransaction
implements ITransaction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicTransaction.class);
    private Object m_memberMapLock;
    private HashMap<String, Object> m_memberMap;
    private ArrayList<Throwable> m_failures = new ArrayList();

    public BasicTransaction() {
        this.m_memberMapLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResource(ITransactionMember member) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember old;
            String memberId = member.getMemberId();
            if (LOG.isDebugEnabled()) {
                LOG.debug(memberId + "/" + member);
            }
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            if ((old = (ITransactionMember)this.m_memberMap.get(memberId)) != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("releasing overwritten " + memberId + "/" + old);
                }
                old.release();
            }
            this.m_memberMap.put(memberId, member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember getMember(String memberId) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            ITransactionMember res = (ITransactionMember)this.m_memberMap.get(memberId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(memberId + "->" + res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember[] getMembers() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            return this.m_memberMap.values().toArray(new ITransactionMember[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMember(ITransactionMember member) {
        if (member != null) {
            Object object = this.m_memberMapLock;
            synchronized (object) {
                Object o;
                String memberId = member.getMemberId();
                if (this.m_memberMap != null && (o = this.m_memberMap.get(memberId)) == member) {
                    this.m_memberMap.remove(memberId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(memberId + "->" + o);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitPhase1() {
        ArrayList<Object> xaList;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            xaList = new ArrayList<Object>(this.m_memberMap.values());
        }
        boolean allSuccessful = true;
        for (ITransactionMember iTransactionMember : xaList) {
            try {
                if (!iTransactionMember.needsCommit()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" " + iTransactionMember);
                }
                boolean b = iTransactionMember.commitPhase1();
                allSuccessful = allSuccessful && b;
            }
            catch (Throwable t) {
                LOG.error("commit phase 1" + iTransactionMember, t);
            }
        }
        return allSuccessful && !this.hasFailures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitPhase2() {
        ArrayList<Object> xaList;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            xaList = new ArrayList<Object>(this.m_memberMap.values());
        }
        for (ITransactionMember iTransactionMember : xaList) {
            try {
                if (!iTransactionMember.needsCommit()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" " + iTransactionMember);
                }
                iTransactionMember.commitPhase2();
            }
            catch (Throwable t) {
                LOG.error("commit phase 2" + iTransactionMember, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        ArrayList<Object> xaList;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            xaList = new ArrayList<Object>(this.m_memberMap.values());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("");
        }
        for (ITransactionMember iTransactionMember : xaList) {
            try {
                if (!iTransactionMember.needsCommit()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" " + iTransactionMember);
                }
                iTransactionMember.rollback();
            }
            catch (Throwable t) {
                LOG.error("rollback " + iTransactionMember, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ArrayList<Object> xaList;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_memberMap == null) {
                this.m_memberMap = new HashMap();
            }
            xaList = new ArrayList<Object>(this.m_memberMap.values());
            this.m_memberMap.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("");
        }
        for (ITransactionMember iTransactionMember : xaList) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" " + iTransactionMember);
                }
                iTransactionMember.release();
            }
            catch (Throwable t) {
                LOG.error("release " + iTransactionMember, t);
            }
        }
    }

    @Override
    public boolean hasFailures() {
        return this.m_failures.size() > 0;
    }

    @Override
    public Throwable[] getFailures() {
        return this.m_failures.toArray(new Throwable[this.m_failures.size()]);
    }

    @Override
    public void addFailure(Throwable t) {
        this.m_failures.add(t);
    }
}

