/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared;

public final class WebClientState {
    private static boolean defaultValue = false;
    private static final ThreadLocal<Boolean> THREAD_LOCAL = new ThreadLocal();

    private WebClientState() {
    }

    public static boolean isWebClientDefault() {
        return defaultValue;
    }

    public static boolean isRichClientDefault() {
        return !WebClientState.isWebClientDefault();
    }

    public static void setWebClientDefault(boolean b) {
        defaultValue = b;
    }

    public static boolean isWebClientInCurrentThread() {
        Boolean var = THREAD_LOCAL.get();
        if (var != null) {
            return var;
        }
        return WebClientState.isWebClientDefault();
    }

    public static boolean isRichClientInCurrentThread() {
        return !WebClientState.isWebClientInCurrentThread();
    }

    public static void setWebClientInCurrentThread(Boolean b) {
        THREAD_LOCAL.set(b);
    }

    public static String getFontSizeUnit() {
        if (WebClientState.isWebClientInCurrentThread()) {
            return "px";
        }
        return "pt";
    }
}

