/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data;

import org.eclipse.scout.rt.shared.data.IValidator;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.DefaultFormDataValidator;
import org.eclipse.scout.rt.shared.util.ValidationUtility;

public class DefaultValidator
implements IValidator {
    private int m_validationStrategy;
    private int m_defaultMaxLengthForString = 250;
    private int m_defaultMaxLengthForClob = 64000000;
    private int m_defaultMaxLengthForBlob = 64000000;
    private int m_defaultMaxLengthForArray = 10000;
    private static final String STRING_NAME = "String";
    private static final String CLOB_NAME = "Clob";
    private static final String BLOB_NAME = "Blob";
    private static final String ARRAY_NAME = "Array";

    public DefaultValidator(int validationStrategy) {
        this.m_validationStrategy = validationStrategy;
    }

    @Override
    public int getValidationStrategy() {
        return this.m_validationStrategy;
    }

    @Override
    public void setValidationStrategy(int strategy) {
        this.m_validationStrategy = strategy;
    }

    @Override
    public int getDefaultMaxLengthForString() {
        return this.m_defaultMaxLengthForString;
    }

    @Override
    public void setDefaultMaxLengthForString(int defaultMaxLengthForString) {
        this.m_defaultMaxLengthForString = defaultMaxLengthForString;
    }

    @Override
    public int getDefaultMaxLengthForClob() {
        return this.m_defaultMaxLengthForClob;
    }

    @Override
    public void setDefaultMaxLengthForClob(int defaultMaxLengthForClob) {
        this.m_defaultMaxLengthForClob = defaultMaxLengthForClob;
    }

    @Override
    public int getDefaultMaxLengthForBlob() {
        return this.m_defaultMaxLengthForBlob;
    }

    @Override
    public void setDefaultMaxLengthForBlob(int defaultMaxLengthForBlob) {
        this.m_defaultMaxLengthForBlob = defaultMaxLengthForBlob;
    }

    @Override
    public int getDefaultMaxLengthForArray() {
        return this.m_defaultMaxLengthForArray;
    }

    @Override
    public void setDefaultMaxLengthForArray(int defaultMaxLengthForArray) {
        this.m_defaultMaxLengthForArray = defaultMaxLengthForArray;
    }

    @Override
    public void validate(Object obj) throws Exception {
        if (this.getValidationStrategy() == 10) {
            return;
        }
        try {
            if (obj == null) {
                this.visitObject(obj);
                return;
            }
            ValidationUtility.ObjectTreeVisitor v = new ValidationUtility.ObjectTreeVisitor(){

                @Override
                protected boolean visitObject(Object o) throws Exception {
                    return DefaultValidator.this.visitObject(o);
                }
            };
            v.writeObject(obj);
        }
        catch (ValidationUtility.ObjectTreeVisitorMarkerException e) {
            throw (Exception)e.getCause();
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected boolean visitObject(Object obj) throws Exception {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractFormData) {
            new DefaultFormDataValidator(this, this.getValidationStrategy(), DefaultFormDataValidator.DEFAULT_VALUE_CHECKS).validate((AbstractFormData)obj);
            return false;
        }
        this.checkMaxLenghtDefault(obj);
        return true;
    }

    @Override
    public void checkMaxLenghtDefault(Object obj) throws Exception {
        if (obj == null) {
            return;
        }
        if (obj instanceof String) {
            ValidationUtility.checkMaxLength(STRING_NAME, obj, this.getDefaultMaxLengthForString());
            return;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            if (c == char[].class) {
                ValidationUtility.checkMaxLength(CLOB_NAME, obj, this.getDefaultMaxLengthForClob());
            } else if (c == byte[].class) {
                ValidationUtility.checkMaxLength(BLOB_NAME, obj, this.getDefaultMaxLengthForBlob());
            } else {
                ValidationUtility.checkMaxLength(ARRAY_NAME, obj, this.getDefaultMaxLengthForArray());
            }
        }
    }
}

