/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.CloneUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;

public abstract class AbstractFormData
implements Serializable,
Cloneable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractFormData.class);
    private static final long serialVersionUID = 1L;
    private Map<Class<? extends AbstractPropertyData>, AbstractPropertyData> m_propertyMap;
    private Map<Class<? extends AbstractFormFieldData>, AbstractFormFieldData> m_fieldMap;

    public AbstractFormData() {
        this.initConfig();
    }

    private Class<? extends AbstractPropertyData>[] getConfiguredPropertyDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractPropertyData.class);
    }

    private Class<? extends AbstractFormFieldData>[] getConfiguredFieldDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractFormFieldData.class);
    }

    protected void initConfig() {
        this.m_propertyMap = new HashMap<Class<? extends AbstractPropertyData>, AbstractPropertyData>();
        Class<? extends AbstractPropertyData>[] propArray = this.getConfiguredPropertyDatas();
        int i = 0;
        while (i < propArray.length) {
            try {
                AbstractPropertyData p = (AbstractPropertyData)ConfigurationUtility.newInnerInstance((Object)this, propArray[i]);
                this.m_propertyMap.put(p.getClass(), p);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        this.m_fieldMap = new HashMap<Class<? extends AbstractFormFieldData>, AbstractFormFieldData>();
        Class<? extends AbstractFormFieldData>[] fieldArray = this.getConfiguredFieldDatas();
        int i2 = 0;
        while (i2 < fieldArray.length) {
            try {
                AbstractFormFieldData f = (AbstractFormFieldData)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i2]);
                this.m_fieldMap.put(f.getClass(), f);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i2;
        }
    }

    public AbstractPropertyData getPropertyById(String id) {
        for (AbstractPropertyData p : this.m_propertyMap.values()) {
            if (!p.getPropertyId().equalsIgnoreCase(id)) continue;
            return p;
        }
        return null;
    }

    public <T extends AbstractPropertyData> T getPropertyByClass(Class<T> c) {
        return (T)this.m_propertyMap.get(c);
    }

    public <T extends AbstractPropertyData> void setPropertyByClass(Class<T> c, T v) {
        if (v == null) {
            this.m_propertyMap.remove(c);
        } else {
            this.m_propertyMap.put(c, v);
        }
    }

    public AbstractPropertyData[] getAllProperties() {
        return this.m_propertyMap != null ? this.m_propertyMap.values().toArray(new AbstractPropertyData[this.m_propertyMap.size()]) : new AbstractPropertyData[]{};
    }

    public AbstractFormFieldData getFieldById(String id) {
        for (AbstractFormFieldData f : this.m_fieldMap.values()) {
            if (!f.getFieldId().equals(id)) continue;
            return f;
        }
        return null;
    }

    public <T extends AbstractFormFieldData> T getFieldByClass(Class<T> c) {
        return (T)this.m_fieldMap.get(c);
    }

    public <T extends AbstractFormFieldData> void setFieldByClass(Class<T> c, T v) {
        if (v == null) {
            this.m_fieldMap.remove(c);
        } else {
            this.m_fieldMap.put(c, v);
        }
    }

    public AbstractFormFieldData[] getFields() {
        return this.m_fieldMap.values().toArray(new AbstractFormFieldData[this.m_fieldMap.size()]);
    }

    public Map<Integer, Map<String, AbstractFormFieldData>> getAllFieldsRec() {
        TreeMap<Integer, Map<String, AbstractFormFieldData>> breathFirstMap = new TreeMap<Integer, Map<String, AbstractFormFieldData>>();
        AbstractFormFieldData[] abstractFormFieldDataArray = this.getFields();
        int n = abstractFormFieldDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFormFieldData child = abstractFormFieldDataArray[n2];
            this.collectAllFieldsRec(child, breathFirstMap, 0, "");
            ++n2;
        }
        return breathFirstMap;
    }

    private void collectAllFieldsRec(AbstractFormFieldData field, Map<Integer, Map<String, AbstractFormFieldData>> breathFirstMap, int level, String prefix) {
        Map<String, AbstractFormFieldData> subMap = breathFirstMap.get(level);
        if (subMap == null) {
            subMap = new HashMap<String, AbstractFormFieldData>();
            breathFirstMap.put(level, subMap);
        }
        subMap.put(String.valueOf(prefix) + field.getFieldId(), field);
        AbstractFormFieldData[] abstractFormFieldDataArray = field.getFields();
        int n = abstractFormFieldDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFormFieldData child = abstractFormFieldDataArray[n2];
            this.collectAllFieldsRec(child, breathFirstMap, level + 1, String.valueOf(prefix) + field.getFieldId() + "/");
            ++n2;
        }
    }

    public AbstractFormFieldData findFieldByClass(Map<Integer, Map<String, AbstractFormFieldData>> breathFirstMap, ClassIdentifier valueTypeIdentifier) throws ProcessingException {
        if (breathFirstMap == null) {
            breathFirstMap = this.getAllFieldsRec();
        }
        AbstractFormFieldData candidate = null;
        for (Map<String, AbstractFormFieldData> subMap : breathFirstMap.values()) {
            for (Map.Entry<String, AbstractFormFieldData> entry : subMap.entrySet()) {
                AbstractFormFieldData fd = entry.getValue();
                String fieldId = entry.getKey();
                if (!this.matchesAllParts(valueTypeIdentifier, fieldId, fd)) continue;
                if (candidate != null) {
                    throw new ProcessingException("Found more than one field for class: [" + fd.getClass() + "]");
                }
                candidate = fd;
            }
        }
        return candidate;
    }

    public Map<Integer, Map<String, AbstractPropertyData<?>>> getAllPropertiesRec() {
        TreeMap breathFirstMap = new TreeMap();
        HashMap<String, AbstractPropertyData> rootMap = new HashMap<String, AbstractPropertyData>();
        breathFirstMap.put(0, rootMap);
        Serializable[] serializableArray = this.getAllProperties();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPropertyData prop = serializableArray[n2];
            rootMap.put(prop.getClass().getSimpleName(), prop);
            ++n2;
        }
        serializableArray = this.getFields();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            Serializable child = serializableArray[n2];
            this.collectAllPropertiesRec((AbstractFormFieldData)child, breathFirstMap, 1, String.valueOf(((AbstractFormFieldData)child).getFieldId()) + "/");
            ++n2;
        }
        return breathFirstMap;
    }

    private void collectAllPropertiesRec(AbstractFormFieldData field, Map<Integer, Map<String, AbstractPropertyData<?>>> breathFirstMap, int level, String prefix) {
        Map<String, AbstractPropertyData<?>> subMap = breathFirstMap.get(level);
        if (subMap == null) {
            subMap = new HashMap();
            breathFirstMap.put(level, subMap);
        }
        Serializable[] serializableArray = field.getAllProperties();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPropertyData prop = serializableArray[n2];
            subMap.put(String.valueOf(prefix) + prop.getClass().getSimpleName(), prop);
            ++n2;
        }
        serializableArray = field.getFields();
        n = serializableArray.length;
        n2 = 0;
        while (n2 < n) {
            Serializable child = serializableArray[n2];
            this.collectAllPropertiesRec((AbstractFormFieldData)child, breathFirstMap, level + 1, String.valueOf(prefix) + ((AbstractFormFieldData)child).getFieldId() + "/");
            ++n2;
        }
    }

    public AbstractPropertyData<?> findPropertyByClass(Map<Integer, Map<String, AbstractPropertyData<?>>> breathFirstMap, ClassIdentifier valueTypeClassIdentifier) throws ProcessingException {
        if (breathFirstMap == null) {
            breathFirstMap = this.getAllPropertiesRec();
        }
        AbstractPropertyData<?> candidate = null;
        for (Map<String, AbstractPropertyData<?>> subMap : breathFirstMap.values()) {
            for (Map.Entry<String, AbstractPropertyData<?>> entry : subMap.entrySet()) {
                AbstractPropertyData<?> pd;
                String propertyId = entry.getKey();
                if (!this.matchesAllParts(valueTypeClassIdentifier, propertyId, pd = entry.getValue())) continue;
                if (candidate != null) {
                    throw new ProcessingException("Found more than one property for class: [" + pd.getClass() + "]");
                }
                candidate = pd;
            }
        }
        return candidate;
    }

    public Object clone() {
        try {
            return CloneUtility.createDeepCopyBySerializing((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean matchesAllParts(ClassIdentifier valueTypeIdentifier, String fullyQualifiedFieldId, Object obj) {
        if (obj == null || obj.getClass() != valueTypeIdentifier.getLastSegment()) {
            return false;
        }
        Class[] classes = valueTypeIdentifier.getClasses();
        String[] fieldIdParts = fullyQualifiedFieldId.split("[/]");
        int i = classes.length - 2;
        int j = fieldIdParts.length - 2;
        while (i >= 0 && j >= 0) {
            String fieldId = classes[i].getName();
            int i1 = Math.max(fieldId.lastIndexOf(36), fieldId.lastIndexOf(46));
            if (fieldIdParts[j].equals(fieldId = fieldId.substring(i1 + 1))) {
                --i;
            }
            --j;
        }
        return i < 0;
    }
}

