/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.data.IValidator;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.util.ValidationUtility;

public class DefaultFormDataValidator {
    public static final Map<String, IValueCheck> DEFAULT_VALUE_CHECKS;
    private final IValidator m_baseValidator;
    private AbstractFormData m_formData;
    private Map<String, IValueCheck> m_valueChecks;
    private int m_validationStrategy;

    static {
        HashMap<String, IValueCheck> map = new HashMap<String, IValueCheck>();
        map.put("mandatory", new DefaultMandatoryCheck());
        map.put("minLength", new DefaultMinLengthCheck());
        map.put("maxLength", new DefaultMaxLengthCheck());
        map.put("minValue", new DefaultMinValueCheck());
        map.put("maxValue", new DefaultMaxValueCheck());
        map.put("codeType", new DefaultCodeTypeCheck());
        map.put("lookupCall", new DefaultLookupCallCheck());
        map.put("regex", new DefaultRegexCheck());
        map.put("masterValueRequired", new DefaultMasterValueRequiredCheck());
        DEFAULT_VALUE_CHECKS = Collections.unmodifiableMap(map);
    }

    public DefaultFormDataValidator(IValidator baseValidator, int validationStrategy) {
        this(baseValidator, validationStrategy, DEFAULT_VALUE_CHECKS);
    }

    public DefaultFormDataValidator(IValidator baseValidator, int validationStrategy, Map<String, IValueCheck> defaultValueChecks) {
        this.m_baseValidator = baseValidator;
        this.m_validationStrategy = validationStrategy;
        this.m_valueChecks = defaultValueChecks;
    }

    public IValidator getBaseValidator() {
        return this.m_baseValidator;
    }

    public AbstractFormData getFormData() {
        return this.m_formData;
    }

    protected void setFormData(AbstractFormData formData) {
        this.m_formData = formData;
    }

    public int getValidationStrategy() {
        return this.m_validationStrategy;
    }

    public void setValidationStrategy(int strategy) {
        this.m_validationStrategy = strategy;
    }

    public Map<String, IValueCheck> getValueChecks() {
        return this.m_valueChecks;
    }

    public void setValueChecks(Map<String, IValueCheck> valueChecks) {
        this.m_valueChecks = valueChecks;
    }

    public void validate(AbstractFormData formData) throws Exception {
        Map<String, Object> ruleMap;
        this.setFormData(formData);
        if (this.getValidationStrategy() == 10) {
            return;
        }
        for (Map<String, AbstractPropertyData<?>> map : formData.getAllPropertiesRec().values()) {
            for (AbstractPropertyData<?> abstractPropertyData : map.values()) {
                ruleMap = new HashMap<String, Object>();
                this.preprocessRuleMap(ruleMap);
                this.visitProperty(abstractPropertyData, ruleMap);
            }
        }
        for (Map<String, Serializable> map : formData.getAllFieldsRec().values()) {
            for (AbstractFormFieldData abstractFormFieldData : map.values()) {
                ruleMap = abstractFormFieldData.getValidationRules();
                this.preprocessRuleMap(ruleMap);
                this.visitField(abstractFormFieldData, ruleMap);
            }
        }
    }

    protected void preprocessRuleMap(Map<String, Object> ruleMap) {
        if (this.getValidationStrategy() == 11) {
            ruleMap.remove("mandatory");
            ruleMap.remove("minLength");
            ruleMap.remove("minValue");
            ruleMap.remove("maxValue");
            ruleMap.remove("masterValueRequired");
        }
    }

    protected void visitProperty(AbstractPropertyData<?> prop, Map<String, Object> ruleMap) throws Exception {
        if (!prop.isValueSet()) {
            return;
        }
        if (ruleMap.size() == 0) {
            return;
        }
        ValueCheckContext ctx = null;
        for (Map.Entry<String, Object> e : ruleMap.entrySet()) {
            IValueCheck check = this.getValueChecks().get(e.getKey());
            if (check == null) continue;
            if (ctx == null) {
                ctx = new ValueCheckContext();
                ctx.formData = this.getFormData();
                ctx.fieldName = prop.getClass().getSimpleName();
                ctx.fieldType = prop.getHolderType();
                ctx.fieldValue = prop.getValue();
                ctx.ruleMap = ruleMap;
            }
            ctx.ruleName = e.getKey();
            ctx.ruleValue = e.getValue();
            check.check(ctx);
        }
        if (this.getBaseValidator() != null && !ruleMap.containsKey("maxLength")) {
            this.getBaseValidator().checkMaxLenghtDefault(prop.getValue());
        }
    }

    protected void visitField(AbstractFormFieldData field, Map<String, Object> ruleMap) throws Exception {
        if (!field.isValueSet()) {
            return;
        }
        if (ruleMap.size() == 0) {
            return;
        }
        ValueCheckContext ctx = null;
        for (Map.Entry<String, Object> e : ruleMap.entrySet()) {
            IValueCheck check = this.getValueChecks().get(e.getKey());
            if (check == null) continue;
            if (ctx == null) {
                ctx = new ValueCheckContext();
                ctx.formData = this.getFormData();
                ctx.fieldName = field.getClass().getSimpleName();
                if (field instanceof AbstractValueFieldData) {
                    ctx.fieldType = ((AbstractValueFieldData)field).getHolderType();
                    ctx.fieldValue = ((AbstractValueFieldData)field).getValue();
                }
                ctx.ruleMap = ruleMap;
            }
            ctx.ruleName = e.getKey();
            ctx.ruleValue = e.getValue();
            check.check(ctx);
        }
        if (this.getBaseValidator() != null && !ruleMap.containsKey("maxLength")) {
            if (field instanceof AbstractValueFieldData) {
                if (!ruleMap.containsKey("maxLength")) {
                    this.getBaseValidator().checkMaxLenghtDefault(((AbstractValueFieldData)field).getValue());
                }
            } else if (field instanceof AbstractTreeFieldData) {
                this.getBaseValidator().validate(field);
            } else if (field instanceof AbstractTableFieldData) {
                this.getBaseValidator().validate(field);
            }
        }
    }

    public static class DefaultCodeTypeCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            if (ctx.fieldType.isArray()) {
                if (ctx.fieldValue != null && Array.getLength(ctx.fieldValue) > 0) {
                    ValidationUtility.checkCodeTypeArray(ctx.fieldName, ctx.fieldValue, this.createCodeType(ctx));
                }
            } else if (ctx.fieldValue != null) {
                ValidationUtility.checkCodeTypeValue(ctx.fieldName, ctx.fieldValue, this.createCodeType(ctx));
            }
        }

        protected ICodeType<?> createCodeType(ValueCheckContext ctx) throws ProcessingException {
            Class cls = (Class)ctx.ruleValue;
            Object codeType = CODES.getCodeType(cls);
            if (codeType == null) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " codeType " + cls.getSimpleName() + " does not exist");
            }
            return codeType;
        }
    }

    public static class DefaultLookupCallCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            if (ctx.fieldType.isArray()) {
                if (ctx.fieldValue != null && Array.getLength(ctx.fieldValue) > 0) {
                    ValidationUtility.checkLookupCallArray(ctx.fieldName, ctx.fieldValue, this.createLookupCall(ctx));
                }
            } else if (ctx.fieldValue != null) {
                ValidationUtility.checkLookupCallValue(ctx.fieldName, ctx.fieldValue, this.createLookupCall(ctx));
            }
        }

        protected LookupCall createLookupCall(ValueCheckContext ctx) throws ProcessingException {
            LookupCall call;
            Class cls = (Class)ctx.ruleValue;
            try {
                call = (LookupCall)cls.newInstance();
            }
            catch (Throwable throwable) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " can not verify " + cls.getSimpleName());
            }
            if (ctx.ruleMap.containsKey("masterValueField")) {
                Class masterFieldClass = (Class)ctx.ruleMap.get("masterValueField");
                if (masterFieldClass == null) {
                    throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field");
                }
                AbstractValueFieldData masterField = (AbstractValueFieldData)ctx.formData.getFieldByClass(masterFieldClass);
                if (masterField == null) {
                    throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field " + masterFieldClass.getSimpleName());
                }
                call.setMaster(masterField.getValue());
            }
            return call;
        }
    }

    public static class DefaultMandatoryCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            if (!Boolean.TRUE.equals(ctx.ruleValue)) {
                return;
            }
            if (ctx.fieldType.isArray()) {
                ValidationUtility.checkMandatoryArray(ctx.fieldName, ctx.fieldValue);
            } else {
                ValidationUtility.checkMandatoryValue(ctx.fieldName, ctx.fieldValue);
            }
        }
    }

    public static class DefaultMasterValueRequiredCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            Object slaveValue = ctx.fieldValue;
            if (slaveValue == null || slaveValue.getClass().isArray() && Array.getLength(slaveValue) == 0) {
                return;
            }
            if (!Boolean.TRUE.equals(ctx.ruleMap.get("masterValueRequired"))) {
                return;
            }
            Class masterFieldClass = (Class)ctx.ruleMap.get("masterValueField");
            if (masterFieldClass == null) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field");
            }
            AbstractValueFieldData masterField = (AbstractValueFieldData)ctx.formData.getFieldByClass(masterFieldClass);
            if (masterField == null) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field " + masterFieldClass.getSimpleName());
            }
            Object masterValue = masterField.getValue();
            if (masterValue == null || masterValue.getClass().isArray() && Array.getLength(masterValue) == 0) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " slave is set but master is null: " + masterFieldClass.getSimpleName() + " -> " + ctx.fieldName);
            }
        }
    }

    public static class DefaultMaxLengthCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            ValidationUtility.checkMaxLength(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
        }
    }

    public static class DefaultMaxValueCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            ValidationUtility.checkMaxValue(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
        }
    }

    public static class DefaultMinLengthCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            ValidationUtility.checkMinLength(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
        }
    }

    public static class DefaultMinValueCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            ValidationUtility.checkMinValue(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
        }
    }

    public static class DefaultRegexCheck
    implements IValueCheck {
        @Override
        public void check(ValueCheckContext ctx) throws Exception {
            if (ctx.fieldType.isArray()) {
                ValidationUtility.checkArrayMatchesRegex(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
            } else {
                ValidationUtility.checkValueMatchesRegex(ctx.fieldName, ctx.fieldValue, ctx.ruleValue);
            }
        }
    }

    public static interface IValueCheck {
        public void check(ValueCheckContext var1) throws Exception;
    }

    public static class ValueCheckContext {
        public AbstractFormData formData;
        public Map<String, Object> ruleMap;
        public String ruleName;
        public Object ruleValue;
        public String fieldName;
        public Class<?> fieldType;
        public Object fieldValue;
    }
}

