/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public abstract class AbstractDataModel
implements IDataModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModel.class);
    private boolean m_calledInitializer;
    private IDataModelAttribute[] m_attributes;
    private IDataModelEntity[] m_entities;

    public AbstractDataModel() {
        this(true);
    }

    public AbstractDataModel(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_calledInitializer) {
            this.m_calledInitializer = true;
            this.initConfig();
        }
    }

    protected IDataModelAttribute[] createAttributes() {
        ArrayList<IDataModelAttribute> attributes = new ArrayList<IDataModelAttribute>();
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] classArray = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])all, IDataModelAttribute.class);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            try {
                IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this, (Class)c);
                attributes.add(a);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++n2;
        }
        return attributes.toArray(new IDataModelAttribute[attributes.size()]);
    }

    protected IDataModelEntity[] createEntities() {
        ArrayList<IDataModelEntity> entities = new ArrayList<IDataModelEntity>();
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] classArray = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])all, IDataModelEntity.class);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            try {
                IDataModelEntity e = (IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this, (Class)c);
                entities.add(e);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++n2;
        }
        return entities.toArray(new IDataModelEntity[entities.size()]);
    }

    protected void initConfig() {
        IDataModelAttribute[] iDataModelAttributeArray = this.m_attributes = this.createAttributes();
        int n = this.m_attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModelAttribute a = iDataModelAttributeArray[n2];
            a.setParentEntity(null);
            ++n2;
        }
        this.m_entities = this.createEntities();
        HashMap<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap = new HashMap<Class<? extends IDataModelEntity>, IDataModelEntity>();
        IDataModelEntity[] iDataModelEntityArray = this.m_entities;
        int n3 = this.m_entities.length;
        n = 0;
        while (n < n3) {
            IDataModelEntity e = iDataModelEntityArray[n];
            e.setParentEntity(null);
            instanceMap.put(e.getClass(), e);
            ++n;
        }
        iDataModelEntityArray = this.m_entities;
        n3 = this.m_entities.length;
        n = 0;
        while (n < n3) {
            IDataModelEntity e = iDataModelEntityArray[n];
            e.initializeChildEntities(instanceMap);
            ++n;
        }
    }

    @Override
    public void init() {
        Object[] objectArray = this.getEntities();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModelEntity e = objectArray[n2];
            try {
                e.initEntity();
            }
            catch (Throwable t) {
                LOG.error("entity " + e, t);
            }
            ++n2;
        }
        objectArray = this.getAttributes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            try {
                a.initAttribute();
            }
            catch (Throwable t) {
                LOG.error("attribute " + a, t);
            }
            ++n2;
        }
    }

    @Override
    public IDataModelAttribute[] getAttributes() {
        return this.m_attributes;
    }

    @Override
    public IDataModelEntity[] getEntities() {
        return this.m_entities;
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        IDataModelAttribute[] iDataModelAttributeArray = this.m_attributes;
        int n = this.m_attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModelAttribute attribute = iDataModelAttributeArray[n2];
            if (attribute.getClass() == attributeClazz) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        IDataModelEntity[] iDataModelEntityArray = this.m_entities;
        int n = this.m_entities.length;
        int n2 = 0;
        while (n2 < n) {
            IDataModelEntity entity = iDataModelEntityArray[n2];
            if (entity.getClass() == entityClazz) {
                return entity;
            }
            ++n2;
        }
        return null;
    }
}

