/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.security.Permission;
import java.util.Map;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.DataModelAttributeInjector;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDataModelAttribute
extends AbstractPropertyObserver
implements IDataModelAttribute,
DataModelConstants,
Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModelAttribute.class);
    private static final long serialVersionUID = 1L;
    private String m_id;
    private String m_text;
    private int m_type;
    private IDataModelAttributeOp[] m_operators;
    private int[] m_aggregationTypes;
    private String m_iconId;
    private boolean m_allowNullOperator;
    private boolean m_allowNotOperator;
    private boolean m_aggregationEnabled;
    private Class<? extends ICodeType> m_codeTypeClass;
    private LookupCall m_lookupCall;
    private Permission m_visiblePermission;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private boolean m_visible;
    private IDataModelEntity m_parentEntity;

    public AbstractDataModelAttribute() {
        this.initConfig();
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends ICodeType> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="COMPOSER_ATTRIBUTE_TYPE")
    @Order(value=70.0)
    @ConfigPropertyValue(value="TYPE_STRING")
    protected int getConfiguredType() {
        return 15;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredNullOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredNotOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=105.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAggregationEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAttribute() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPrepareLookup(LookupCall call) throws ProcessingException {
    }

    @Override
    public Map<String, String> getMetaDataOfAttribute() {
        return null;
    }

    protected void initConfig() {
        Class<? extends LookupCall> lsCls;
        this.m_visibleGranted = true;
        this.setNotOperatorEnabled(this.getConfiguredNotOperatorEnabled());
        this.setNullOperatorEnabled(this.getConfiguredNullOperatorEnabled());
        this.setAggregationEnabled(this.getConfiguredAggregationEnabled());
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setType(this.getConfiguredType());
        this.setVisible(this.getConfiguredVisible());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lsCls = this.getConfiguredLookupCall()) != null) {
            try {
                LookupCall call = lsCls.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        this.injectOperators();
        this.injectAggregationTypes();
    }

    protected void injectOperators() {
        new DataModelAttributeInjector().injectOperators(this);
    }

    protected void injectAggregationTypes() {
        new DataModelAttributeInjector().injectAggregationTypes(this);
    }

    @Override
    public final void initAttribute() throws ProcessingException {
        this.execInitAttribute();
    }

    @Override
    public void prepareLookup(LookupCall call) throws ProcessingException {
        this.execPrepareLookup(call);
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public void setType(int i) {
        this.m_type = i;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public IDataModelAttributeOp[] getOperators() {
        return this.m_operators;
    }

    @Override
    public void setOperators(IDataModelAttributeOp[] ops) {
        this.m_operators = ops;
    }

    @Override
    public int[] getAggregationTypes() {
        return this.m_aggregationTypes != null ? this.m_aggregationTypes : new int[]{};
    }

    @Override
    public void setAggregationTypes(int[] aggregationTypes) {
        this.m_aggregationTypes = aggregationTypes;
    }

    @Override
    public boolean containsAggregationType(int agType) {
        if (this.m_aggregationTypes == null) {
            return false;
        }
        int[] nArray = this.m_aggregationTypes;
        int n = this.m_aggregationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == agType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isNullOperatorEnabled() {
        return this.m_allowNullOperator;
    }

    @Override
    public void setNullOperatorEnabled(boolean b) {
        this.m_allowNullOperator = b;
    }

    @Override
    public boolean isAggregationEnabled() {
        return this.m_aggregationEnabled;
    }

    @Override
    public void setAggregationEnabled(boolean aggregationEnabled) {
        this.m_aggregationEnabled = aggregationEnabled;
        if (this.m_aggregationTypes != null) {
            this.injectAggregationTypes();
        }
    }

    @Override
    public boolean isNotOperatorEnabled() {
        return this.m_allowNotOperator;
    }

    @Override
    public void setNotOperatorEnabled(boolean b) {
        this.m_allowNotOperator = b;
    }

    @Override
    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = new CodeLookupCall(this.m_codeTypeClass);
        }
    }

    @Override
    public LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.m_visiblePermission = p;
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    @Override
    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    private void calculateVisible() {
        this.m_visible = this.m_visibleGranted && this.m_visibleProperty;
    }
}

