/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public final class DataModelUtility {
    private static final Pattern PAT_EXTERNAL_ID = Pattern.compile("((.+)/)?([^/;]+)(;(.+))?");
    private static final Pattern PAT_SEMI_COLON = Pattern.compile("[;]");
    private static final Pattern PAT_NVPAIR = Pattern.compile("([^=]+)=(.*)");

    private DataModelUtility() {
    }

    public static String entityToExternalId(IDataModelEntity e) {
        if (e.getParentEntity() != null) {
            return String.valueOf(DataModelUtility.entityToExternalId(e.getParentEntity())) + "/" + e.getClass().getSimpleName();
        }
        return e.getClass().getSimpleName();
    }

    public static String attributeToExternalId(IDataModelAttribute a) {
        if (a.getParentEntity() != null) {
            return String.valueOf(DataModelUtility.entityToExternalId(a.getParentEntity())) + "/" + a.getClass().getSimpleName() + DataModelUtility.exportMetaData(a.getMetaDataOfAttribute());
        }
        return String.valueOf(a.getClass().getSimpleName()) + DataModelUtility.exportMetaData(a.getMetaDataOfAttribute());
    }

    public static IDataModelEntity externalIdToEntity(IDataModel f, String externalId, IDataModelEntity parentEntity) {
        if (externalId == null) {
            return null;
        }
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        if (folderName != null && (parentEntity = DataModelUtility.externalIdToEntity(f, folderName, parentEntity)) == null) {
            return null;
        }
        if (parentEntity != null) {
            return DataModelUtility.findEntity(parentEntity.getEntities(), elemName);
        }
        return DataModelUtility.findEntity(f.getEntities(), elemName);
    }

    public static IDataModelAttribute externalIdToAttribute(IDataModel f, String externalId, IDataModelEntity parentEntity) {
        if (externalId == null) {
            return null;
        }
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        Map<String, String> meta = DataModelUtility.importMetaData(m.group(5));
        if (folderName != null && (parentEntity = DataModelUtility.externalIdToEntity(f, folderName, parentEntity)) == null) {
            return null;
        }
        if (parentEntity != null) {
            return DataModelUtility.findAttribute(parentEntity.getAttributes(), elemName, meta);
        }
        return DataModelUtility.findAttribute(f.getAttributes(), elemName, meta);
    }

    public static IDataModelEntity findEntity(IDataModelEntity[] array, String simpleName) {
        if (array != null) {
            IDataModelEntity[] iDataModelEntityArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IDataModelEntity e = iDataModelEntityArray[n2];
                if (e.getClass().getSimpleName().equals(simpleName)) {
                    return e;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IDataModelAttribute findAttribute(IDataModelAttribute[] array, String simpleName, Map<String, String> metaData) {
        IDataModelAttribute secondaryMatch = null;
        if (array != null) {
            IDataModelAttribute[] iDataModelAttributeArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IDataModelAttribute a = iDataModelAttributeArray[n2];
                if (a.getClass().getSimpleName().equals(simpleName)) {
                    secondaryMatch = a;
                    if (CompareUtility.equals(a.getMetaDataOfAttribute(), metaData)) {
                        return a;
                    }
                }
                ++n2;
            }
        }
        return secondaryMatch;
    }

    public static Map<String, String> importMetaData(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        String[] stringArray = PAT_SEMI_COLON.split(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            Matcher m = PAT_NVPAIR.matcher(e);
            if (m.matches()) {
                map.put(m.group(1), m.group(2));
            }
            ++n2;
        }
        return map.size() > 0 ? map : null;
    }

    public static String exportMetaData(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(16);
        for (Map.Entry<String, String> e : map.entrySet()) {
            buf.append(";");
            buf.append(e.getKey());
            buf.append('=');
            if (e.getValue() == null) continue;
            buf.append(e.getValue());
        }
        return buf.toString();
    }
}

