/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.bookmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;

public class Bookmark
implements Serializable,
Cloneable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Bookmark.class);
    private static final long serialVersionUID = 1L;
    public static final int USER_BOOKMARK = 1;
    public static final int GLOBAL_BOOKMARK = 2;
    public static final String SPOOL_FOLDER_NAME = "[SPOOL]";
    public static final String INBOX_FOLDER_NAME = "[INBOX]";
    private int m_kind;
    private String m_title;
    private String m_text;
    private String m_keyStroke;
    private String m_outlineClassName;
    private List<AbstractPageState> m_path;
    private String m_iconId;
    private transient byte[] m_serializedData;

    public Bookmark() {
    }

    public Bookmark(Bookmark bm) {
        this.importData(bm);
    }

    private void importData(Bookmark bm) {
        this.m_kind = bm.m_kind;
        this.m_title = bm.m_title;
        this.m_text = bm.m_text;
        this.m_iconId = bm.m_iconId;
        this.m_keyStroke = bm.m_keyStroke;
        this.m_outlineClassName = bm.m_outlineClassName;
        if (bm.m_path != null) {
            this.m_path = new ArrayList<AbstractPageState>();
            for (AbstractPageState state : bm.m_path) {
                this.m_path.add((AbstractPageState)state.clone());
            }
        }
        this.m_serializedData = null;
    }

    public String getIconId() {
        return this.m_iconId;
    }

    public void setIconId(String iconid) {
        this.m_iconId = iconid;
        this.m_serializedData = null;
    }

    public int getKind() {
        return this.m_kind;
    }

    public void setKind(int kind) {
        switch (kind) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid kind: " + kind);
            }
        }
        this.m_kind = kind;
        this.m_serializedData = null;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String s) {
        this.m_title = s;
        this.m_serializedData = null;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        this.m_text = s;
        this.m_serializedData = null;
    }

    public String getKeyStroke() {
        return this.m_keyStroke;
    }

    public void setKeyStroke(String s) {
        this.m_keyStroke = s;
        this.m_serializedData = null;
    }

    public String getOutlineClassName() {
        return this.m_outlineClassName;
    }

    public void setOutlineClassName(String s) {
        this.m_outlineClassName = s;
        this.m_serializedData = null;
    }

    public List<AbstractPageState> getPath() {
        if (this.m_path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_path);
    }

    public void addPathElement(AbstractPageState state) {
        if (this.m_path == null) {
            this.m_path = new ArrayList<AbstractPageState>();
        }
        this.m_path.add(state);
        this.m_serializedData = null;
    }

    public byte[] getSerializedData() throws ProcessingException {
        if (this.m_serializedData == null) {
            ObjectOutputStream oout = null;
            try {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    oout = new ObjectOutputStream(bout);
                    oout.writeObject(this);
                    oout.close();
                    oout = null;
                    this.m_serializedData = bout.toByteArray();
                }
                catch (IOException e) {
                    throw new ProcessingException("title: " + this.getTitle(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (oout != null) {
                    try {
                        oout.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.m_serializedData;
    }

    public void setSerializedData(byte[] data) throws ProcessingException {
        ObjectInputStream oin = null;
        try {
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                oin = new ObjectInputStream(bin);
                Bookmark bm = (Bookmark)oin.readObject();
                this.importData(bm);
            }
            catch (IOException e) {
                throw new ProcessingException("title: " + this.getTitle(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ProcessingException("title: " + this.getTitle(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (oin != null) {
            try {
                oin.close();
            }
            catch (Throwable throwable) {}
        }
        this.m_serializedData = data;
    }

    public Object clone() {
        return new Bookmark(this);
    }

    private long getCRC() {
        CRC32 crc = new CRC32();
        try {
            byte[] a = this.getSerializedData();
            if (a != null) {
                crc.update(a);
            }
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
        return crc.getValue();
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Bookmark) {
            Bookmark other = (Bookmark)o;
            return this.getCRC() == other.getCRC();
        }
        return false;
    }

    public String toString() {
        return "Bookmark[title=" + this.getTitle() + "]";
    }
}

