/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.rt.shared.services.common.calendar.AbstractCalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarAppointment;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;

public class CalendarAppointment
extends AbstractCalendarItem
implements ICalendarAppointment,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long m_personId;
    private Date m_start;
    private Date m_end;
    private boolean m_fullDay;
    private String m_location;
    private int m_busyStatus;
    private HashSet<String> m_recipientEmail = new HashSet();
    private Serializable m_externalKey;

    public CalendarAppointment() {
    }

    public CalendarAppointment(long id, Long personId, Date startDate, Date endDate, boolean fullDay, String subject, String body, String color) {
        this.setId(id);
        this.setPersonId(personId);
        this.setStart(startDate);
        this.setEnd(endDate);
        this.setFullDay(fullDay);
        this.setSubject(subject);
        this.setBody(body);
        this.setColor(color);
    }

    public CalendarAppointment(Object[] data) {
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                if (data[i] != null) {
                    switch (i) {
                        case 0: {
                            this.setId(((Number)data[i]).longValue());
                            break;
                        }
                        case 1: {
                            this.setPersonId(((Number)data[i]).longValue());
                            break;
                        }
                        case 2: {
                            this.setStart((Date)data[i]);
                            break;
                        }
                        case 3: {
                            this.setEnd((Date)data[i]);
                            break;
                        }
                        case 4: {
                            this.setFullDay((Boolean)TypeCastUtility.castValue((Object)data[i], Boolean.class));
                            break;
                        }
                        case 5: {
                            this.setSubject((String)data[i]);
                            break;
                        }
                        case 6: {
                            this.setBody((String)data[i]);
                            break;
                        }
                        case 7: {
                            this.setColor((String)data[i]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isIntersecting(Date minDate, Date maxDate) {
        return DateUtility.intersects((Date)this.m_start, (Date)this.m_end, (Date)minDate, (Date)maxDate);
    }

    @Override
    public Long getPersonId() {
        return this.m_personId;
    }

    @Override
    public void setPersonId(Long n) {
        this.m_personId = n;
    }

    @Override
    public Date getStart() {
        return this.m_start;
    }

    @Override
    public void setStart(Date a) {
        this.m_start = a;
    }

    @Override
    public Date getEnd() {
        return this.m_end;
    }

    @Override
    public void setEnd(Date a) {
        this.m_end = a;
    }

    @Override
    public boolean isFullDay() {
        return this.m_fullDay;
    }

    @Override
    public void setFullDay(boolean a) {
        this.m_fullDay = a;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public void setLocation(String a) {
        this.m_location = a;
    }

    @Override
    public int getBusyStatus() {
        return this.m_busyStatus;
    }

    @Override
    public void setBusyStatus(int a) {
        this.m_busyStatus = a;
    }

    @Override
    public String[] getRecipientEmail() {
        return this.m_recipientEmail.toArray(new String[this.m_recipientEmail.size()]);
    }

    public void addRecipientEmail(String recipientEmail) {
        this.m_recipientEmail.add(recipientEmail);
    }

    @Override
    public void removeRecipientEmail(String recipientEmail) {
        this.m_recipientEmail.remove(recipientEmail);
    }

    @Override
    public void removeAllRecipientEmail() {
        this.m_recipientEmail.clear();
    }

    @Override
    public ICalendarItem copy() {
        CalendarAppointment a = (CalendarAppointment)super.copy();
        a.m_personId = this.m_personId;
        a.m_start = this.m_start;
        a.m_end = this.m_end;
        a.m_fullDay = this.m_fullDay;
        a.m_location = this.m_location;
        a.m_busyStatus = this.m_busyStatus;
        return a;
    }

    @Override
    protected void dumpState(Map<String, Object> attributes) {
        super.dumpState(attributes);
        if (this.m_start != null) {
            attributes.put("start", CalendarAppointment.getDumpDateFormat().format(this.m_start));
        }
        if (this.m_end != null) {
            attributes.put("end", CalendarAppointment.getDumpDateFormat().format(this.m_end));
        }
        attributes.put("fullDay", this.m_fullDay);
        attributes.put("location", this.m_location);
        attributes.put("busyStatus", this.m_busyStatus);
        attributes.put("recipientEmail", this.m_recipientEmail);
    }

    @Override
    public Serializable getExternalKey() {
        return this.m_externalKey;
    }

    @Override
    public void setExternalKey(Serializable externalKey) {
        this.m_externalKey = externalKey;
    }
}

