/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.shared.services.common.calendar.HolidayItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;

@Priority(value=-1.0f)
public class HolidayCalendarItemParser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HolidayCalendarItemParser.class);
    private static final String HOLIDAYS = "holidays";
    private static final String HOLIDAY = "holiday";
    private static final String DATE = "date";
    private static final String WEEKDAY = "weekday";
    private static final String INSTANCE = "instance";
    private static final String COLOR = "color";
    private static final String TEXT = "text";
    private static final String TOOLTIP = "tooltip";
    private static final String ID = "id";
    private static final String RELATIVE_TO = "relativeTo";
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private SimpleXmlElement m_xml = new SimpleXmlElement();

    public HolidayCalendarItemParser(URL xmlResource) throws ProcessingException {
        if (xmlResource != null) {
            try {
                this.m_xml.parseStream(xmlResource.openStream());
            }
            catch (Throwable t) {
                throw new ProcessingException("loading " + xmlResource, t);
            }
        }
    }

    public HolidayCalendarItemParser(InputStream xmlResource, String displayFileName) throws ProcessingException {
        if (xmlResource != null) {
            try {
                this.m_xml.parseStream(xmlResource);
            }
            catch (Throwable t) {
                throw new ProcessingException("loading " + displayFileName, t);
            }
        }
    }

    public ICalendarItem[] getItems(Locale loc, Date minDate, Date maxDate) throws ProcessingException {
        ArrayList<HolidayItem> itemList = new ArrayList<HolidayItem>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(minDate);
        int startYear = cal.get(1);
        cal.setTime(maxDate);
        int endYear = cal.get(1);
        int year = startYear;
        while (year <= endYear) {
            this.addHolidays(loc, year, itemList);
            ++year;
        }
        Iterator iter = itemList.iterator();
        while (iter.hasNext()) {
            HolidayItem item = (HolidayItem)iter.next();
            if (!minDate.after(item.getStart()) && !maxDate.before(item.getStart())) continue;
            iter.remove();
        }
        return itemList.toArray(new HolidayItem[itemList.size()]);
    }

    private void addHolidays(Locale loc, int year, Collection<HolidayItem> newList) {
        HashMap<String, HolidayItem> holidayMap = new HashMap<String, HolidayItem>();
        String[] locPatterns = new String[]{String.valueOf(loc.getCountry()) + "_" + loc.getLanguage() + "_" + loc.getVariant(), String.valueOf(loc.getCountry()) + "_" + loc.getLanguage(), loc.getLanguage()};
        long index = 1L;
        for (SimpleXmlElement holidayElem : this.m_xml.getChildren(HOLIDAY)) {
            try {
                Date d = this.evaluateHolidayDate(holidayElem, holidayMap, year);
                if (d == null) continue;
                String text = this.getAttributeByLocale(holidayElem, locPatterns, TEXT);
                String tooltip = this.getAttributeByLocale(holidayElem, locPatterns, TOOLTIP);
                String itemId = holidayElem.getStringAttribute(ID, null);
                if (itemId == null) {
                    itemId = "" + index;
                }
                HolidayItem item = new HolidayItem();
                item.setStart(d);
                item.setSubject(text);
                item.setBody(tooltip);
                item.setColor(holidayElem.getStringAttribute(COLOR));
                ++index;
                holidayMap.put(itemId, item);
            }
            catch (Exception e) {
                LOG.warn("item " + holidayElem.toString(), (Throwable)e);
            }
        }
        newList.addAll(holidayMap.values());
    }

    private Date evaluateHolidayDate(SimpleXmlElement holidayElem, Map<String, HolidayItem> holidayMap, int year) throws ParseException {
        HolidayItem relItem;
        String datePattern = holidayElem.getStringAttribute(DATE);
        String weekdayPattern = holidayElem.getStringAttribute(WEEKDAY);
        String instancePattern = holidayElem.getStringAttribute(INSTANCE);
        String relativeToId = holidayElem.getStringAttribute(RELATIVE_TO, null);
        int weekday = -1;
        if (weekdayPattern != null) {
            if (weekdayPattern.equalsIgnoreCase("MONDAY")) {
                weekday = 2;
            } else if (weekdayPattern.equalsIgnoreCase("TUESDAY")) {
                weekday = 3;
            } else if (weekdayPattern.equalsIgnoreCase("WEDNESDAY")) {
                weekday = 4;
            } else if (weekdayPattern.equalsIgnoreCase("THURSDAY")) {
                weekday = 5;
            } else if (weekdayPattern.equalsIgnoreCase("FRIDAY")) {
                weekday = 6;
            } else if (weekdayPattern.equalsIgnoreCase("SATURDAY")) {
                weekday = 7;
            } else if (weekdayPattern.equalsIgnoreCase("SUNDAY")) {
                weekday = 1;
            }
        }
        int instance = 0;
        if (instancePattern != null) {
            instance = instancePattern.equalsIgnoreCase("FIRST") ? 1 : (instancePattern.equalsIgnoreCase("LAST") ? -1 : Integer.parseInt(instancePattern));
        }
        Date startDate = null;
        if (relativeToId != null && (relItem = holidayMap.get(relativeToId)) != null) {
            startDate = relItem.getStart();
        }
        if (startDate == null) {
            if (datePattern == null) {
                return null;
            }
            if (datePattern.endsWith("0000")) {
                startDate = this.m_dateFormat.parse(String.valueOf(datePattern.substring(0, datePattern.length() - 4)) + year);
            } else if (datePattern.endsWith("" + year)) {
                startDate = this.m_dateFormat.parse(datePattern);
            } else {
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (weekday >= 0 && instance != 0) {
            if (instance > 0) {
                int n = instance;
                while (n > 0) {
                    if (cal.get(7) != weekday || --n != 0) {
                        cal.add(5, 1);
                        continue;
                    }
                    break;
                }
            } else {
                int n = -instance;
                while (n > 0) {
                    if (cal.get(7) != weekday || --n != 0) {
                        cal.add(5, -1);
                        continue;
                    }
                    break;
                }
            }
        }
        startDate = cal.getTime();
        return startDate;
    }

    private String getAttributeByLocale(SimpleXmlElement e, String[] locPatterns, String attributeNamePrefix) {
        String s = null;
        int i = 0;
        while (i < locPatterns.length) {
            s = e.getStringAttribute(String.valueOf(attributeNamePrefix) + "_" + locPatterns[i], null);
            if (s != null) break;
            ++i;
        }
        return s;
    }
}

