/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.Serializable;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class CodeRow
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Object m_key;
    private String m_text;
    private String m_iconId;
    private String m_tooltip;
    private String m_backgroundColor;
    private String m_foregroundColor;
    private FontSpec m_font;
    private boolean m_active = true;
    private boolean m_enabled = true;
    private transient Object m_parentKey;
    private String m_extKey;
    private Number m_value;
    private long m_partitionId;

    public CodeRow(Object[] cells) {
        this(cells, cells.length - 1);
    }

    public CodeRow(Object[] cells, int maxColumnIndex) {
        if (cells != null) {
            int index = 0;
            while (index < cells.length && index <= maxColumnIndex) {
                if (cells[index] != null) {
                    switch (index) {
                        case 0: {
                            this.m_key = cells[index];
                            break;
                        }
                        case 1: {
                            this.m_text = cells[index].toString();
                            break;
                        }
                        case 2: {
                            this.m_iconId = cells[index].toString();
                            break;
                        }
                        case 3: {
                            this.m_tooltip = cells[index].toString();
                            break;
                        }
                        case 4: {
                            this.m_backgroundColor = cells[index].toString();
                            break;
                        }
                        case 5: {
                            this.m_foregroundColor = cells[index].toString();
                            break;
                        }
                        case 6: {
                            this.m_font = FontSpec.parse(cells[index].toString());
                            break;
                        }
                        case 7: {
                            Boolean b = (Boolean)TypeCastUtility.castValue((Object)cells[index], Boolean.class);
                            this.m_active = b;
                            break;
                        }
                        case 8: {
                            Object o = cells[index];
                            if (o instanceof Number && ((Number)o).longValue() == 0L) {
                                o = null;
                            }
                            this.m_parentKey = o;
                            break;
                        }
                        case 9: {
                            this.m_extKey = cells[index].toString();
                            break;
                        }
                        case 10: {
                            Object o = cells[index];
                            if (!(o instanceof Number)) break;
                            this.m_value = (Number)o;
                            break;
                        }
                        case 11: {
                            Boolean b = (Boolean)TypeCastUtility.castValue((Object)cells[index], Boolean.class);
                            this.m_enabled = b;
                            break;
                        }
                        case 12: {
                            this.m_partitionId = ((Number)cells[index]).longValue();
                        }
                    }
                }
                ++index;
            }
        }
    }

    public CodeRow(CodeRow t) {
        this(t.getKey(), t.getText(), t.getIconId(), t.getTooltip(), t.getBackgroundColor(), t.getForegroundColor(), t.getFont(), t.isEnabled(), t.getParentKey(), t.isActive(), t.getExtKey(), t.getValue(), t.getPartitionId());
    }

    public CodeRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled, Object parentKey, boolean active, String extKey, Number value, long partitionId) {
        this.m_key = key;
        this.m_text = text;
        this.m_iconId = iconId;
        this.m_tooltip = tooltip;
        this.m_backgroundColor = backgroundColor;
        this.m_foregroundColor = foregroundColor;
        this.m_font = font;
        this.m_active = active;
        this.m_enabled = enabled;
        this.m_parentKey = parentKey;
        this.m_extKey = extKey;
        this.m_value = value;
        this.m_partitionId = partitionId;
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getIconId() {
        return this.m_iconId;
    }

    public void setIconId(String iconId) {
        this.m_iconId = iconId;
    }

    public String getTooltip() {
        return this.m_tooltip;
    }

    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
    }

    public String getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.m_foregroundColor = foregroundColor;
    }

    public String getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public FontSpec getFont() {
        return this.m_font;
    }

    public void setFont(FontSpec font) {
        this.m_font = font;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean b) {
        this.m_active = b;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean b) {
        this.m_enabled = b;
    }

    public Object getParentKey() {
        return this.m_parentKey;
    }

    public void setParentKey(Object parentKey) {
        this.m_parentKey = parentKey;
    }

    public String getExtKey() {
        return this.m_extKey;
    }

    public void setExtKey(String extKey) {
        this.m_extKey = extKey;
    }

    public Number getValue() {
        return this.m_value;
    }

    public void setValue(Number value) {
        this.m_value = value;
    }

    public long getPartitionId() {
        return this.m_partitionId;
    }

    public void setPartitionId(long partitionId) {
        this.m_partitionId = partitionId;
    }
}

