/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.scout.rt.shared.services.common.clientnotification.AbstractClientNotification;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;

public class CodeTypeChangedNotification
extends AbstractClientNotification {
    private static final long serialVersionUID = 1L;
    private Class<? extends Serializable>[] m_codeTypes;

    public CodeTypeChangedNotification(Class<? extends Serializable>[] codeTypes) {
        this.m_codeTypes = codeTypes;
    }

    @Override
    public boolean coalesce(IClientNotification existingNotification) {
        CodeTypeChangedNotification n = (CodeTypeChangedNotification)existingNotification;
        HashSet<Class<? extends Serializable>> set = new HashSet<Class<? extends Serializable>>();
        set.addAll(Arrays.asList(this.m_codeTypes));
        set.addAll(Arrays.asList(n.m_codeTypes));
        this.m_codeTypes = set.toArray(new Class[set.size()]);
        if (this.getOriginNode() != existingNotification.getOriginNode()) {
            this.setOriginNode(0);
        }
        return true;
    }

    public Class<? extends Serializable>[] getCodeTypes() {
        return this.m_codeTypes;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName());
        b.append("[");
        int i = 0;
        while (i < this.m_codeTypes.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.m_codeTypes[i].getSimpleName());
            ++i;
        }
        b.append("]");
        return b.toString();
    }
}

