/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.jdbc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.NVPair;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.jdbc.ILegacySqlQueryService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.service.SERVICES;

public class LegacySearchFilter
extends SearchFilter
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LegacySearchFilter.class);
    private int m_sBindSeq;
    private HashMap<String, Object> m_binds = new HashMap();
    private StringBuffer m_where = new StringBuffer("");

    public Map<String, Object> getBindMap() {
        return this.m_binds;
    }

    public void addBind(String name, Object value) {
        if (name != null) {
            this.m_binds.put(name, value);
        }
    }

    public void addSpecialWhereToken(Object o) throws ProcessingException {
        WhereToken tok = ((ILegacySqlQueryService)SERVICES.getService(ILegacySqlQueryService.class)).resolveSpecialConstraint(o);
        if (tok.getBinds() != null) {
            this.m_binds.putAll(tok.getBinds());
        }
        this.addWhereToken(tok.getText(), tok.getS());
    }

    public void setWhere(String sql, NVPair ... customBinds) {
        this.clear();
        this.addWhere(sql, customBinds);
    }

    public void setWhereToken(String sql) {
        this.clear();
        this.addWhereToken(sql);
    }

    public void setWhereToken(String sql, Object valueForS) {
        this.clear();
        this.addWhereToken(sql, valueForS);
    }

    public void addWhereToken(String sql) {
        if (sql != null) {
            this.m_where.append(" AND ");
            this.addWhere(sql, new NVPair[0]);
        }
    }

    public String getNextGenericBindName() {
        String bindName = "__" + this.m_sBindSeq;
        ++this.m_sBindSeq;
        return bindName;
    }

    public void addWhereToken(String sql, Object valueForS) {
        if (sql != null) {
            String bindName = "__" + this.m_sBindSeq;
            ++this.m_sBindSeq;
            sql = sql.replaceAll(":S([^a-zA-Z0-9_])", ":" + bindName + "$1");
            sql = sql.replaceAll(":S$", ":" + bindName);
            sql = sql.replaceAll("#S#", "#" + bindName + "#");
            this.m_where.append(" AND ");
            this.addWhere(sql, new NVPair(bindName, valueForS));
        }
    }

    public void addWhere(String sql, NVPair ... customBinds) {
        if (sql != null) {
            this.m_where.append(sql);
            NVPair[] nVPairArray = customBinds;
            int n = customBinds.length;
            int n2 = 0;
            while (n2 < n) {
                NVPair p = nVPairArray[n2];
                this.m_binds.put(p.getName(), p.getValue());
                ++n2;
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.m_where.setLength(0);
        this.m_binds.clear();
    }

    public String getWhere() {
        return this.m_where.toString();
    }

    public String getWherePlain() throws ProcessingException {
        return ((ILegacySqlQueryService)SERVICES.getService(ILegacySqlQueryService.class)).createPlainText(this.getWhere(), this.getBindMap());
    }

    @Override
    public Object clone() {
        LegacySearchFilter f = (LegacySearchFilter)super.clone();
        f.m_sBindSeq = this.m_sBindSeq;
        f.m_binds = new HashMap<String, Object>(this.m_binds);
        f.m_where = new StringBuffer(this.m_where);
        return f;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SearchFilter[");
        if (this.m_where != null && this.m_where.length() > 0) {
            buf.append(this.m_where);
            buf.append(" ");
        }
        if (this.m_binds != null && this.m_binds.size() > 0) {
            buf.append(this.m_binds);
        }
        buf.append("]");
        return buf.toString();
    }

    public static class ComposerAttributeRef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int m_op;
        private String m_attribute;
        private String m_bindName;
        private Object m_value;

        public ComposerAttributeRef(int op, String attribute, String bindName, Object value) {
            this.m_op = op;
            this.m_attribute = attribute;
            this.m_bindName = bindName;
            this.m_value = value;
        }

        public int getOp() {
            return this.m_op;
        }

        public String getAttribute() {
            return this.m_attribute;
        }

        public String getBindName() {
            return this.m_bindName;
        }

        public Object getValue() {
            return this.m_value;
        }
    }

    public static class ComposerConstraint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_term;
        private Map<String, ComposerAttributeRef> m_attributeRefMap;

        public ComposerConstraint(String term, Map<String, ComposerAttributeRef> attributeRefMap) {
            this.m_term = term;
            this.m_attributeRefMap = attributeRefMap;
        }

        public String getTerm() {
            return this.m_term;
        }

        public Map<String, ComposerAttributeRef> getAttributeRefMap() {
            return this.m_attributeRefMap;
        }
    }

    public static class StringLikeConstraint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_term;
        private String m_value;

        public StringLikeConstraint(String term, String value) {
            this.m_term = term;
            this.m_value = value;
        }

        public String getTerm() {
            return this.m_term;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    public static class WhereToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_text;
        private Object m_s;
        private Map<String, Object> m_binds;

        public WhereToken(String text, Object s, Map<String, Object> binds) {
            this.m_text = text;
            this.m_s = s;
            this.m_binds = binds;
        }

        public String getText() {
            return this.m_text;
        }

        public Object getS() {
            return this.m_s;
        }

        public Map<String, Object> getBinds() {
            return this.m_binds;
        }
    }
}

