/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public class TokenBasedSearchFilter
extends SearchFilter
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TokenBasedSearchFilter.class);
    private ArrayList<ValueToken> m_valueTokens = new ArrayList(1);
    private ArrayList<WildcardStringToken> m_wildcardStringTokens = new ArrayList(1);
    private ArrayList<AndNodeToken> m_treeTokens = new ArrayList(1);

    public void addToken(Integer tokenId, Object ... values) {
        if (tokenId == null) {
            return;
        }
        this.m_valueTokens.add(new ValueToken(tokenId, values));
    }

    public void addWildcardStringToken(Integer tokenId, String value) {
        if (tokenId == null) {
            return;
        }
        this.m_wildcardStringTokens.add(new WildcardStringToken(tokenId, value));
    }

    public void addTreeToken(AndNodeToken root) {
        if (root == null || root.getChildren().size() == 0) {
            return;
        }
        this.m_treeTokens.add(root);
    }

    public List<ValueToken> getValueTokens() {
        return Collections.unmodifiableList(this.m_valueTokens);
    }

    public List<WildcardStringToken> getWildcardStringTokens() {
        return Collections.unmodifiableList(this.m_wildcardStringTokens);
    }

    public List<AndNodeToken> getTreeTokens() {
        return Collections.unmodifiableList(this.m_treeTokens);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_valueTokens.clear();
        this.m_wildcardStringTokens.clear();
        this.m_treeTokens.clear();
    }

    @Override
    public Object clone() {
        TokenBasedSearchFilter f = (TokenBasedSearchFilter)super.clone();
        f.m_valueTokens = new ArrayList<ValueToken>(this.m_valueTokens);
        f.m_wildcardStringTokens = new ArrayList<WildcardStringToken>(this.m_wildcardStringTokens);
        f.m_treeTokens = new ArrayList<AndNodeToken>(this.m_treeTokens);
        return f;
    }

    public static class AndNodeToken
    extends TreeNodeToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static class AttributeNodeToken
    extends TreeNodeToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int m_tokenId;
        private final int m_op;
        private final Object[] m_values;

        public AttributeNodeToken(int tokenId, int op, Object[] values) {
            this.m_tokenId = tokenId;
            this.m_op = op;
            this.m_values = values;
        }

        public int getTokenId() {
            return this.m_tokenId;
        }

        public int getOp() {
            return this.m_op;
        }

        public Object[] getValues() {
            return this.m_values;
        }
    }

    public static class EntityNodeToken
    extends TreeNodeToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int m_tokenId;

        public EntityNodeToken(int tokenId) {
            this.m_tokenId = tokenId;
        }

        public int getTokenId() {
            return this.m_tokenId;
        }
    }

    public static class OrNodeToken
    extends TreeNodeToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static class TreeNodeToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<TreeNodeToken> m_children = new ArrayList<TreeNodeToken>(1);
        private boolean m_negative;

        public void addChild(TreeNodeToken child) {
            if (child != null) {
                this.m_children.add(child);
            }
        }

        public List<TreeNodeToken> getChildren() {
            return Collections.unmodifiableList(this.m_children);
        }

        public boolean isNegative() {
            return this.m_negative;
        }

        public void setNegative(boolean negative) {
            this.m_negative = negative;
        }
    }

    public static class ValueToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int m_tokenId;
        private final Object[] m_values;

        public ValueToken(int tokenId, Object[] values) {
            this.m_tokenId = tokenId;
            this.m_values = values;
        }

        public int getTokenId() {
            return this.m_tokenId;
        }

        public Object[] getValues() {
            return this.m_values;
        }
    }

    public static class WildcardStringToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int m_tokenId;
        private final String m_value;

        public WildcardStringToken(int tokenId, String value) {
            this.m_tokenId = tokenId;
            this.m_value = value;
        }

        public int getTokenId() {
            return this.m_tokenId;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

