/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.test;

import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.shared.services.common.test.ITest;
import org.eclipse.scout.rt.shared.services.common.test.ITestContext;
import org.eclipse.scout.rt.shared.services.common.test.TestStatus;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractTest
extends AbstractService
implements ITest {
    private ITestContext m_ctx;
    private String m_product;
    private String m_title;
    private String m_subTitle;
    private long m_startTime = -1L;
    private long m_endTime = -1L;

    public AbstractTest() {
        this.initConfig();
    }

    @Order(value=10.0)
    @ConfigProperty(value="STRING")
    @ConfigPropertyValue(value="null")
    protected String getConfiguredProduct() {
        return null;
    }

    @Order(value=10.0)
    @ConfigProperty(value="STRING")
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @Order(value=10.0)
    @ConfigProperty(value="STRING")
    @ConfigPropertyValue(value="null")
    protected String getConfiguredSubTitle() {
        return null;
    }

    protected void initConfig() {
        this.setProduct(this.getConfiguredProduct());
        this.setTitle(this.getConfiguredTitle());
        this.setSubTitle(this.getConfiguredSubTitle());
        if (this.getTitle() == null || this.getTitle().length() == 0) {
            String s = this.getClass().getSimpleName();
            s = s.replaceAll("UnitTest$", "");
            s = s.replaceAll("Test$", "");
            this.setTitle(s);
        }
    }

    @Override
    public void setTestContext(ITestContext ctx) {
        this.m_ctx = ctx;
    }

    public ITestContext getTestContext() {
        return this.m_ctx;
    }

    protected final void startTiming() {
        this.m_startTime = System.currentTimeMillis();
    }

    protected final long stopTiming() {
        this.m_endTime = System.currentTimeMillis();
        return this.getLastTiming();
    }

    protected final long getLastTiming() {
        if (this.m_startTime > 0L && this.m_endTime >= this.m_startTime) {
            return this.m_endTime - this.m_startTime;
        }
        return -1L;
    }

    protected TestStatus createStatus() {
        TestStatus s = new TestStatus(this.getProduct(), this.getTitle(), this.getSubTitle());
        return s;
    }

    protected final void addOkStatus() {
        this.addOkStatus(null);
    }

    protected final void addOkStatus(String message) {
        TestStatus s = this.createStatus();
        s.setSeverity(1);
        s.setDuration(this.getLastTiming());
        if (message != null) {
            s.setMessage(message);
        }
        this.addStatus(s);
    }

    protected final void addWarningStatus(String message) {
        this.addWarningStatus(message, null);
    }

    protected final void addWarningStatus(Throwable t) {
        this.addWarningStatus(null, t);
    }

    protected final void addWarningStatus(String message, Throwable t) {
        TestStatus s = this.createStatus();
        s.setSeverity(2);
        s.setDuration(this.getLastTiming());
        if (message != null) {
            s.setMessage(message);
        }
        if (t != null) {
            s.setException(t);
        }
        this.addStatus(s);
    }

    protected final void addErrorStatus(String message) {
        this.addErrorStatus(message, null);
    }

    protected final void addErrorStatus(Throwable t) {
        this.addErrorStatus(null, t);
    }

    protected final void addErrorStatus(String message, Throwable t) {
        TestStatus s = this.createStatus();
        s.setSeverity(4);
        s.setDuration(this.getLastTiming());
        if (message != null) {
            s.setMessage(message);
        }
        if (t != null) {
            s.setException(t);
        }
        this.addStatus(s);
    }

    protected final void addFatalStatus(String message, Throwable t) {
        TestStatus s = this.createStatus();
        s.setSeverity(16);
        s.setDuration(this.getLastTiming());
        if (message != null) {
            s.setMessage(message);
        }
        if (t != null) {
            s.setException(t);
        }
        this.addStatus(s);
    }

    protected final void addStatus(TestStatus status) {
        this.m_ctx.addStatus(status);
    }

    @Override
    public final String getProduct() {
        return this.m_product;
    }

    public final void setProduct(String s) {
        this.m_product = s;
    }

    @Override
    public final String getTitle() {
        return this.m_title;
    }

    public final void setTitle(String s) {
        this.m_title = s;
    }

    @Override
    public final String getSubTitle() {
        return this.m_subTitle;
    }

    public final void setSubTitle(String s) {
        this.m_subTitle = s;
    }

    @Override
    public void setUp() throws Throwable {
    }

    @Override
    public abstract void run() throws Throwable;

    @Override
    public void tearDown() throws Throwable {
    }
}

