/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class AbstractCodeTypeLookupCall
extends LocalLookupCall {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCodeTypeLookupCall.class);
    private static final long serialVersionUID = 1L;
    private String m_bundlePrefix;

    public String getBundlePrefix() {
        return this.m_bundlePrefix;
    }

    public void setBundlePrefix(String bundlePrefix) {
        this.m_bundlePrefix = bundlePrefix;
    }

    @Override
    protected List<LookupRow> execCreateLookupRows() throws ProcessingException {
        ICodeType[] codeTypes = CODES.getAllCodeTypes(this.m_bundlePrefix);
        ArrayList<LookupRow> result = new ArrayList<LookupRow>();
        ICodeType[] iCodeTypeArray = codeTypes;
        int n = codeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeType type = iCodeTypeArray[n2];
            result.add(new LookupRow(type.getId(), type.getText()));
            ++n2;
        }
        return result;
    }

    @Override
    public LookupRow[] getDataByKey() throws ProcessingException {
        ICodeType codeType = CODES.findCodeTypeById(this.getKey());
        if (codeType != null) {
            LookupRow[] result = new LookupRow[]{new LookupRow(codeType.getId(), codeType.getText())};
            return result;
        }
        return null;
    }
}

