/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallVisitor;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class CodeLookupCall
extends LocalLookupCall
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Class<? extends ICodeType> m_codeTypeClass;
    private ICodeLookupCallVisitor m_filter;

    public CodeLookupCall(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CodeLookupCall other = (CodeLookupCall)obj;
        if (this.m_codeTypeClass != other.m_codeTypeClass) {
            return false;
        }
        return this.m_filter == other.m_filter;
    }

    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setFilter(ICodeLookupCallVisitor filter) {
        this.m_filter = filter;
    }

    public ICodeLookupCallVisitor getFilter() {
        return this.m_filter;
    }

    public static LookupRow[] createLookupRowArray(List<? extends ICode> codes) {
        LookupRow[] a = new LookupRow[codes.size()];
        int i = 0;
        while (i < a.length) {
            ICode c = codes.get(i);
            Object parentId = null;
            if (c.getParentCode() != null) {
                parentId = c.getParentCode().getId();
            }
            a[i] = new LookupRow(c.getId(), c.getText(), c.getIconId(), c.getTooltipText(), c.getBackgroundColor(), c.getForegroundColor(), c.getFont(), c.isEnabled(), parentId, c.isActive());
            ++i;
        }
        return a;
    }

    public static Pattern getSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if (!(s = s.toLowerCase()).endsWith("*")) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }

    @Override
    public LookupRow[] getDataByKey() throws ProcessingException {
        ICode c;
        Object key = this.getKey();
        ArrayList<ICode> list = new ArrayList<ICode>(1);
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null && (c = t.getCode(key)) != null) {
            list.add(c);
        }
        return CodeLookupCall.createLookupRowArray(list);
    }

    @Override
    public LookupRow[] getDataByText() throws ProcessingException {
        final Pattern pat = CodeLookupCall.getSearchPattern(this.getText());
        P_AbstractCollectingCodeVisitor v = new P_AbstractCollectingCodeVisitor(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && code.getText() != null && pat.matcher(code.getText().toLowerCase()).matches()) {
                    this.add(code);
                }
                return true;
            }
        };
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
        return CodeLookupCall.createLookupRowArray(v.getCodes());
    }

    @Override
    public LookupRow[] getDataByAll() throws ProcessingException {
        final Pattern pat = CodeLookupCall.getSearchPattern(this.getAll());
        P_AbstractCollectingCodeVisitor v = new P_AbstractCollectingCodeVisitor(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && code.getText() != null && pat.matcher(code.getText().toLowerCase()).matches()) {
                    this.add(code);
                }
                return true;
            }
        };
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
        return CodeLookupCall.createLookupRowArray(v.getCodes());
    }

    @Override
    public LookupRow[] getDataByRec() throws ProcessingException {
        Object recValue = this.getRec();
        if (recValue instanceof Number && ((Number)recValue).longValue() == 0L) {
            recValue = null;
        }
        final Object key = recValue;
        P_AbstractCollectingCodeVisitor v = new P_AbstractCollectingCodeVisitor(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                ICode parentCode = code.getParentCode();
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (parentCode == null && key == null || parentCode != null && parentCode.getId() != null && parentCode.getId().equals(key))) {
                    this.add(code);
                }
                return true;
            }
        };
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
        return CodeLookupCall.createLookupRowArray(v.getCodes());
    }

    private abstract class P_AbstractCollectingCodeVisitor
    implements ICodeVisitor {
        private ArrayList<ICode> m_list = new ArrayList();

        public void add(ICode code) {
            this.m_list.add(code);
        }

        public ICode getFirstCode() {
            if (this.m_list.size() > 0) {
                return this.m_list.get(0);
            }
            return null;
        }

        public List<ICode> getCodes() {
            return this.m_list;
        }
    }
}

