/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class LocalLookupCall
extends LookupCall {
    private static final long serialVersionUID = 0L;

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected List<LookupRow> execCreateLookupRows() throws ProcessingException {
        return null;
    }

    public static Pattern createLowerCaseSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.toLowerCase()).indexOf(42) < 0) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }

    @Override
    protected final Class<? extends ILookupService> getConfiguredService() {
        return null;
    }

    @Override
    public LookupRow[] getDataByKey() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Object key = this.getKey();
        if (key != null) {
            for (LookupRow row : this.execCreateLookupRows()) {
                if (!key.equals(row.getKey())) continue;
                list.add(row);
            }
        }
        return list.toArray(new LookupRow[0]);
    }

    @Override
    public LookupRow[] getDataByText() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = LocalLookupCall.createLowerCaseSearchPattern(this.getText());
        for (LookupRow row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list.toArray(new LookupRow[0]);
    }

    @Override
    public LookupRow[] getDataByAll() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = LocalLookupCall.createLowerCaseSearchPattern(this.getAll());
        for (LookupRow row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list.toArray(new LookupRow[0]);
    }

    @Override
    public LookupRow[] getDataByRec() throws ProcessingException {
        ArrayList list = new ArrayList();
        return list.toArray(new LookupRow[0]);
    }
}

