/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.io.Serializable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class LookupCall
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private Object m_key;
    private String m_text;
    private String m_all;
    private Object m_rec;
    private Object m_master;
    private TriState m_active;
    private int m_maxRowCount;
    private transient ILookupService m_serviceCached = this.createLookupService();

    public LookupCall() {
        this.m_active = TriState.UNDEFINED;
    }

    @ConfigProperty(value="LOOKUP_SERVICE")
    @ConfigPropertyValue(value="null")
    @Order(value=10.0)
    protected Class<? extends ILookupService> getConfiguredService() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @ConfigPropertyValue(value="false")
    @Order(value=20.0)
    protected boolean getConfiguredMasterRequired() {
        return false;
    }

    public ILookupService getLookupService() {
        if (this.m_serviceCached == null) {
            this.m_serviceCached = this.createLookupService();
        }
        return this.m_serviceCached;
    }

    private ILookupService createLookupService() {
        ILookupService s = null;
        if (this.getConfiguredService() != null && (s = (ILookupService)SERVICES.getService(this.getConfiguredService())) == null) {
            throw new IllegalArgumentException("service " + this.getConfiguredService().getName() + " is either not registered in the clientProxy extension in the plugin.xml or this constructor is called outside the model thread");
        }
        return s;
    }

    public Object getKey() {
        return this.m_key;
    }

    public long getKeyAsLong() {
        Object o = this.getKey();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        this.m_text = s;
    }

    public String getAll() {
        return this.m_all;
    }

    public void setAll(String s) {
        this.m_all = s;
    }

    public Object getRec() {
        return this.m_rec;
    }

    public long getRecAsLong() {
        Object o = this.getRec();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    public void setRec(Object parent) {
        this.m_rec = parent;
    }

    public TriState getActive() {
        return this.m_active;
    }

    public void setActive(TriState s) {
        if (s == null) {
            s = TriState.UNDEFINED;
        }
        this.m_active = s;
    }

    public Object getMaster() {
        return this.m_master;
    }

    public long getMasterAsLong() {
        Object o = this.getMaster();
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    public void setMaster(Object master) {
        this.m_master = master;
    }

    public int getMaxRowCount() {
        return this.m_maxRowCount;
    }

    public void setMaxRowCount(int n) {
        this.m_maxRowCount = n;
    }

    public Object clone() {
        LookupCall c = null;
        try {
            c = (LookupCall)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return c;
    }

    public int hashCode() {
        return (this.m_key != null ? this.m_key.hashCode() : 0) ^ (this.m_text != null ? this.m_text.hashCode() : 0) ^ (this.m_all != null ? this.m_all.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LookupCall other = (LookupCall)obj;
        if (this.m_serviceCached != other.m_serviceCached) {
            return false;
        }
        if (!(this.m_key == other.m_key || this.m_key != null && this.m_key.equals(other.m_key))) {
            return false;
        }
        if (!(this.m_text == other.m_text || this.m_text != null && this.m_text.equals(other.m_text))) {
            return false;
        }
        if (!(this.m_all == other.m_all || this.m_all != null && this.m_all.equals(other.m_all))) {
            return false;
        }
        if (!(this.m_rec == other.m_rec || this.m_rec != null && this.m_rec.equals(other.m_rec))) {
            return false;
        }
        if (!(this.m_master == other.m_master || this.m_master != null && this.m_master.equals(other.m_master))) {
            return false;
        }
        if (!(this.m_active == other.m_active || this.m_active != null && this.m_active.equals((Object)other.m_active))) {
            return false;
        }
        return this.m_maxRowCount == other.m_maxRowCount;
    }

    public LookupRow[] getDataByKey() throws ProcessingException {
        if (this.getLookupService() != null) {
            return this.getLookupService().getDataByKey(this);
        }
        return new LookupRow[0];
    }

    public JobEx getDataByKeyInBackground(final ILookupCallFetcher caller) {
        if (!(this instanceof LocalLookupCall)) {
            JobEx job = new JobEx(String.valueOf(this.getClass().getSimpleName()) + ".getDataByKeyInBackground"){

                protected IStatus run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            LookupRow[] rows = LookupCall.this.getDataByKey();
                            if (!1.isCurrentJobCanceled()) {
                                caller.dataFetched(rows, null);
                            }
                        }
                        catch (ProcessingException e) {
                            if (1.isCurrentJobCanceled()) break block3;
                            caller.dataFetched(null, e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return job;
        }
        try {
            caller.dataFetched(this.getDataByKey(), null);
        }
        catch (ProcessingException e) {
            caller.dataFetched(null, e);
        }
        return null;
    }

    public LookupRow[] getDataByText() throws ProcessingException {
        boolean masterValid;
        boolean bl = masterValid = !this.getConfiguredMasterRequired() || this.getMaster() != null;
        if (masterValid && this.getLookupService() != null) {
            return this.getLookupService().getDataByText(this);
        }
        return new LookupRow[0];
    }

    public JobEx getDataByTextInBackground(final ILookupCallFetcher caller) {
        if (!(this instanceof LocalLookupCall)) {
            JobEx job = new JobEx(String.valueOf(this.getClass().getSimpleName()) + ".getDataByTextInBackground"){

                protected IStatus run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            LookupRow[] rows = LookupCall.this.getDataByText();
                            if (!2.isCurrentJobCanceled()) {
                                caller.dataFetched(rows, null);
                            }
                        }
                        catch (ProcessingException e) {
                            if (2.isCurrentJobCanceled()) break block3;
                            caller.dataFetched(null, e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return job;
        }
        try {
            caller.dataFetched(this.getDataByText(), null);
        }
        catch (ProcessingException e) {
            caller.dataFetched(null, e);
        }
        return null;
    }

    public LookupRow[] getDataByAll() throws ProcessingException {
        boolean masterValid;
        boolean bl = masterValid = !this.getConfiguredMasterRequired() || this.getMaster() != null;
        if (masterValid && this.getLookupService() != null) {
            return this.getLookupService().getDataByAll(this);
        }
        return new LookupRow[0];
    }

    public JobEx getDataByAllInBackground(final ILookupCallFetcher caller) {
        if (!(this instanceof LocalLookupCall)) {
            JobEx job = new JobEx(String.valueOf(this.getClass().getSimpleName()) + ".getDataByAllInBackground"){

                protected IStatus run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            LookupRow[] rows = LookupCall.this.getDataByAll();
                            if (!3.isCurrentJobCanceled()) {
                                caller.dataFetched(rows, null);
                            }
                        }
                        catch (ProcessingException e) {
                            if (3.isCurrentJobCanceled()) break block3;
                            caller.dataFetched(null, e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return job;
        }
        try {
            caller.dataFetched(this.getDataByAll(), null);
        }
        catch (ProcessingException e) {
            caller.dataFetched(null, e);
        }
        return null;
    }

    public LookupRow[] getDataByRec() throws ProcessingException {
        if (this.getLookupService() != null) {
            return this.getLookupService().getDataByRec(this);
        }
        return new LookupRow[0];
    }

    public JobEx getDataByRecInBackground(final ILookupCallFetcher caller) {
        if (!(this instanceof LocalLookupCall)) {
            JobEx job = new JobEx(String.valueOf(this.getClass().getSimpleName()) + ".getDataByRecInBackground"){

                protected IStatus run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            LookupRow[] rows = LookupCall.this.getDataByRec();
                            if (!4.isCurrentJobCanceled()) {
                                caller.dataFetched(rows, null);
                            }
                        }
                        catch (ProcessingException e) {
                            if (4.isCurrentJobCanceled()) break block3;
                            caller.dataFetched(null, e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return job;
        }
        try {
            caller.dataFetched(this.getDataByRec(), null);
        }
        catch (ProcessingException e) {
            caller.dataFetched(null, e);
        }
        return null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(String.valueOf(this.getClass().getSimpleName()) + "[");
        if (this.m_key != null) {
            b.append("key=" + this.m_key + " ");
        }
        if (this.m_text != null) {
            b.append("text=" + this.m_text + " ");
        }
        if (this.m_all != null) {
            b.append("all=" + this.m_all + " ");
        }
        if (this.m_rec != null) {
            b.append("rec=" + this.m_rec + " ");
        }
        if (this.m_master != null) {
            b.append("master=" + this.m_master + " ");
        }
        if (this.m_maxRowCount > 0) {
            b.append("maxRowCount=" + this.m_maxRowCount + " ");
        }
        b.append("]");
        return b.toString();
    }
}

