/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.io.Serializable;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.MemoryOptimizedObject;

public class LookupRow
extends MemoryOptimizedObject
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int KEY_BIT = 1;
    public static final int TEXT_BIT = 2;
    public static final int ICON_ID_BIT = 3;
    public static final int TOOLTIP_BIT = 4;
    public static final int BACKGROUD_COLOR_BIT = 5;
    public static final int FOREGROUD_COLOR_BIT = 6;
    public static final int FONT_BIT = 7;
    public static final int ENABLED_BIT = 8;
    public static final int PARENT_KEY_BIT = 9;
    public static final int ACTIVE_BIT = 10;

    public LookupRow(Object key, String text) {
        this(key, text, null);
    }

    public LookupRow(Object key, String text, String iconId) {
        this(key, text, iconId, null);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip) {
        this(key, text, iconId, tooltip, null);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor) {
        this(key, text, iconId, tooltip, backgroundColor, null);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, null);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, true);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, enabled, null);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled, Object parentKey) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, enabled, parentKey, true);
    }

    public LookupRow(Object key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled, Object parentKey, boolean active) {
        this.setKey(key);
        this.setText(text);
        this.setIconId(iconId);
        this.setTooltipText(tooltip);
        this.setBackgroundColor(backgroundColor);
        this.setForegroundColor(foregroundColor);
        this.setFont(font);
        this.setEnabled(enabled);
        this.setParentKey(parentKey);
        this.setActive(active);
    }

    public LookupRow(Object[] cells) {
        this(cells, cells == null ? 0 : cells.length);
    }

    public LookupRow(Object[] cells, int maxColumnIndex) {
        if (cells != null) {
            int keyIndex = 0;
            int textIndex = 1;
            int iconIndex = 2;
            int ttIndex = 3;
            int bgIndex = 4;
            int fgIndex = 5;
            int fontIndex = 6;
            int enabledIndex = 7;
            int parentKeyIndex = 8;
            int activeIndex = 9;
            if (cells.length > keyIndex && keyIndex <= maxColumnIndex && cells[keyIndex] != null) {
                this.setKey(cells[keyIndex]);
            }
            if (cells.length > textIndex && textIndex <= maxColumnIndex && cells[textIndex] != null) {
                if (cells[textIndex] != null) {
                    this.setText(cells[textIndex].toString());
                } else {
                    this.setText(null);
                }
            }
            if (cells.length > iconIndex && iconIndex <= maxColumnIndex && cells[iconIndex] != null) {
                if (cells[iconIndex] != null) {
                    this.setIconId(cells[iconIndex].toString());
                } else {
                    this.setIconId(null);
                }
            }
            if (cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[ttIndex] != null) {
                    this.setTooltipText(cells[ttIndex].toString());
                } else {
                    this.setTooltipText(null);
                }
            }
            if (cells.length > bgIndex && bgIndex <= maxColumnIndex && cells[bgIndex] != null && cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[bgIndex] != null) {
                    this.setBackgroundColor(cells[bgIndex].toString());
                } else {
                    this.setBackgroundColor(null);
                }
            }
            if (cells.length > fgIndex && fgIndex <= maxColumnIndex && cells[fgIndex] != null && cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[fgIndex] != null) {
                    this.setForegroundColor(cells[fgIndex].toString());
                } else {
                    this.setForegroundColor(null);
                }
            }
            if (cells.length > fontIndex && fontIndex <= maxColumnIndex && cells[fontIndex] != null) {
                if (cells[fontIndex] != null) {
                    this.setFont(FontSpec.parse(cells[fontIndex].toString()));
                } else {
                    this.setFont(null);
                }
            }
            if (cells.length > enabledIndex && enabledIndex <= maxColumnIndex && cells[enabledIndex] != null) {
                if (cells[enabledIndex] instanceof Boolean) {
                    this.setEnabled((Boolean)cells[enabledIndex]);
                } else if (cells[enabledIndex] instanceof Number) {
                    this.setEnabled(((Number)cells[enabledIndex]).intValue() != 0);
                }
            }
            if (cells.length > parentKeyIndex && parentKeyIndex <= maxColumnIndex && cells[parentKeyIndex] != null) {
                this.setParentKey(cells[parentKeyIndex]);
            }
            if (cells.length > activeIndex && activeIndex <= maxColumnIndex && cells[activeIndex] != null) {
                if (cells[activeIndex] instanceof Boolean) {
                    this.setActive((Boolean)cells[activeIndex]);
                } else if (cells[activeIndex] instanceof Number) {
                    this.setActive(((Number)cells[activeIndex]).intValue() != 0);
                }
            }
        }
    }

    public Object getKey() {
        return this.getValueInternal(1);
    }

    public void setKey(Object key) {
        this.setValueInternal(1, key);
    }

    public Object getParentKey() {
        return this.getValueInternal(9);
    }

    public void setParentKey(Object parentKey) {
        this.setValueInternal(9, parentKey);
    }

    public String getText() {
        char[] c = (char[])this.getValueInternal(2);
        return c != null ? new String(c) : null;
    }

    public void setText(String text) {
        this.setValueInternal(2, text != null ? text.toCharArray() : null);
    }

    public String getIconId() {
        return (String)this.getValueInternal(3);
    }

    public void setIconId(String iconId) {
        this.setValueInternal(3, StringUtility.intern((String)iconId));
    }

    public String getTooltipText() {
        char[] c = (char[])this.getValueInternal(4);
        return c != null ? new String(c) : null;
    }

    public void setTooltipText(String tooltip) {
        this.setValueInternal(4, tooltip != null ? tooltip.toCharArray() : null);
    }

    public String getForegroundColor() {
        return (String)this.getValueInternal(6);
    }

    public void setForegroundColor(String foregroundColor) {
        this.setValueInternal(6, StringUtility.intern((String)foregroundColor));
    }

    public String getBackgroundColor() {
        return (String)this.getValueInternal(5);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.setValueInternal(5, StringUtility.intern((String)backgroundColor));
    }

    public FontSpec getFont() {
        String s = (String)this.getValueInternal(7);
        return s != null ? FontSpec.parse(s) : null;
    }

    public void setFont(FontSpec font) {
        this.setValueInternal(7, font != null ? StringUtility.intern((String)font.toPattern()) : null);
    }

    public boolean isEnabled() {
        if (this.getValueInternal(8) == null) {
            return true;
        }
        return (Boolean)this.getValueInternal(8);
    }

    public void setEnabled(boolean enabled) {
        this.setValueInternal(8, enabled ? null : Boolean.FALSE);
    }

    public boolean isActive() {
        if (this.getValueInternal(10) == null) {
            return true;
        }
        return (Boolean)this.getValueInternal(10);
    }

    public void setActive(boolean active) {
        this.setValueInternal(10, active ? null : Boolean.FALSE);
    }

    public static LookupRow[] createLookupRowArray(Object[][] data) {
        if (data == null || data.length == 0) {
            return new LookupRow[0];
        }
        LookupRow[] a = new LookupRow[data.length];
        int i = 0;
        while (i < data.length) {
            a[i] = new LookupRow(data[i]);
            ++i;
        }
        return a;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getKey() + ", " + this.getText() + "]";
    }
}

