/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class DebugInputStream
extends InputStream {
    private InputStream m_in;
    private ByteArrayOutputStream m_debugOut;
    private int m_lastReadCharacter;
    private Throwable m_lastThrownException;

    public DebugInputStream(InputStream in) throws IOException {
        this.m_in = in;
        this.m_debugOut = new ByteArrayOutputStream();
    }

    public String getContent(String encoding) throws UnsupportedEncodingException {
        return new String(this.m_debugOut.toByteArray(), encoding);
    }

    @Override
    public int available() throws IOException {
        return this.m_in.available();
    }

    @Override
    public void close() throws IOException {
        this.m_in.close();
        this.m_debugOut.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.m_in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.m_in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.m_lastReadCharacter = this.m_in.read();
            this.m_debugOut.write((char)this.m_lastReadCharacter);
            return this.m_lastReadCharacter;
        }
        catch (IOException ioe) {
            this.m_lastThrownException = ioe;
            throw ioe;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.m_in.skip(n);
    }

    public int getLastReadCharacter() {
        return this.m_lastReadCharacter;
    }

    public Throwable getLastThrownException() {
        return this.m_lastThrownException;
    }
}

