/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.Activator;
import org.eclipse.scout.rt.shared.servicetunnel.DebugInputStream;
import org.eclipse.scout.rt.shared.servicetunnel.DebugOutputStream;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelInputStream;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelOutputStream;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.osgi.framework.Bundle;

public class DefaultServiceTunnelContentHandler
implements IServiceTunnelContentHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultServiceTunnelContentHandler.class);
    private static final Pattern BEGIN_DATA_TAG = Pattern.compile("[<]([a-zA-Z0-9]+:)?data\\s*>");
    private static final Pattern END_DATA_TAG = Pattern.compile("[<][/]([a-zA-Z0-9]+:)?data\\s*>");
    private static final Pattern COMPRESSED_ATTRIBUTE = Pattern.compile("compressed\\s*=\\s*\"(true|false)\"");
    private static Boolean COMPRESS;
    private Bundle[] m_bundleList;
    private String m_originAddress;
    private Boolean m_sendCompressed;
    private Boolean m_receivedCompressed;
    private final EventListenerList m_listeners = new EventListenerList();

    static {
        String compressText = null;
        if (Activator.getDefault() != null) {
            compressText = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.serviceTunnel.compress");
        }
        COMPRESS = "true".equals(compressText) ? Boolean.valueOf(true) : ("false".equals(compressText) ? Boolean.valueOf(false) : null);
    }

    @Override
    public void initialize(Bundle[] classResolveBundles, ClassLoader rawClassLoader) {
        this.m_bundleList = classResolveBundles;
        try {
            this.m_originAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Throwable throwable) {}
        this.m_sendCompressed = COMPRESS;
    }

    @Override
    public void writeRequest(OutputStream out, ServiceTunnelRequest msg) throws Exception {
        boolean compressed = this.isUseCompression();
        StringBuilder buf = new StringBuilder();
        buf.append("<SOAP-ENV:Envelope SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">\n");
        buf.append("<SOAP-ENV:Body>\n");
        buf.append("  <request version=\"");
        buf.append(msg.getVersion());
        buf.append("\" compressed=\"");
        buf.append(compressed);
        buf.append("\" format=\"");
        buf.append(msg.getLocale().toString());
        buf.append("\" language=\"");
        buf.append(msg.getNlsLocale().toString());
        buf.append("\" service=\"");
        buf.append(msg.getServiceInterfaceClassName());
        buf.append("\" operation=\"");
        buf.append(msg.getOperation());
        buf.append("\"/>\n");
        buf.append("  <data>");
        long y = System.nanoTime();
        this.setData(buf, msg, compressed);
        y = System.nanoTime() - y;
        if (LOG.isDebugEnabled()) {
            LOG.debug("message encoding took " + y + " nanoseconds");
        }
        buf.append("</data>\n");
        buf.append("  <info");
        buf.append(" origin=\"" + this.m_originAddress + "\"");
        buf.append("/>\n");
        buf.append("</SOAP-ENV:Body>");
        buf.append("</SOAP-ENV:Envelope>");
        if (LOG.isDebugEnabled()) {
            out = new DebugOutputStream(out);
        }
        try {
            out.write(buf.toString().getBytes("UTF-8"));
        }
        finally {
            if (LOG.isDebugEnabled()) {
                String sentData = ((DebugOutputStream)out).getContent("UTF-8");
                int lastWrittenCharacter = ((DebugOutputStream)out).getLastWrittenCharacter();
                Throwable lastThrownException = ((DebugOutputStream)out).getLastThrownException();
                LOG.debug("lastWrittenCharacter=" + lastWrittenCharacter + ",lastThrownException=" + lastThrownException + ", sentData: " + sentData);
            }
        }
    }

    @Override
    public void writeResponse(OutputStream out, ServiceTunnelResponse msg) throws Exception {
        boolean compressed = this.isUseCompression();
        StringBuilder buf = new StringBuilder();
        buf.append("<SOAP-ENV:Envelope SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">\n");
        buf.append("<SOAP-ENV:Body>\n");
        if (msg.getException() == null) {
            buf.append("  <response status=\"OK\"");
            Object x = msg.getData();
            if (x != null) {
                buf.append(" type=\"" + x.getClass().getSimpleName() + "\"");
            } else {
                buf.append(" type=\"\"");
            }
            buf.append(" compressed=\"" + compressed + "\"");
            buf.append("/>\n");
        } else {
            buf.append("  <response status=\"ERROR\"");
            buf.append(" compressed=\"" + compressed + "\"");
            buf.append(">\n");
            buf.append("    <exception type=\"" + msg.getException().getClass().getSimpleName() + "\">");
            buf.append(msg.getException().getMessage());
            buf.append("</exception>\n");
            buf.append("  </response>\n");
        }
        buf.append("  <data>");
        long y = System.nanoTime();
        this.setData(buf, msg, compressed);
        y = System.nanoTime() - y;
        if (LOG.isDebugEnabled()) {
            LOG.debug("message encoding took " + y + " nanoseconds");
        }
        buf.append("</data>\n");
        buf.append("  <info");
        buf.append(" origin=\"" + this.m_originAddress + "\"");
        buf.append("/>\n");
        buf.append("</SOAP-ENV:Body>");
        buf.append("</SOAP-ENV:Envelope>");
        if (LOG.isDebugEnabled()) {
            out = new DebugOutputStream(out);
        }
        try {
            out.write(buf.toString().getBytes("UTF-8"));
        }
        finally {
            if (LOG.isDebugEnabled()) {
                String sentData = ((DebugOutputStream)out).getContent("UTF-8");
                int lastWrittenCharacter = ((DebugOutputStream)out).getLastWrittenCharacter();
                Throwable lastThrownException = ((DebugOutputStream)out).getLastThrownException();
                LOG.debug("lastWrittenCharacter=" + lastWrittenCharacter + ",lastThrownException=" + lastThrownException + ", sentData: " + sentData);
            }
        }
    }

    protected void setData(StringBuilder buf, Object msg, boolean compressed) throws IOException {
        Deflater deflater = null;
        ServiceTunnelOutputStream serialout = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (compressed) {
                deflater = new Deflater(1);
                DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bos, deflater);
                serialout = new ServiceTunnelOutputStream(deflaterStream);
                serialout.writeObject(msg);
                serialout.flush();
                deflaterStream.finish();
                serialout.close();
                serialout = null;
            } else {
                serialout = new ServiceTunnelOutputStream(bos);
                serialout.writeObject(msg);
                serialout.flush();
                serialout.close();
                serialout = null;
            }
            String base64Data = StringUtility.wrapText((String)Base64Utility.encode((byte[])bos.toByteArray()), (int)10000);
            buf.append(base64Data);
        }
        catch (Throwable throwable) {
            if (serialout != null) {
                try {
                    serialout.close();
                }
                catch (Throwable throwable2) {}
            }
            if (deflater != null) {
                try {
                    deflater.end();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (serialout != null) {
            try {
                serialout.close();
            }
            catch (Throwable throwable) {}
        }
        if (deflater != null) {
            try {
                deflater.end();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public ServiceTunnelRequest readRequest(InputStream in) throws Exception {
        return (ServiceTunnelRequest)this.read(in);
    }

    @Override
    public ServiceTunnelResponse readResponse(InputStream in) throws Exception {
        return (ServiceTunnelResponse)this.read(in);
    }

    protected Object read(InputStream in) throws Exception {
        boolean compressed;
        String dataPart;
        block10: {
            if (LOG.isDebugEnabled()) {
                in = new DebugInputStream(in);
            }
            dataPart = null;
            compressed = true;
            try {
                int ch;
                BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                StringBuilder buf = new StringBuilder();
                while ((ch = ((Reader)r).read()) >= 0) {
                    buf.append((char)ch);
                }
                String xml = buf.toString();
                buf.setLength(0);
                Matcher mc = COMPRESSED_ATTRIBUTE.matcher(xml);
                if (mc.find()) {
                    compressed = mc.group(1).equals("true");
                    this.m_receivedCompressed = compressed;
                }
                Matcher m1 = BEGIN_DATA_TAG.matcher(xml);
                Matcher m2 = END_DATA_TAG.matcher(xml);
                int lastMatchingIndex = 0;
                if (m1.find() && m2.find(m1.start())) {
                    do {
                        lastMatchingIndex = m2.start();
                    } while (m2.find());
                    dataPart = xml.substring(m1.end(), lastMatchingIndex);
                    break block10;
                }
                throw new IOException("missing a data tag");
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    String receivedData = ((DebugInputStream)in).getContent("UTF-8");
                    int lastReadCharacter = ((DebugInputStream)in).getLastReadCharacter();
                    Throwable lastThrownException = ((DebugInputStream)in).getLastThrownException();
                    LOG.debug("lastReadCharacter=" + lastReadCharacter + ",lastThrownException=" + lastThrownException + ", receivedData:\n" + receivedData);
                }
            }
        }
        long y = System.nanoTime();
        Object res = this.getData(dataPart, compressed);
        y = System.nanoTime() - y;
        if (LOG.isDebugEnabled()) {
            LOG.debug("message decoding took " + y + " nanoseconds");
        }
        return res;
    }

    protected Object getData(String dataPart, boolean compressed) throws IOException, ClassNotFoundException {
        Object object;
        Inflater inflater;
        block21: {
            String base64Data;
            ServiceTunnelInputStream serialin;
            block19: {
                Object object2;
                block20: {
                    inflater = null;
                    serialin = null;
                    try {
                        base64Data = dataPart.replaceAll("[\\n\\r]", "");
                        if (!compressed) break block19;
                        inflater = new Inflater();
                        InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(Base64Utility.decode((String)base64Data)), inflater);
                        serialin = new ServiceTunnelInputStream(inflaterStream, this.m_bundleList);
                        object2 = serialin.readObject();
                        if (serialin == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (serialin != null) {
                            try {
                                serialin.close();
                            }
                            catch (Throwable throwable2) {}
                        }
                        if (inflater != null) {
                            try {
                                inflater.end();
                            }
                            catch (Throwable throwable3) {}
                        }
                        throw throwable;
                    }
                    try {
                        serialin.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (inflater != null) {
                    try {
                        inflater.end();
                    }
                    catch (Throwable throwable) {}
                }
                return object2;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(Base64Utility.decode((String)base64Data));
            serialin = new ServiceTunnelInputStream(in, this.m_bundleList);
            object = serialin.readObject();
            if (serialin == null) break block21;
            try {
                serialin.close();
            }
            catch (Throwable throwable) {}
        }
        if (inflater != null) {
            try {
                inflater.end();
            }
            catch (Throwable throwable) {}
        }
        return object;
    }

    protected boolean isUseCompression() {
        if (this.m_sendCompressed != null) {
            return this.m_sendCompressed;
        }
        if (this.m_receivedCompressed != null) {
            return this.m_receivedCompressed;
        }
        return true;
    }
}

