/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.nls.NlsLocale;

public class ServiceTunnelRequest
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String m_serviceInterfaceClassName;
    private String m_operation;
    private Class[] m_parameterTypes;
    private Object[] m_args;
    private Locale m_nlsLocale;
    private Locale m_locale;
    private String m_version;
    private Object m_metaData;

    private ServiceTunnelRequest() {
    }

    public ServiceTunnelRequest(String version, Class serviceInterfaceClass, Method operation, Object[] args) {
        this(version, serviceInterfaceClass.getName(), operation.getName(), operation.getParameterTypes(), args);
    }

    public ServiceTunnelRequest(String version, String serviceInterfaceName, String op, Class[] parameterTypes, Object[] args) {
        this.m_version = version;
        this.m_serviceInterfaceClassName = serviceInterfaceName;
        this.m_operation = op;
        this.m_parameterTypes = parameterTypes;
        this.m_args = args;
        if (this.m_args == null) {
            this.m_args = new Object[0];
        }
        this.m_nlsLocale = NlsLocale.getDefault().getLocale();
        this.m_locale = Locale.getDefault();
    }

    public String getServiceInterfaceClassName() {
        return this.m_serviceInterfaceClassName;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getOperation() {
        return this.m_operation;
    }

    public Class[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public Object[] getArgs() {
        return this.m_args;
    }

    public Locale getNlsLocale() {
        return this.m_nlsLocale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Object getMetaData() {
        return this.m_metaData;
    }

    public void setMetaData(Object o) {
        this.m_metaData = o;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Service call " + this.m_serviceInterfaceClassName + "." + this.m_operation);
        if (this.m_args != null && this.m_args.length > 0) {
            int i = 0;
            while (i < this.m_args.length) {
                buf.append("\n");
                buf.append("arg[" + i + "]=" + VerboseUtility.dumpObject((Object)this.m_args[i]));
                ++i;
            }
        }
        return buf.toString();
    }

    public static String toSoapOperation(String className, String methodName) {
        if (className == null || methodName == null) {
            return null;
        }
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return String.valueOf(className) + "__" + methodName;
        }
        String simpleName = className.substring(i + 1);
        String packageName = className.substring(0, i);
        if ((i = packageName.lastIndexOf(46)) < 0) {
            return String.valueOf(packageName) + "_" + simpleName + "__" + methodName;
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = packageName.substring(0, i).split("[.]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            buf.append(s.charAt(0));
            ++n2;
        }
        buf.append("_");
        buf.append(packageName.substring(i + 1));
        buf.append("_");
        buf.append(simpleName);
        buf.append("__");
        buf.append(methodName);
        return buf.toString();
    }
}

