/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

public final class ValidationUtility {
    private ValidationUtility() {
    }

    public static void checkArray(String displayName, Object array) throws ProcessingException {
        if (array == null || !array.getClass().isArray()) {
            throw new ProcessingException(String.valueOf(displayName) + " is no array");
        }
    }

    public static void checkMandatoryValue(String displayName, Object value) throws ProcessingException {
        if (value == null) {
            throw new ProcessingException(String.valueOf(displayName) + " is required");
        }
    }

    public static void checkMandatoryArray(String displayName, Object array) throws ProcessingException {
        ValidationUtility.checkArray(displayName, array);
        if (Array.getLength(array) == 0) {
            throw new ProcessingException(String.valueOf(displayName) + " is required");
        }
    }

    public static void checkMinLength(String displayName, Object value, Object minLength) throws ProcessingException {
        if (value == null || minLength == null) {
            return;
        }
        int min = ((Number)minLength).intValue();
        if (value instanceof String ? ((String)value).length() < min : (value.getClass().isArray() ? Array.getLength(value) < min : (value instanceof Collection ? ((Collection)value).size() < min : (value instanceof Map ? ((Map)value).size() < min : value.toString().length() < min)))) {
            throw new ProcessingException(String.valueOf(displayName) + " is too short");
        }
    }

    public static void checkMaxLength(String displayName, Object value, Object maxLength) throws ProcessingException {
        if (value == null || maxLength == null) {
            return;
        }
        int max = ((Number)maxLength).intValue();
        if (value instanceof String ? ((String)value).length() > max : (value.getClass().isArray() ? Array.getLength(value) > max : (value instanceof Collection ? ((Collection)value).size() > max : (value instanceof Map ? ((Map)value).size() > max : value.toString().length() > max)))) {
            throw new ProcessingException(String.valueOf(displayName) + " is too long");
        }
    }

    public static void checkMinValue(String displayName, Object value, Object minValue) throws ProcessingException {
        if (value == null || minValue == null) {
            return;
        }
        Comparable min = (Comparable)minValue;
        if (value instanceof Comparable) {
            if (((Comparable)value).compareTo(min) < 0) {
                throw new ProcessingException(String.valueOf(displayName) + " is too small");
            }
        } else {
            throw new ProcessingException(String.valueOf(displayName) + " is not comparable");
        }
    }

    public static void checkMaxValue(String displayName, Object value, Object maxValue) throws ProcessingException {
        if (value == null || maxValue == null) {
            return;
        }
        Comparable max = (Comparable)maxValue;
        if (value instanceof Comparable) {
            if (((Comparable)value).compareTo(max) > 0) {
                throw new ProcessingException(String.valueOf(displayName) + " is too large");
            }
        } else {
            throw new ProcessingException(String.valueOf(displayName) + " is not comparable");
        }
    }

    public static void checkCodeTypeValue(String displayName, Object codeKey, ICodeType<?> codeType) throws ProcessingException {
        if (codeKey == null || codeType == null) {
            return;
        }
        if (codeType.getCode(codeKey) == null) {
            throw new ProcessingException(String.valueOf(displayName) + " " + codeKey + " is illegal for " + codeType.getClass().getSimpleName());
        }
    }

    public static void checkCodeTypeArray(String displayName, Object codeKeyArray, ICodeType<?> codeType) throws ProcessingException {
        if (codeKeyArray == null || codeType == null) {
            return;
        }
        ValidationUtility.checkArray(displayName, codeKeyArray);
        int len = Array.getLength(codeKeyArray);
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Object codeKey = Array.get(codeKeyArray, i);
            if (codeType.getCode(codeKey) == null) {
                throw new ProcessingException(String.valueOf(displayName) + " " + codeKey + " is illegal for " + codeType.getClass().getSimpleName());
            }
            ++i;
        }
    }

    public static void checkLookupCallValue(String displayName, Object lookupKey, LookupCall call) throws ProcessingException {
        if (lookupKey == null || call == null) {
            return;
        }
        call.setKey(lookupKey);
        if (call.getDataByKey().length == 0) {
            throw new ProcessingException(String.valueOf(displayName) + " " + lookupKey + " is illegal for " + call.getClass().getSimpleName());
        }
    }

    public static void checkLookupCallArray(String displayName, Object lookupKeyArray, LookupCall call) throws ProcessingException {
        if (lookupKeyArray == null || call == null) {
            return;
        }
        ValidationUtility.checkArray(displayName, lookupKeyArray);
        int len = Array.getLength(lookupKeyArray);
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Object lookupKey = Array.get(lookupKeyArray, i);
            call.setKey(lookupKey);
            if (call.getDataByKey().length == 0) {
                throw new ProcessingException(String.valueOf(displayName) + " " + lookupKey + " is illegal for " + call.getClass().getSimpleName());
            }
            ++i;
        }
    }

    public static void checkValueMatchesRegex(String displayName, Object value, Object regex) throws ProcessingException {
        Pattern p;
        if (value == null || regex == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ProcessingException(String.valueOf(displayName) + " value is no string");
        }
        if (regex instanceof String) {
            p = Pattern.compile((String)regex, 34);
        } else if (regex instanceof Pattern) {
            p = (Pattern)regex;
        } else {
            throw new ProcessingException(String.valueOf(displayName) + " regex is neither String nor Pattern");
        }
        if (!p.matcher((String)value).matches()) {
            throw new ProcessingException(String.valueOf(displayName) + " is not valid");
        }
    }

    public static void checkArrayMatchesRegex(String displayName, Object arrayOfStrings, Object regex) throws ProcessingException {
        Pattern p;
        if (arrayOfStrings == null || regex == null) {
            return;
        }
        ValidationUtility.checkArray(displayName, arrayOfStrings);
        int len = Array.getLength(arrayOfStrings);
        if (len == 0) {
            return;
        }
        if (regex instanceof String) {
            p = Pattern.compile((String)regex, 34);
        } else if (regex instanceof Pattern) {
            p = (Pattern)regex;
        } else {
            throw new ProcessingException(String.valueOf(displayName) + " regex is neither String nor Pattern");
        }
        int i = 0;
        while (i < len) {
            Object value = Array.get(arrayOfStrings, i);
            if (!(value instanceof String)) {
                throw new ProcessingException(String.valueOf(displayName) + " value is no string");
            }
            if (!p.matcher((String)value).matches()) {
                throw new ProcessingException(String.valueOf(displayName) + " is not valid");
            }
            ++i;
        }
    }

    public static abstract class ObjectTreeVisitor
    extends ObjectOutputStream {
        public ObjectTreeVisitor() throws IOException {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            try {
                boolean goOn = this.visitObject(obj);
                if (!goOn) {
                    return null;
                }
            }
            catch (Throwable t) {
                throw new ObjectTreeVisitorMarkerException(t);
            }
            return obj;
        }

        protected abstract boolean visitObject(Object var1) throws Exception;
    }

    public static final class ObjectTreeVisitorMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ObjectTreeVisitorMarkerException(Throwable cause) {
            super(cause);
        }
    }
}

