/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.nls.NlsLocale;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorHandler;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.UserInterruptedException;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.shared.services.common.security.SimplePrincipal;
import org.eclipse.scout.rt.ui.swing.DefaultSwingEnvironment;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.splash.SplashProgressMonitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public abstract class AbstractSwingApplication
implements IApplication {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwingApplication.class);
    private ISwingEnvironment m_env;
    private SplashProgressMonitor m_monitor;
    private ServiceRegistration m_monitorReg;

    public AbstractSwingApplication() {
        Matcher m;
        if (!Platform.inDevelopmentMode()) {
            try {
                URL instArea = Platform.getInstanceLocation().getURL();
                File sysoutRedirector = new File(instArea.getFile(), String.valueOf(System.getProperty("user.name", "anonymous")) + "-sysout.log");
                File syserrRedirector = new File(instArea.getFile(), String.valueOf(System.getProperty("user.name", "anonymous")) + "-syserr.log");
                sysoutRedirector.getParentFile().mkdirs();
                syserrRedirector.getParentFile().mkdirs();
                System.setOut(new PrintStream(new FileOutputStream(sysoutRedirector, true)));
                System.setErr(new PrintStream(new FileOutputStream(syserrRedirector, true)));
            }
            catch (Throwable throwable) {}
        }
        if ((m = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+)(_.*)?").matcher(System.getProperty("java.version", "0.0.0_00"))).matches() && new Version(m.group(1)).compareTo((Object)new Version(1, 6, 0)) < 0) {
            System.out.println("Swing requires at least Java 1.6.0 Current is " + m.group(1));
            System.exit(-1);
        }
        try {
            this.execInitLocale();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractSwingApplication.this.m_env = AbstractSwingApplication.this.createSwingEnvironment();
                }
            });
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
            System.exit(0);
        }
        this.m_monitor = new SplashProgressMonitor(this.m_env);
        if (Platform.getProduct() != null && Platform.getProduct().getDefiningBundle() != null) {
            BundleContext ctx = Platform.getProduct().getDefiningBundle().getBundleContext();
            this.m_monitorReg = ctx.registerService(IProgressMonitor.class.getName(), (Object)this.m_monitor, new Hashtable());
        }
        this.m_monitor.showSplash();
    }

    protected ISwingEnvironment createSwingEnvironment() {
        return new DefaultSwingEnvironment();
    }

    protected abstract IClientSession getClientSession();

    public ISwingEnvironment getSwingEnvironment() {
        return this.m_env;
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.m_monitor;
    }

    public Object start(final IApplicationContext context) throws Exception {
        if (Subject.getSubject(AccessController.getContext()) != null) {
            return this.exit(this.startInSubject(context));
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(System.getProperty("user.name")));
        return Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return AbstractSwingApplication.this.exit(AbstractSwingApplication.this.startInSubject(context));
            }
        });
    }

    protected Object exit(Object code) {
        if ("macosx".equals(Platform.getOS())) {
            System.exit(0);
        }
        return code;
    }

    protected void execInitLocale() {
        NlsLocale l = ClientUIPreferences.getInstance().getNlsLocale();
        if (l != null) {
            NlsLocale.setDefault((NlsLocale)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object startInSubject(IApplicationContext context) throws Exception {
        final IClientSession clientSession = this.getClientSession();
        if (!clientSession.isActive()) {
            this.showLoadError(clientSession.getLoadError());
            return EXIT_OK;
        }
        context.applicationRunning();
        if (this.m_monitorReg != null) {
            this.m_monitorReg.unregister();
        }
        this.m_monitor.done();
        this.m_monitor = null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractSwingApplication.this.m_env.showGUI(clientSession);
                    AbstractSwingApplication.this.execSwingStarted(clientSession);
                }
            });
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
            System.exit(0);
        }
        while (true) {
            Object object = clientSession.getStateLock();
            synchronized (object) {
                if (!clientSession.isActive()) {
                    return clientSession.getExitCode();
                }
                clientSession.getStateLock().wait();
            }
        }
    }

    protected void showLoadError(Throwable error) {
        ErrorHandler handler = new ErrorHandler(error);
        if (handler.getText().indexOf(UserInterruptedException.class.getSimpleName()) < 0) {
            JOptionPane.showMessageDialog(null, StringUtility.join((String)"\n\n", (String[])new String[]{handler.getText(), handler.getDetail()}), handler.getTitle(), 0);
        }
    }

    protected void execSwingStarted(IClientSession clientSession) {
    }

    public void stop() {
        this.getClientSession().stopSession();
    }
}

